@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin.inputs

import com.pulumi.alicloud.kms.inputs.GetSecretVersionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSecretVersions.
 * @property enableDetails Default to false and only output `secret_name`, `version_id`, `version_stages`. Set it to true can output more details.
 * @property ids A list of KMS Secret Version ids.
 * @property includeDeprecated Specifies whether to return deprecated secret versions. Default to `false`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property secretName The name of the secret.
 * @property versionStage The stage of the secret version.
 */
public data class GetSecretVersionsPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val includeDeprecated: String? = null,
    public val outputFile: String? = null,
    public val secretName: String,
    public val versionStage: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.kms.inputs.GetSecretVersionsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.kms.inputs.GetSecretVersionsPlainArgs =
        com.pulumi.alicloud.kms.inputs.GetSecretVersionsPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .includeDeprecated(includeDeprecated?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .secretName(secretName.let({ args0 -> args0 }))
            .versionStage(versionStage?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSecretVersionsPlainArgs].
 */
@PulumiTagMarker
public class GetSecretVersionsPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var includeDeprecated: String? = null

    private var outputFile: String? = null

    private var secretName: String? = null

    private var versionStage: String? = null

    /**
     * @param value Default to false and only output `secret_name`, `version_id`, `version_stages`. Set it to true can output more details.
     */
    @JvmName("hrmjhdmommedqaoa")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of KMS Secret Version ids.
     */
    @JvmName("qbegwpjtfwieabht")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of KMS Secret Version ids.
     */
    @JvmName("ooglvwtlquqlltye")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Specifies whether to return deprecated secret versions. Default to `false`.
     */
    @JvmName("esqlogqnfssngdpe")
    public suspend fun includeDeprecated(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeDeprecated = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("eiwgadkgxbioifia")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The name of the secret.
     */
    @JvmName("jhpbixtjpebdsowj")
    public suspend fun secretName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.secretName = mapped
    }

    /**
     * @param value The stage of the secret version.
     */
    @JvmName("qabqnojngwkcjjjj")
    public suspend fun versionStage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.versionStage = mapped
    }

    internal fun build(): GetSecretVersionsPlainArgs = GetSecretVersionsPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        includeDeprecated = includeDeprecated,
        outputFile = outputFile,
        secretName = secretName ?: throw PulumiNullFieldException("secretName"),
        versionStage = versionStage,
    )
}
