@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin.inputs

import com.pulumi.alicloud.kms.inputs.GetSecretsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSecrets.
 * @property enableDetails Default to `false`. Set it to true can output more details.
 * @property fetchTags Whether to include the predetermined resource tag in the return value. Default to `false`.
 * @property filters The secret filter. The filter consists of one or more key-value pairs.
 * More details see API [ListSecrets](https://www.alibabacloud.com/help/en/key-management-service/latest/listsecrets).
 * @property ids A list of KMS Secret ids. The value is same as KMS secret_name.
 * @property nameRegex A regex string to filter the results by the KMS secret_name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property tags A mapping of tags to assign to the resource.
 */
public data class GetSecretsPlainArgs(
    public val enableDetails: Boolean? = null,
    public val fetchTags: Boolean? = null,
    public val filters: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.kms.inputs.GetSecretsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.kms.inputs.GetSecretsPlainArgs =
        com.pulumi.alicloud.kms.inputs.GetSecretsPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .fetchTags(fetchTags?.let({ args0 -> args0 }))
            .filters(filters?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetSecretsPlainArgs].
 */
@PulumiTagMarker
public class GetSecretsPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var fetchTags: Boolean? = null

    private var filters: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Default to `false`. Set it to true can output more details.
     */
    @JvmName("gvvhpiujsbtguiif")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value Whether to include the predetermined resource tag in the return value. Default to `false`.
     */
    @JvmName("aihwlpabhiytaygj")
    public suspend fun fetchTags(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.fetchTags = mapped
    }

    /**
     * @param value The secret filter. The filter consists of one or more key-value pairs.
     * More details see API [ListSecrets](https://www.alibabacloud.com/help/en/key-management-service/latest/listsecrets).
     */
    @JvmName("brxdgjleqotpugau")
    public suspend fun filters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value A list of KMS Secret ids. The value is same as KMS secret_name.
     */
    @JvmName("igfmrbohaelwjphq")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of KMS Secret ids. The value is same as KMS secret_name.
     */
    @JvmName("jxlqwuokipcwlbkg")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter the results by the KMS secret_name.
     */
    @JvmName("ssvqmefxdpjvoeee")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ufwabklcvymgrglw")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("vkcvrktqgxruvuwj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("vuejdsjfiahuujjw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetSecretsPlainArgs = GetSecretsPlainArgs(
        enableDetails = enableDetails,
        fetchTags = fetchTags,
        filters = filters,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        tags = tags,
    )
}
