@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin.inputs

import com.pulumi.alicloud.kms.inputs.InstanceBindVpcArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property regionId region id.
 * @property vpcId VPC ID.
 * @property vpcOwnerId VPC owner root user ID.
 * @property vswitchId vswitch id.
 */
public data class InstanceBindVpcArgs(
    public val regionId: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vpcOwnerId: Output<Int>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.kms.inputs.InstanceBindVpcArgs> {
    override fun toJava(): com.pulumi.alicloud.kms.inputs.InstanceBindVpcArgs =
        com.pulumi.alicloud.kms.inputs.InstanceBindVpcArgs.builder()
            .regionId(regionId?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vpcOwnerId(vpcOwnerId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceBindVpcArgs].
 */
@PulumiTagMarker
public class InstanceBindVpcArgsBuilder internal constructor() {
    private var regionId: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vpcOwnerId: Output<Int>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value region id.
     */
    @JvmName("ntsovshpnlivtvhh")
    public suspend fun regionId(`value`: Output<String>) {
        this.regionId = value
    }

    /**
     * @param value VPC ID.
     */
    @JvmName("iqfheowlqreakxss")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value VPC owner root user ID.
     */
    @JvmName("dfgluuaeifcqvoes")
    public suspend fun vpcOwnerId(`value`: Output<Int>) {
        this.vpcOwnerId = value
    }

    /**
     * @param value vswitch id.
     */
    @JvmName("vvxqcljubvknkgvt")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value region id.
     */
    @JvmName("uxrjcrqfrqybfmga")
    public suspend fun regionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionId = mapped
    }

    /**
     * @param value VPC ID.
     */
    @JvmName("kxlmqmfybgxsolek")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value VPC owner root user ID.
     */
    @JvmName("pbrsitxvdphmnmss")
    public suspend fun vpcOwnerId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcOwnerId = mapped
    }

    /**
     * @param value vswitch id.
     */
    @JvmName("mqeccjknnneokear")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): InstanceBindVpcArgs = InstanceBindVpcArgs(
        regionId = regionId,
        vpcId = vpcId,
        vpcOwnerId = vpcOwnerId,
        vswitchId = vswitchId,
    )
}
