@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property aliasName The unique identifier of the alias.
 * @property id ID of the alias. The value is same as KMS alias_name.
 * @property keyId ID of the key.
 */
public data class GetAliasesAlias(
    public val aliasName: String,
    public val id: String,
    public val keyId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.kms.outputs.GetAliasesAlias): GetAliasesAlias = GetAliasesAlias(
            aliasName = javaType.aliasName(),
            id = javaType.id(),
            keyId = javaType.keyId(),
        )
    }
}
