@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAliases.
 * @property aliases A list of KMS User alias. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of kms aliases IDs. The value is same as KMS alias_name.
 * @property nameRegex
 * @property names A list of KMS alias name.
 * @property outputFile
 */
public data class GetAliasesResult(
    public val aliases: List<GetAliasesAlias>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.kms.outputs.GetAliasesResult): GetAliasesResult = GetAliasesResult(
            aliases = javaType.aliases().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.kms.kotlin.outputs.GetAliasesAlias.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
