@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getKeyVersions.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of KMS KeyVersion IDs.
 * @property keyId ID of the key.
 * @property outputFile
 * @property versions A list of KMS KeyVersions. Each element contains the following attributes:
 */
public data class GetKeyVersionsResult(
    public val id: String,
    public val ids: List<String>,
    public val keyId: String,
    public val outputFile: String? = null,
    public val versions: List<GetKeyVersionsVersion>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.kms.outputs.GetKeyVersionsResult): GetKeyVersionsResult = GetKeyVersionsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            keyId = javaType.keyId(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            versions = javaType.versions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.kms.kotlin.outputs.GetKeyVersionsVersion.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
