@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime Date and time when the key version was created (UTC time).
 * @property creationDate (Removed from v1.124.4) It has been removed and using `create_time` instead.
 * @property id ID of the KMS KeyVersion resource.
 * @property keyId The id of kms key.
 * @property keyVersionId ID of the key version.
 */
public data class GetKeyVersionsVersion(
    public val createTime: String,
    public val creationDate: String,
    public val id: String,
    public val keyId: String,
    public val keyVersionId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.kms.outputs.GetKeyVersionsVersion): GetKeyVersionsVersion = GetKeyVersionsVersion(
            createTime = javaType.createTime(),
            creationDate = javaType.creationDate(),
            id = javaType.id(),
            keyId = javaType.keyId(),
            keyVersionId = javaType.keyVersionId(),
        )
    }
}
