@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn The Alibaba Cloud Resource Name (ARN) of the key.
 * @property automaticRotation (Available in 1.123.1+) Specifies whether to enable automatic key rotation.
 * @property creationDate Creation date of key.
 * @property creator The owner of the key.
 * @property deleteDate Deletion date of key.
 * @property description Description of the key.
 * @property id ID of the key.
 * @property keyId (Available in 1.123.1+)  ID of the key.
 * @property keySpec (Available in 1.123.1+)  The type of the CMK.
 * @property keyUsage (Available in 1.123.1+)  The usage of CMK.
 * @property lastRotationDate (Available in 1.123.1+)  The date and time the last rotation was performed.
 * @property materialExpireTime (Available in 1.123.1+)  The time and date the key material for the CMK expires.
 * @property nextRotationDate (Available in 1.123.1+)  The time the next rotation is scheduled for execution.
 * @property origin (Available in 1.123.1+)  The source of the key material for the CMK.
 * @property primaryKeyVersion (Available in 1.123.1+)  The ID of the current primary key version of the symmetric CMK.
 * @property protectionLevel (Available in 1.123.1+)  The protection level of the CMK.
 * @property rotationInterval (Available in 1.123.1+)  The period of automatic key rotation.
 * @property status Filter the results by status of the KMS keys. Valid values: `Enabled`, `Disabled`, `PendingDeletion`.
 */
public data class GetKeysKey(
    public val arn: String,
    public val automaticRotation: String,
    public val creationDate: String,
    public val creator: String,
    public val deleteDate: String,
    public val description: String,
    public val id: String,
    public val keyId: String,
    public val keySpec: String,
    public val keyUsage: String,
    public val lastRotationDate: String,
    public val materialExpireTime: String,
    public val nextRotationDate: String,
    public val origin: String,
    public val primaryKeyVersion: String,
    public val protectionLevel: String,
    public val rotationInterval: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.kms.outputs.GetKeysKey): GetKeysKey =
            GetKeysKey(
                arn = javaType.arn(),
                automaticRotation = javaType.automaticRotation(),
                creationDate = javaType.creationDate(),
                creator = javaType.creator(),
                deleteDate = javaType.deleteDate(),
                description = javaType.description(),
                id = javaType.id(),
                keyId = javaType.keyId(),
                keySpec = javaType.keySpec(),
                keyUsage = javaType.keyUsage(),
                lastRotationDate = javaType.lastRotationDate(),
                materialExpireTime = javaType.materialExpireTime(),
                nextRotationDate = javaType.nextRotationDate(),
                origin = javaType.origin(),
                primaryKeyVersion = javaType.primaryKeyVersion(),
                protectionLevel = javaType.protectionLevel(),
                rotationInterval = javaType.rotationInterval(),
                status = javaType.status(),
            )
    }
}
