@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getKeys.
 * @property descriptionRegex
 * @property enableDetails
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of KMS key IDs.
 * @property keys A list of KMS keys. Each element contains the following attributes:
 * @property outputFile
 * @property status Status of the key. Possible values: `Enabled`, `Disabled` and `PendingDeletion`.
 */
public data class GetKeysResult(
    public val descriptionRegex: String? = null,
    public val enableDetails: Boolean? = null,
    public val filters: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val keys: List<GetKeysKey>,
    public val outputFile: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.kms.outputs.GetKeysResult): GetKeysResult =
            GetKeysResult(
                descriptionRegex = javaType.descriptionRegex().map({ args0 -> args0 }).orElse(null),
                enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
                filters = javaType.filters().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                keys = javaType.keys().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.kms.kotlin.outputs.GetKeysKey.Companion.toKotlin(args0)
                    })
                }),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
            )
    }
}
