@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getPlaintext.
 * @property ciphertextBlob
 * @property encryptionContext
 * @property id The provider-assigned unique ID for this managed resource.
 * @property keyId The globally unique ID of the CMK. It is the ID of the CMK used to decrypt ciphertext.
 * @property plaintext The decrypted plaintext.
 */
public data class GetPlaintextResult(
    public val ciphertextBlob: String,
    public val encryptionContext: Map<String, String>? = null,
    public val id: String,
    public val keyId: String,
    public val plaintext: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.kms.outputs.GetPlaintextResult): GetPlaintextResult = GetPlaintextResult(
            ciphertextBlob = javaType.ciphertextBlob(),
            encryptionContext = javaType.encryptionContext().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            id = javaType.id(),
            keyId = javaType.keyId(),
            plaintext = javaType.plaintext(),
        )
    }
}
