@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSecretVersions.
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Kms Secret Version ids.
 * @property includeDeprecated
 * @property outputFile
 * @property secretName The name of the secret.
 * @property versionStage
 * @property versions A list of KMS Secret Versions. Each element contains the following attributes:
 */
public data class GetSecretVersionsResult(
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val includeDeprecated: String? = null,
    public val outputFile: String? = null,
    public val secretName: String,
    public val versionStage: String? = null,
    public val versions: List<GetSecretVersionsVersion>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.kms.outputs.GetSecretVersionsResult): GetSecretVersionsResult = GetSecretVersionsResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            includeDeprecated = javaType.includeDeprecated().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            secretName = javaType.secretName(),
            versionStage = javaType.versionStage().map({ args0 -> args0 }).orElse(null),
            versions = javaType.versions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.kms.kotlin.outputs.GetSecretVersionsVersion.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
