@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property secretData The secret value. Secrets Manager decrypts the stored secret value in ciphertext and returns it. (Returned when `enable_details` is true).
 * @property secretDataType The type of the secret value. (Returned when `enable_details` is true).
 * @property secretName The name of the secret.
 * @property versionId The version number of the secret value.
 * @property versionStages Stage labels that mark the secret version.
 */
public data class GetSecretVersionsVersion(
    public val secretData: String,
    public val secretDataType: String,
    public val secretName: String,
    public val versionId: String,
    public val versionStages: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.kms.outputs.GetSecretVersionsVersion): GetSecretVersionsVersion = GetSecretVersionsVersion(
            secretData = javaType.secretData(),
            secretDataType = javaType.secretDataType(),
            secretName = javaType.secretName(),
            versionId = javaType.versionId(),
            versionStages = javaType.versionStages().map({ args0 -> args0 }),
        )
    }
}
