@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getSecrets.
 * @property enableDetails
 * @property fetchTags
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Kms Secret ids. The value is same as KMS secret_name.
 * @property nameRegex
 * @property names A list of KMS Secret names.
 * @property outputFile
 * @property secrets A list of KMS Secrets. Each element contains the following attributes:
 * @property tags (Optional) A mapping of tags to assign to the resource.
 */
public data class GetSecretsResult(
    public val enableDetails: Boolean? = null,
    public val fetchTags: Boolean? = null,
    public val filters: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val secrets: List<GetSecretsSecret>,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.kms.outputs.GetSecretsResult): GetSecretsResult = GetSecretsResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            fetchTags = javaType.fetchTags().map({ args0 -> args0 }).orElse(null),
            filters = javaType.filters().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            secrets = javaType.secrets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.kms.kotlin.outputs.GetSecretsSecret.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
