@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property arn (Available in 1.124.0+) A mapping of tags to assign to the resource.
 * @property description (Available in 1.124.0+)  The description of the secret.
 * @property encryptionKeyId (Available in 1.124.0+)  The ID of the KMS CMK that is used to encrypt the secret value.
 * @property id ID of the Kms Secret. The value is same as KMS secret_name.
 * @property plannedDeleteTime Schedule deletion time.
 * @property secretData (Available in 1.124.0+)  The value of the secret that you want to create.
 * @property secretDataType (Available in 1.124.0+)  The type of the secret data value.
 * @property secretName Name of the KMS Secret.
 * @property secretType (Available in 1.124.0+)  The type of the secret.
 * @property tags A mapping of tags to assign to the resource.
 * @property versionId (Available in 1.124.0+)  The version number of the initial version.
 * @property versionStages (Available in 1.124.0+)  The stage labels that mark the new secret version.
 */
public data class GetSecretsSecret(
    public val arn: String,
    public val description: String,
    public val encryptionKeyId: String,
    public val id: String,
    public val plannedDeleteTime: String,
    public val secretData: String,
    public val secretDataType: String,
    public val secretName: String,
    public val secretType: String,
    public val tags: Map<String, String>,
    public val versionId: String,
    public val versionStages: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.kms.outputs.GetSecretsSecret): GetSecretsSecret = GetSecretsSecret(
            arn = javaType.arn(),
            description = javaType.description(),
            encryptionKeyId = javaType.encryptionKeyId(),
            id = javaType.id(),
            plannedDeleteTime = javaType.plannedDeleteTime(),
            secretData = javaType.secretData(),
            secretDataType = javaType.secretDataType(),
            secretName = javaType.secretName(),
            secretType = javaType.secretType(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            versionId = javaType.versionId(),
            versionStages = javaType.versionStages().map({ args0 -> args0 }),
        )
    }
}
