@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kotlin

import com.pulumi.alicloud.AlicloudFunctions.getAccountPlain
import com.pulumi.alicloud.AlicloudFunctions.getCallerIdentityPlain
import com.pulumi.alicloud.AlicloudFunctions.getFileCrc64ChecksumPlain
import com.pulumi.alicloud.AlicloudFunctions.getMscSubContactVerificationMessagePlain
import com.pulumi.alicloud.AlicloudFunctions.getMscSubContactsPlain
import com.pulumi.alicloud.AlicloudFunctions.getMscSubSubscriptionsPlain
import com.pulumi.alicloud.AlicloudFunctions.getMscSubWebhooksPlain
import com.pulumi.alicloud.AlicloudFunctions.getRegionsPlain
import com.pulumi.alicloud.AlicloudFunctions.getZonesPlain
import com.pulumi.alicloud.kotlin.inputs.GetFileCrc64ChecksumPlainArgs
import com.pulumi.alicloud.kotlin.inputs.GetFileCrc64ChecksumPlainArgsBuilder
import com.pulumi.alicloud.kotlin.inputs.GetMscSubContactVerificationMessagePlainArgs
import com.pulumi.alicloud.kotlin.inputs.GetMscSubContactVerificationMessagePlainArgsBuilder
import com.pulumi.alicloud.kotlin.inputs.GetMscSubContactsPlainArgs
import com.pulumi.alicloud.kotlin.inputs.GetMscSubContactsPlainArgsBuilder
import com.pulumi.alicloud.kotlin.inputs.GetMscSubSubscriptionsPlainArgs
import com.pulumi.alicloud.kotlin.inputs.GetMscSubSubscriptionsPlainArgsBuilder
import com.pulumi.alicloud.kotlin.inputs.GetMscSubWebhooksPlainArgs
import com.pulumi.alicloud.kotlin.inputs.GetMscSubWebhooksPlainArgsBuilder
import com.pulumi.alicloud.kotlin.inputs.GetRegionsPlainArgs
import com.pulumi.alicloud.kotlin.inputs.GetRegionsPlainArgsBuilder
import com.pulumi.alicloud.kotlin.inputs.GetZonesPlainArgs
import com.pulumi.alicloud.kotlin.inputs.GetZonesPlainArgsBuilder
import com.pulumi.alicloud.kotlin.outputs.GetAccountResult
import com.pulumi.alicloud.kotlin.outputs.GetCallerIdentityResult
import com.pulumi.alicloud.kotlin.outputs.GetFileCrc64ChecksumResult
import com.pulumi.alicloud.kotlin.outputs.GetMscSubContactVerificationMessageResult
import com.pulumi.alicloud.kotlin.outputs.GetMscSubContactsResult
import com.pulumi.alicloud.kotlin.outputs.GetMscSubSubscriptionsResult
import com.pulumi.alicloud.kotlin.outputs.GetMscSubWebhooksResult
import com.pulumi.alicloud.kotlin.outputs.GetRegionsResult
import com.pulumi.alicloud.kotlin.outputs.GetZonesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.kotlin.outputs.GetAccountResult.Companion.toKotlin as getAccountResultToKotlin
import com.pulumi.alicloud.kotlin.outputs.GetCallerIdentityResult.Companion.toKotlin as getCallerIdentityResultToKotlin
import com.pulumi.alicloud.kotlin.outputs.GetFileCrc64ChecksumResult.Companion.toKotlin as getFileCrc64ChecksumResultToKotlin
import com.pulumi.alicloud.kotlin.outputs.GetMscSubContactVerificationMessageResult.Companion.toKotlin as getMscSubContactVerificationMessageResultToKotlin
import com.pulumi.alicloud.kotlin.outputs.GetMscSubContactsResult.Companion.toKotlin as getMscSubContactsResultToKotlin
import com.pulumi.alicloud.kotlin.outputs.GetMscSubSubscriptionsResult.Companion.toKotlin as getMscSubSubscriptionsResultToKotlin
import com.pulumi.alicloud.kotlin.outputs.GetMscSubWebhooksResult.Companion.toKotlin as getMscSubWebhooksResultToKotlin
import com.pulumi.alicloud.kotlin.outputs.GetRegionsResult.Companion.toKotlin as getRegionsResultToKotlin
import com.pulumi.alicloud.kotlin.outputs.GetZonesResult.Companion.toKotlin as getZonesResultToKotlin

public object AlicloudFunctions {
    /**
     * This data source provides information about the current account.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const current = alicloud.getAccount({});
     * export const currentAccountId = current.then(current => current.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * current = alicloud.get_account()
     * pulumi.export("currentAccountId", current.id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = AliCloud.GetAccount.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["currentAccountId"] = current.Apply(getAccountResult => getAccountResult.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		current, err := alicloud.GetAccount(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("currentAccountId", current.Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.AlicloudFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = AlicloudFunctions.getAccount();
     *         ctx.export("currentAccountId", current.applyValue(getAccountResult -> getAccountResult.id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: alicloud:getAccount
     *       Arguments: {}
     * outputs:
     *   currentAccountId: ${current.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument This data source provides information about the current account.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const current = alicloud.getAccount({});
     * export const currentAccountId = current.then(current => current.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * current = alicloud.get_account()
     * pulumi.export("currentAccountId", current.id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = AliCloud.GetAccount.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["currentAccountId"] = current.Apply(getAccountResult => getAccountResult.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		current, err := alicloud.GetAccount(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("currentAccountId", current.Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.AlicloudFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = AlicloudFunctions.getAccount();
     *         ctx.export("currentAccountId", current.applyValue(getAccountResult -> getAccountResult.id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: alicloud:getAccount
     *       Arguments: {}
     * outputs:
     *   currentAccountId: ${current.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @return A collection of values returned by getAccount.
     */
    public suspend fun getAccount(): GetAccountResult =
        getAccountResultToKotlin(getAccountPlain().await())

    /**
     * This data source provides the identity of the current user.
     * > **NOTE:** Available in 1.65.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const current = alicloud.getCallerIdentity({});
     * export const currentUserArn = current.then(current => current.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * current = alicloud.get_caller_identity()
     * pulumi.export("currentUserArn", current.id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = AliCloud.GetCallerIdentity.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["currentUserArn"] = current.Apply(getCallerIdentityResult => getCallerIdentityResult.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		current, err := alicloud.GetCallerIdentity(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("currentUserArn", current.Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.AlicloudFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = AlicloudFunctions.getCallerIdentity();
     *         ctx.export("currentUserArn", current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: alicloud:getCallerIdentity
     *       Arguments: {}
     * outputs:
     *   currentUserArn: ${current.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument This data source provides the identity of the current user.
     * > **NOTE:** Available in 1.65.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const current = alicloud.getCallerIdentity({});
     * export const currentUserArn = current.then(current => current.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * current = alicloud.get_caller_identity()
     * pulumi.export("currentUserArn", current.id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = AliCloud.GetCallerIdentity.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["currentUserArn"] = current.Apply(getCallerIdentityResult => getCallerIdentityResult.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		current, err := alicloud.GetCallerIdentity(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("currentUserArn", current.Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.AlicloudFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = AlicloudFunctions.getCallerIdentity();
     *         ctx.export("currentUserArn", current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: alicloud:getCallerIdentity
     *       Arguments: {}
     * outputs:
     *   currentUserArn: ${current.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @return A collection of values returned by getCallerIdentity.
     */
    public suspend fun getCallerIdentity(): GetCallerIdentityResult =
        getCallerIdentityResultToKotlin(getCallerIdentityPlain().await())

    /**
     * This data source compute file crc64 checksum.
     * > **NOTE:** Available in 1.59.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.getFileCrc64Checksum({
     *     filename: "exampleFileName",
     * });
     * export const fileCrc64Checksum = defualt.checksum;
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.get_file_crc64_checksum(filename="exampleFileName")
     * pulumi.export("fileCrc64Checksum", defualt["checksum"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.GetFileCrc64Checksum.Invoke(new()
     *     {
     *         Filename = "exampleFileName",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["fileCrc64Checksum"] = defualt.Checksum,
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := alicloud.GetFileCrc64Checksum(ctx, &alicloud.GetFileCrc64ChecksumArgs{
     * 			Filename: "exampleFileName",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("fileCrc64Checksum", defualt.Checksum)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.AlicloudFunctions;
     * import com.pulumi.alicloud.inputs.GetFileCrc64ChecksumArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = AlicloudFunctions.getFileCrc64Checksum(GetFileCrc64ChecksumArgs.builder()
     *             .filename("exampleFileName")
     *             .build());
     *         ctx.export("fileCrc64Checksum", defualt.checksum());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:getFileCrc64Checksum
     *       Arguments:
     *         filename: exampleFileName
     * outputs:
     *   fileCrc64Checksum: ${defualt.checksum}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getFileCrc64Checksum.
     * @return A collection of values returned by getFileCrc64Checksum.
     */
    public suspend fun getFileCrc64Checksum(argument: GetFileCrc64ChecksumPlainArgs): GetFileCrc64ChecksumResult =
        getFileCrc64ChecksumResultToKotlin(getFileCrc64ChecksumPlain(argument.toJava()).await())

    /**
     * @see [getFileCrc64Checksum].
     * @param filename The name of the file to be computed crc64 checksum.
     * @param outputFile
     * @return A collection of values returned by getFileCrc64Checksum.
     */
    public suspend fun getFileCrc64Checksum(filename: String, outputFile: String? = null): GetFileCrc64ChecksumResult {
        val argument = GetFileCrc64ChecksumPlainArgs(
            filename = filename,
            outputFile = outputFile,
        )
        return getFileCrc64ChecksumResultToKotlin(getFileCrc64ChecksumPlain(argument.toJava()).await())
    }

    /**
     * @see [getFileCrc64Checksum].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;kotlin&#46;inputs&#46;GetFileCrc64ChecksumPlainArgs].
     * @return A collection of values returned by getFileCrc64Checksum.
     */
    public suspend fun getFileCrc64Checksum(argument: suspend GetFileCrc64ChecksumPlainArgsBuilder.() -> Unit): GetFileCrc64ChecksumResult {
        val builder = GetFileCrc64ChecksumPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFileCrc64ChecksumResultToKotlin(getFileCrc64ChecksumPlain(builtArgument.toJava()).await())
    }

    /**
     * > **NOTE:** Available in v1.156.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const defaultMscSubContract = new alicloud.MscSubContract("default", {
     *     contactName: "example_value",
     *     position: "CEO",
     *     email: "123@163.com",
     *     mobile: "153xxxxx906",
     * });
     * const default = defaultMscSubContract.id.apply(id => alicloud.getMscSubContactVerificationMessageOutput({
     *     contactId: id,
     *     type: 1,
     * }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default_msc_sub_contract = alicloud.MscSubContract("default",
     *     contact_name="example_value",
     *     position="CEO",
     *     email="123@163.com",
     *     mobile="153xxxxx906")
     * default = default_msc_sub_contract.id.apply(lambda id: alicloud.get_msc_sub_contact_verification_message_output(contact_id=id,
     *     type=1))
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var defaultMscSubContract = new AliCloud.MscSubContract("default", new()
     *     {
     *         ContactName = "example_value",
     *         Position = "CEO",
     *         Email = "123@163.com",
     *         Mobile = "153xxxxx906",
     *     });
     *     var @default = AliCloud.GetMscSubContactVerificationMessage.Invoke(new()
     *     {
     *         ContactId = defaultMscSubContract.Id,
     *         Type = 1,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		defaultMscSubContract, err := alicloud.NewMscSubContract(ctx, "default", &alicloud.MscSubContractArgs{
     * 			ContactName: pulumi.String("example_value"),
     * 			Position:    pulumi.String("CEO"),
     * 			Email:       pulumi.String("123@163.com"),
     * 			Mobile:      pulumi.String("153xxxxx906"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_ = defaultMscSubContract.ID().ApplyT(func(id string) (alicloud.GetMscSubContactVerificationMessageResult, error) {
     * 			return alicloud.GetMscSubContactVerificationMessageResult(interface{}(alicloud.GetMscSubContactVerificationMessageOutput(ctx, alicloud.GetMscSubContactVerificationMessageOutputArgs{
     * 				ContactId: id,
     * 				Type:      1,
     * 			}, nil))), nil
     * 		}).(alicloud.GetMscSubContactVerificationMessageResultOutput)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.MscSubContract;
     * import com.pulumi.alicloud.MscSubContractArgs;
     * import com.pulumi.alicloud.AlicloudFunctions;
     * import com.pulumi.alicloud.inputs.GetMscSubContactVerificationMessageArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var defaultMscSubContract = new MscSubContract("defaultMscSubContract", MscSubContractArgs.builder()
     *             .contactName("example_value")
     *             .position("CEO")
     *             .email("123@163.com")
     *             .mobile("153xxxxx906")
     *             .build());
     *         final var default = AlicloudFunctions.getMscSubContactVerificationMessage(GetMscSubContactVerificationMessageArgs.builder()
     *             .contactId(defaultMscSubContract.id())
     *             .type(1)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   defaultMscSubContract:
     *     type: alicloud:MscSubContract
     *     name: default
     *     properties:
     *       contactName: example_value
     *       position: CEO
     *       email: 123@163.com
     *       mobile: 153xxxxx906
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:getMscSubContactVerificationMessage
     *       Arguments:
     *         contactId: ${defaultMscSubContract.id}
     *         type: 1
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getMscSubContactVerificationMessage.
     * @return A collection of values returned by getMscSubContactVerificationMessage.
     */
    public suspend fun getMscSubContactVerificationMessage(argument: GetMscSubContactVerificationMessagePlainArgs): GetMscSubContactVerificationMessageResult =
        getMscSubContactVerificationMessageResultToKotlin(getMscSubContactVerificationMessagePlain(argument.toJava()).await())

    /**
     * @see [getMscSubContactVerificationMessage].
     * @param contactId The ID of the Contact.
     * @param type How a user receives verification messages. Valid values : `1`, `2`.
     * @return A collection of values returned by getMscSubContactVerificationMessage.
     */
    public suspend fun getMscSubContactVerificationMessage(contactId: String, type: Int): GetMscSubContactVerificationMessageResult {
        val argument = GetMscSubContactVerificationMessagePlainArgs(
            contactId = contactId,
            type = type,
        )
        return getMscSubContactVerificationMessageResultToKotlin(getMscSubContactVerificationMessagePlain(argument.toJava()).await())
    }

    /**
     * @see [getMscSubContactVerificationMessage].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;kotlin&#46;inputs&#46;GetMscSubContactVerificationMessagePlainArgs].
     * @return A collection of values returned by getMscSubContactVerificationMessage.
     */
    public suspend fun getMscSubContactVerificationMessage(argument: suspend GetMscSubContactVerificationMessagePlainArgsBuilder.() -> Unit): GetMscSubContactVerificationMessageResult {
        val builder = GetMscSubContactVerificationMessagePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMscSubContactVerificationMessageResultToKotlin(getMscSubContactVerificationMessagePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Message Center Contacts of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.132.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.getMscSubContacts({});
     * export const mscSubContactId1 = ids.then(ids => ids.contacts?.[0]?.id);
     * const nameRegex = alicloud.getMscSubContacts({
     *     nameRegex: "^my-Contact",
     * });
     * export const mscSubContactId2 = nameRegex.then(nameRegex => nameRegex.contacts?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.get_msc_sub_contacts()
     * pulumi.export("mscSubContactId1", ids.contacts[0].id)
     * name_regex = alicloud.get_msc_sub_contacts(name_regex="^my-Contact")
     * pulumi.export("mscSubContactId2", name_regex.contacts[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.GetMscSubContacts.Invoke();
     *     var nameRegex = AliCloud.GetMscSubContacts.Invoke(new()
     *     {
     *         NameRegex = "^my-Contact",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["mscSubContactId1"] = ids&#46;Apply(getMscSubContactsResult => getMscSubContactsResult&#46;Contacts[0]?.Id),
     *         ["mscSubContactId2"] = nameRegex&#46;Apply(getMscSubContactsResult => getMscSubContactsResult&#46;Contacts[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := alicloud.GetMscSubContacts(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("mscSubContactId1", ids.Contacts[0].Id)
     * 		nameRegex, err := alicloud.GetMscSubContacts(ctx, &alicloud.GetMscSubContactsArgs{
     * 			NameRegex: pulumi.StringRef("^my-Contact"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("mscSubContactId2", nameRegex.Contacts[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.AlicloudFunctions;
     * import com.pulumi.alicloud.inputs.GetMscSubContactsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = AlicloudFunctions.getMscSubContacts();
     *         ctx.export("mscSubContactId1", ids.applyValue(getMscSubContactsResult -> getMscSubContactsResult.contacts()[0].id()));
     *         final var nameRegex = AlicloudFunctions.getMscSubContacts(GetMscSubContactsArgs.builder()
     *             .nameRegex("^my-Contact")
     *             .build());
     *         ctx.export("mscSubContactId2", nameRegex.applyValue(getMscSubContactsResult -> getMscSubContactsResult.contacts()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:getMscSubContacts
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:getMscSubContacts
     *       Arguments:
     *         nameRegex: ^my-Contact
     * outputs:
     *   mscSubContactId1: ${ids.contacts[0].id}
     *   mscSubContactId2: ${nameRegex.contacts[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getMscSubContacts.
     * @return A collection of values returned by getMscSubContacts.
     */
    public suspend fun getMscSubContacts(argument: GetMscSubContactsPlainArgs): GetMscSubContactsResult =
        getMscSubContactsResultToKotlin(getMscSubContactsPlain(argument.toJava()).await())

    /**
     * @see [getMscSubContacts].
     * @param ids A list of Contact IDs.
     * @param nameRegex A regex string to filter results by Contact name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getMscSubContacts.
     */
    public suspend fun getMscSubContacts(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetMscSubContactsResult {
        val argument = GetMscSubContactsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getMscSubContactsResultToKotlin(getMscSubContactsPlain(argument.toJava()).await())
    }

    /**
     * @see [getMscSubContacts].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;kotlin&#46;inputs&#46;GetMscSubContactsPlainArgs].
     * @return A collection of values returned by getMscSubContacts.
     */
    public suspend fun getMscSubContacts(argument: suspend GetMscSubContactsPlainArgsBuilder.() -> Unit): GetMscSubContactsResult {
        val builder = GetMscSubContactsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMscSubContactsResultToKotlin(getMscSubContactsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Message Center Subscriptions of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.135.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.getMscSubSubscriptions({});
     * export const mscSubSubscriptionId1 = _default.then(_default => _default.subscriptions?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.get_msc_sub_subscriptions()
     * pulumi.export("mscSubSubscriptionId1", default.subscriptions[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.GetMscSubSubscriptions.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["mscSubSubscriptionId1"] = @default&#46;Apply(@default => @default&#46;Apply(getMscSubSubscriptionsResult => getMscSubSubscriptionsResult&#46;Subscriptions[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := alicloud.GetMscSubSubscriptions(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("mscSubSubscriptionId1", _default.Subscriptions[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.AlicloudFunctions;
     * import com.pulumi.alicloud.inputs.GetMscSubSubscriptionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = AlicloudFunctions.getMscSubSubscriptions();
     *         ctx.export("mscSubSubscriptionId1", default_.subscriptions()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:getMscSubSubscriptions
     *       Arguments: {}
     * outputs:
     *   mscSubSubscriptionId1: ${default.subscriptions[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getMscSubSubscriptions.
     * @return A collection of values returned by getMscSubSubscriptions.
     */
    public suspend fun getMscSubSubscriptions(argument: GetMscSubSubscriptionsPlainArgs): GetMscSubSubscriptionsResult =
        getMscSubSubscriptionsResultToKotlin(getMscSubSubscriptionsPlain(argument.toJava()).await())

    /**
     * @see [getMscSubSubscriptions].
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getMscSubSubscriptions.
     */
    public suspend fun getMscSubSubscriptions(outputFile: String? = null): GetMscSubSubscriptionsResult {
        val argument = GetMscSubSubscriptionsPlainArgs(
            outputFile = outputFile,
        )
        return getMscSubSubscriptionsResultToKotlin(getMscSubSubscriptionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getMscSubSubscriptions].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;kotlin&#46;inputs&#46;GetMscSubSubscriptionsPlainArgs].
     * @return A collection of values returned by getMscSubSubscriptions.
     */
    public suspend fun getMscSubSubscriptions(argument: suspend GetMscSubSubscriptionsPlainArgsBuilder.() -> Unit): GetMscSubSubscriptionsResult {
        val builder = GetMscSubSubscriptionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMscSubSubscriptionsResultToKotlin(getMscSubSubscriptionsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Msc Sub Webhooks of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.141.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.getMscSubWebhooks({
     *     ids: ["example_id"],
     * });
     * export const mscSubWebhookId1 = ids.then(ids => ids.webhooks?.[0]?.id);
     * const nameRegex = alicloud.getMscSubWebhooks({
     *     nameRegex: "^my-Webhook",
     * });
     * export const mscSubWebhookId2 = nameRegex.then(nameRegex => nameRegex.webhooks?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.get_msc_sub_webhooks(ids=["example_id"])
     * pulumi.export("mscSubWebhookId1", ids.webhooks[0].id)
     * name_regex = alicloud.get_msc_sub_webhooks(name_regex="^my-Webhook")
     * pulumi.export("mscSubWebhookId2", name_regex.webhooks[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.GetMscSubWebhooks.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.GetMscSubWebhooks.Invoke(new()
     *     {
     *         NameRegex = "^my-Webhook",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["mscSubWebhookId1"] = ids&#46;Apply(getMscSubWebhooksResult => getMscSubWebhooksResult&#46;Webhooks[0]?.Id),
     *         ["mscSubWebhookId2"] = nameRegex&#46;Apply(getMscSubWebhooksResult => getMscSubWebhooksResult&#46;Webhooks[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := alicloud.GetMscSubWebhooks(ctx, &alicloud.GetMscSubWebhooksArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("mscSubWebhookId1", ids.Webhooks[0].Id)
     * 		nameRegex, err := alicloud.GetMscSubWebhooks(ctx, &alicloud.GetMscSubWebhooksArgs{
     * 			NameRegex: pulumi.StringRef("^my-Webhook"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("mscSubWebhookId2", nameRegex.Webhooks[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.AlicloudFunctions;
     * import com.pulumi.alicloud.inputs.GetMscSubWebhooksArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = AlicloudFunctions.getMscSubWebhooks(GetMscSubWebhooksArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("mscSubWebhookId1", ids.applyValue(getMscSubWebhooksResult -> getMscSubWebhooksResult.webhooks()[0].id()));
     *         final var nameRegex = AlicloudFunctions.getMscSubWebhooks(GetMscSubWebhooksArgs.builder()
     *             .nameRegex("^my-Webhook")
     *             .build());
     *         ctx.export("mscSubWebhookId2", nameRegex.applyValue(getMscSubWebhooksResult -> getMscSubWebhooksResult.webhooks()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:getMscSubWebhooks
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:getMscSubWebhooks
     *       Arguments:
     *         nameRegex: ^my-Webhook
     * outputs:
     *   mscSubWebhookId1: ${ids.webhooks[0].id}
     *   mscSubWebhookId2: ${nameRegex.webhooks[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getMscSubWebhooks.
     * @return A collection of values returned by getMscSubWebhooks.
     */
    public suspend fun getMscSubWebhooks(argument: GetMscSubWebhooksPlainArgs): GetMscSubWebhooksResult =
        getMscSubWebhooksResultToKotlin(getMscSubWebhooksPlain(argument.toJava()).await())

    /**
     * @see [getMscSubWebhooks].
     * @param ids A list of Webhook IDs.
     * @param nameRegex A regex string to filter results by Webhook name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getMscSubWebhooks.
     */
    public suspend fun getMscSubWebhooks(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetMscSubWebhooksResult {
        val argument = GetMscSubWebhooksPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getMscSubWebhooksResultToKotlin(getMscSubWebhooksPlain(argument.toJava()).await())
    }

    /**
     * @see [getMscSubWebhooks].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;kotlin&#46;inputs&#46;GetMscSubWebhooksPlainArgs].
     * @return A collection of values returned by getMscSubWebhooks.
     */
    public suspend fun getMscSubWebhooks(argument: suspend GetMscSubWebhooksPlainArgsBuilder.() -> Unit): GetMscSubWebhooksResult {
        val builder = GetMscSubWebhooksPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMscSubWebhooksResultToKotlin(getMscSubWebhooksPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Alibaba Cloud regions.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const currentRegionDs = alicloud.getRegions({
     *     current: true,
     * });
     * export const currentRegionId = currentRegionDs.then(currentRegionDs => currentRegionDs.regions?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * current_region_ds = alicloud.get_regions(current=True)
     * pulumi.export("currentRegionId", current_region_ds.regions[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var currentRegionDs = AliCloud.GetRegions.Invoke(new()
     *     {
     *         Current = true,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["currentRegionId"] = currentRegionDs&#46;Apply(getRegionsResult => getRegionsResult&#46;Regions[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		currentRegionDs, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
     * 			Current: pulumi.BoolRef(true),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("currentRegionId", currentRegionDs.Regions[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.AlicloudFunctions;
     * import com.pulumi.alicloud.inputs.GetRegionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var currentRegionDs = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
     *             .current(true)
     *             .build());
     *         ctx.export("currentRegionId", currentRegionDs.applyValue(getRegionsResult -> getRegionsResult.regions()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   currentRegionDs:
     *     fn::invoke:
     *       Function: alicloud:getRegions
     *       Arguments:
     *         current: true
     * outputs:
     *   currentRegionId: ${currentRegionDs.regions[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRegions.
     * @return A collection of values returned by getRegions.
     */
    public suspend fun getRegions(argument: GetRegionsPlainArgs): GetRegionsResult =
        getRegionsResultToKotlin(getRegionsPlain(argument.toJava()).await())

    /**
     * @see [getRegions].
     * @param current Set to true to match only the region configured in the provider.
     * @param name The name of the region to select, such as `eu-central-1`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * > **NOTE:** You will get an error if you set `current` to true and `name` to a different value from the one you configured in the provider.
     * It is better to either use `name` or `current`, but not both at the same time.
     * @return A collection of values returned by getRegions.
     */
    public suspend fun getRegions(
        current: Boolean? = null,
        name: String? = null,
        outputFile: String? = null,
    ): GetRegionsResult {
        val argument = GetRegionsPlainArgs(
            current = current,
            name = name,
            outputFile = outputFile,
        )
        return getRegionsResultToKotlin(getRegionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegions].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;kotlin&#46;inputs&#46;GetRegionsPlainArgs].
     * @return A collection of values returned by getRegions.
     */
    public suspend fun getRegions(argument: suspend GetRegionsPlainArgsBuilder.() -> Unit): GetRegionsResult {
        val builder = GetRegionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegionsResultToKotlin(getRegionsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides availability zones that can be accessed by an Alibaba Cloud account within the region configured in the provider.
     * > **NOTE:** If one zone is sold out, it will not be exported.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const zonesDs = alicloud.getZones({
     *     availableInstanceType: "ecs.n4.large",
     *     availableDiskCategory: "cloud_ssd",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * zones_ds = alicloud.get_zones(available_instance_type="ecs.n4.large",
     *     available_disk_category="cloud_ssd")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var zonesDs = AliCloud.GetZones.Invoke(new()
     *     {
     *         AvailableInstanceType = "ecs.n4.large",
     *         AvailableDiskCategory = "cloud_ssd",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		_, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
     * 			AvailableInstanceType: pulumi.StringRef("ecs.n4.large"),
     * 			AvailableDiskCategory: pulumi.StringRef("cloud_ssd"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.AlicloudFunctions;
     * import com.pulumi.alicloud.inputs.GetZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var zonesDs = AlicloudFunctions.getZones(GetZonesArgs.builder()
     *             .availableInstanceType("ecs.n4.large")
     *             .availableDiskCategory("cloud_ssd")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   zonesDs:
     *     fn::invoke:
     *       Function: alicloud:getZones
     *       Arguments:
     *         availableInstanceType: ecs.n4.large
     *         availableDiskCategory: cloud_ssd
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getZones.
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: GetZonesPlainArgs): GetZonesResult =
        getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())

    /**
     * @see [getZones].
     * @param availableDiskCategory Filter the results by a specific disk category. Can be either `cloud`, `cloud_efficiency`, `cloud_ssd`, `ephemeral_ssd`.
     * @param availableInstanceType Filter the results by a specific instance type.
     * @param availableResourceCreation Filter the results by a specific resource type.
     * Valid values: `Instance`, `Disk`, `VSwitch`, `Rds`, `KVStore`, `FunctionCompute`, `Elasticsearch`, `Slb`.
     * > **NOTE:** From version 1.134.0, the `available_resource_creation` value "Rds" has been deprecated.
     * If you want to fetch the available zones for RDS instance, you can use datasource alicloud_db_zones
     * @param availableSlbAddressIpVersion Filter the results by a slb instance address version. Can be either `ipv4`, or `ipv6`.
     * > **NOTE:** The disk category `cloud` has been outdated and can only be used by non-I/O Optimized ECS instances. Many availability zones don't support it. It is recommended to use `cloud_efficiency` or `cloud_ssd`.
     * @param availableSlbAddressType Filter the results by a slb instance address type. Can be either `Vpc`, `classic_internet` or `classic_intranet`
     * @param enableDetails Default to false and only output `id` in the `zones` block. Set it to true can output more details.
     * @param instanceChargeType Filter the results by a specific ECS instance charge type. Valid values: `PrePaid` and `PostPaid`. Default to `PostPaid`.
     * @param multi Indicate whether the zones can be used in a multi AZ configuration. Default to `false`. Multi AZ is usually used to launch RDS instances.
     * @param networkType Filter the results by a specific network type. Valid values: `Classic` and `Vpc`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param spotStrategy - (Optional) Filter the results by a specific ECS spot type. Valid values: `NoSpot`, `SpotWithPriceLimit` and `SpotAsPriceGo`. Default to `NoSpot`.
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(
        availableDiskCategory: String? = null,
        availableInstanceType: String? = null,
        availableResourceCreation: String? = null,
        availableSlbAddressIpVersion: String? = null,
        availableSlbAddressType: String? = null,
        enableDetails: Boolean? = null,
        instanceChargeType: String? = null,
        multi: Boolean? = null,
        networkType: String? = null,
        outputFile: String? = null,
        spotStrategy: String? = null,
    ): GetZonesResult {
        val argument = GetZonesPlainArgs(
            availableDiskCategory = availableDiskCategory,
            availableInstanceType = availableInstanceType,
            availableResourceCreation = availableResourceCreation,
            availableSlbAddressIpVersion = availableSlbAddressIpVersion,
            availableSlbAddressType = availableSlbAddressType,
            enableDetails = enableDetails,
            instanceChargeType = instanceChargeType,
            multi = multi,
            networkType = networkType,
            outputFile = outputFile,
            spotStrategy = spotStrategy,
        )
        return getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getZones].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;kotlin&#46;inputs&#46;GetZonesPlainArgs].
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: suspend GetZonesPlainArgsBuilder.() -> Unit): GetZonesResult {
        val builder = GetZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getZonesResultToKotlin(getZonesPlain(builtArgument.toJava()).await())
    }
}
