@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kotlin

import com.pulumi.alicloud.Provider
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinProviderResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AlicloudProvider].
 */
@PulumiTagMarker
public class AlicloudProviderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProviderArgs = ProviderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProviderArgsBuilder.() -> Unit) {
        val builder = ProviderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AlicloudProvider {
        val builtJavaResource = Provider(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AlicloudProvider(builtJavaResource)
    }
}

/**
 * The provider type for the alicloud package. By default, resources use package-wide configuration
 * settings, however an explicit `Provider` instance may be created and passed during resource
 * construction to achieve fine-grained programmatic control over provider settings. See the
 * [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.
 */
public class AlicloudProvider internal constructor(
    override val javaResource: Provider,
) : KotlinProviderResource(javaResource, AlicloudProviderMapper) {
    /**
     * The access key for API operations. You can retrieve this from the 'Security Management' section of the Alibaba Cloud
     * console.
     */
    public val accessKey: Output<String>?
        get() = javaResource.accessKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The account ID for some service API operations. You can retrieve this from the 'Security Settings' section of the
     * Alibaba Cloud console.
     */
    public val accountId: Output<String>?
        get() = javaResource.accountId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val configurationSource: Output<String>?
        get() = javaResource.configurationSource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The URI of sidecar credentials service.
     */
    public val credentialsUri: Output<String>?
        get() = javaResource.credentialsUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The RAM Role Name attached on a ECS instance for API operations. You can retrieve this from the 'Access Control' section
     * of the Alibaba Cloud console.
     */
    public val ecsRoleName: Output<String>?
        get() = javaResource.ecsRoleName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Field 'fc' has been deprecated from provider version 1.28.0. New field 'fc' which in nested
      endpoints instead.
  """,
    )
    public val fc: Output<String>?
        get() = javaResource.fc().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    @Deprecated(
        message = """
  Field 'log_endpoint' has been deprecated from provider version 1.28.0. New field 'log' which in
      nested endpoints instead.
  """,
    )
    public val logEndpoint: Output<String>?
        get() = javaResource.logEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Field 'mns_endpoint' has been deprecated from provider version 1.28.0. New field 'mns' which in
      nested endpoints instead.
  """,
    )
    public val mnsEndpoint: Output<String>?
        get() = javaResource.mnsEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Field 'ots_instance_name' has been deprecated from provider version 1.10.0. New field
      'instance_name' of resource 'alicloud_ots_table' instead.
  """,
    )
    public val otsInstanceName: Output<String>?
        get() = javaResource.otsInstanceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The profile for API operations. If not set, the default profile created with `aliyun configure` will be used.
     */
    public val profile: Output<String>?
        get() = javaResource.profile().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val protocol: Output<String>?
        get() = javaResource.protocol().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The region where Alibaba Cloud operations will take place. Examples are cn-beijing, cn-hangzhou, eu-central-1, etc.
     */
    public val region: Output<String>?
        get() = javaResource.region().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The secret key for API operations. You can retrieve this from the 'Security Management' section of the Alibaba Cloud
     * console.
     */
    public val secretKey: Output<String>?
        get() = javaResource.secretKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The security transport for the assume role invoking.
     */
    public val secureTransport: Output<String>?
        get() = javaResource.secureTransport().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * security token. A security token is only required if you are using Security Token Service.
     */
    public val securityToken: Output<String>?
        get() = javaResource.securityToken().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val securityTransport: Output<String>?
        get() = javaResource.securityTransport().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The path to the shared credentials file. If not set this defaults to ~/.aliyun/config.json
     */
    public val sharedCredentialsFile: Output<String>?
        get() = javaResource.sharedCredentialsFile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The source ip for the assume role invoking.
     */
    public val sourceIp: Output<String>?
        get() = javaResource.sourceIp().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object AlicloudProviderMapper : ResourceMapper<AlicloudProvider> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        Provider::class == javaResource::class

    override fun map(javaResource: Resource): AlicloudProvider = AlicloudProvider(
        javaResource as
            Provider,
    )
}

/**
 * @see [Provider].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AlicloudProvider].
 */
public suspend fun alicloudProvider(
    name: String,
    block: suspend AlicloudProviderResourceBuilder.() -> Unit,
): AlicloudProvider {
    val builder = AlicloudProviderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Provider].
 * @param name The _unique_ name of the resulting resource.
 */
public fun alicloudProvider(name: String): AlicloudProvider {
    val builder = AlicloudProviderResourceBuilder()
    builder.name(name)
    return builder.build()
}
