@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [MscSubContract].
 */
@PulumiTagMarker
public class MscSubContractResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MscSubContractArgs = MscSubContractArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MscSubContractArgsBuilder.() -> Unit) {
        val builder = MscSubContractArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MscSubContract {
        val builtJavaResource = com.pulumi.alicloud.MscSubContract(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MscSubContract(builtJavaResource)
    }
}

/**
 * Provides a Msc Sub Contact resource.
 * > **NOTE:** Available since v1.132.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tfexample";
 * const _default = new alicloud.MscSubContract("default", {
 *     contactName: name,
 *     position: "CEO",
 *     email: "123@163.com",
 *     mobile: "15388888888",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tfexample"
 * default = alicloud.MscSubContract("default",
 *     contact_name=name,
 *     position="CEO",
 *     email="123@163.com",
 *     mobile="15388888888")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tfexample";
 *     var @default = new AliCloud.MscSubContract("default", new()
 *     {
 *         ContactName = name,
 *         Position = "CEO",
 *         Email = "123@163.com",
 *         Mobile = "15388888888",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tfexample"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := alicloud.NewMscSubContract(ctx, "default", &alicloud.MscSubContractArgs{
 * 			ContactName: pulumi.String(name),
 * 			Position:    pulumi.String("CEO"),
 * 			Email:       pulumi.String("123@163.com"),
 * 			Mobile:      pulumi.String("15388888888"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.MscSubContract;
 * import com.pulumi.alicloud.MscSubContractArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tfexample");
 *         var default_ = new MscSubContract("default", MscSubContractArgs.builder()
 *             .contactName(name)
 *             .position("CEO")
 *             .email("123@163.com")
 *             .mobile("15388888888")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tfexample
 * resources:
 *   default:
 *     type: alicloud:MscSubContract
 *     properties:
 *       contactName: ${name}
 *       position: CEO
 *       email: 123@163.com
 *       mobile: '15388888888'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Msc Sub Contact can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:index/mscSubContract:MscSubContract example <id>
 * ```
 */
public class MscSubContract internal constructor(
    override val javaResource: com.pulumi.alicloud.MscSubContract,
) : KotlinCustomResource(javaResource, MscSubContractMapper) {
    /**
     * The User's Contact Name. **Note:** The name must be 2 to 12 characters in length.
     */
    public val contactName: Output<String>
        get() = javaResource.contactName().applyValue({ args0 -> args0 })

    /**
     * The User's Contact Email Address.
     */
    public val email: Output<String>
        get() = javaResource.email().applyValue({ args0 -> args0 })

    /**
     * The User's Telephone.
     */
    public val mobile: Output<String>
        get() = javaResource.mobile().applyValue({ args0 -> args0 })

    /**
     * The User's Position. Valid values: `CEO`, `Technical Director`, `Maintenance Director`, `Project Director`,`Finance Director` and `Other`.
     * > **NOTE:** When the user creates a contact, the user should use `alicloud.getMscSubContactVerificationMessage` to receive the verification message and confirm it.
     */
    public val position: Output<String>
        get() = javaResource.position().applyValue({ args0 -> args0 })
}

public object MscSubContractMapper : ResourceMapper<MscSubContract> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.MscSubContract::class == javaResource::class

    override fun map(javaResource: Resource): MscSubContract = MscSubContract(
        javaResource as
            com.pulumi.alicloud.MscSubContract,
    )
}

/**
 * @see [MscSubContract].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MscSubContract].
 */
public suspend fun mscSubContract(
    name: String,
    block: suspend MscSubContractResourceBuilder.() -> Unit,
): MscSubContract {
    val builder = MscSubContractResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MscSubContract].
 * @param name The _unique_ name of the resulting resource.
 */
public fun mscSubContract(name: String): MscSubContract {
    val builder = MscSubContractResourceBuilder()
    builder.name(name)
    return builder.build()
}
