@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kotlin

import com.pulumi.alicloud.MscSubContractArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Msc Sub Contact resource.
 * > **NOTE:** Available since v1.132.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tfexample";
 * const _default = new alicloud.MscSubContract("default", {
 *     contactName: name,
 *     position: "CEO",
 *     email: "123@163.com",
 *     mobile: "15388888888",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tfexample"
 * default = alicloud.MscSubContract("default",
 *     contact_name=name,
 *     position="CEO",
 *     email="123@163.com",
 *     mobile="15388888888")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tfexample";
 *     var @default = new AliCloud.MscSubContract("default", new()
 *     {
 *         ContactName = name,
 *         Position = "CEO",
 *         Email = "123@163.com",
 *         Mobile = "15388888888",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tfexample"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := alicloud.NewMscSubContract(ctx, "default", &alicloud.MscSubContractArgs{
 * 			ContactName: pulumi.String(name),
 * 			Position:    pulumi.String("CEO"),
 * 			Email:       pulumi.String("123@163.com"),
 * 			Mobile:      pulumi.String("15388888888"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.MscSubContract;
 * import com.pulumi.alicloud.MscSubContractArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tfexample");
 *         var default_ = new MscSubContract("default", MscSubContractArgs.builder()
 *             .contactName(name)
 *             .position("CEO")
 *             .email("123@163.com")
 *             .mobile("15388888888")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tfexample
 * resources:
 *   default:
 *     type: alicloud:MscSubContract
 *     properties:
 *       contactName: ${name}
 *       position: CEO
 *       email: 123@163.com
 *       mobile: '15388888888'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Msc Sub Contact can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:index/mscSubContract:MscSubContract example <id>
 * ```
 * @property contactName The User's Contact Name. **Note:** The name must be 2 to 12 characters in length.
 * @property email The User's Contact Email Address.
 * @property mobile The User's Telephone.
 * @property position The User's Position. Valid values: `CEO`, `Technical Director`, `Maintenance Director`, `Project Director`,`Finance Director` and `Other`.
 * > **NOTE:** When the user creates a contact, the user should use `alicloud.getMscSubContactVerificationMessage` to receive the verification message and confirm it.
 */
public data class MscSubContractArgs(
    public val contactName: Output<String>? = null,
    public val email: Output<String>? = null,
    public val mobile: Output<String>? = null,
    public val position: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.MscSubContractArgs> {
    override fun toJava(): com.pulumi.alicloud.MscSubContractArgs =
        com.pulumi.alicloud.MscSubContractArgs.builder()
            .contactName(contactName?.applyValue({ args0 -> args0 }))
            .email(email?.applyValue({ args0 -> args0 }))
            .mobile(mobile?.applyValue({ args0 -> args0 }))
            .position(position?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MscSubContractArgs].
 */
@PulumiTagMarker
public class MscSubContractArgsBuilder internal constructor() {
    private var contactName: Output<String>? = null

    private var email: Output<String>? = null

    private var mobile: Output<String>? = null

    private var position: Output<String>? = null

    /**
     * @param value The User's Contact Name. **Note:** The name must be 2 to 12 characters in length.
     */
    @JvmName("yhfwopegvbjbmruh")
    public suspend fun contactName(`value`: Output<String>) {
        this.contactName = value
    }

    /**
     * @param value The User's Contact Email Address.
     */
    @JvmName("uqsmlamojvxxtubx")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value The User's Telephone.
     */
    @JvmName("pdxtmnhrqhbrmqgf")
    public suspend fun mobile(`value`: Output<String>) {
        this.mobile = value
    }

    /**
     * @param value The User's Position. Valid values: `CEO`, `Technical Director`, `Maintenance Director`, `Project Director`,`Finance Director` and `Other`.
     * > **NOTE:** When the user creates a contact, the user should use `alicloud.getMscSubContactVerificationMessage` to receive the verification message and confirm it.
     */
    @JvmName("gkbkisifrbkfquro")
    public suspend fun position(`value`: Output<String>) {
        this.position = value
    }

    /**
     * @param value The User's Contact Name. **Note:** The name must be 2 to 12 characters in length.
     */
    @JvmName("ibnvgcowkcjhbqvn")
    public suspend fun contactName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactName = mapped
    }

    /**
     * @param value The User's Contact Email Address.
     */
    @JvmName("iuqbwjfwyfikftxf")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value The User's Telephone.
     */
    @JvmName("rnowbeadgjxhkvgj")
    public suspend fun mobile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mobile = mapped
    }

    /**
     * @param value The User's Position. Valid values: `CEO`, `Technical Director`, `Maintenance Director`, `Project Director`,`Finance Director` and `Other`.
     * > **NOTE:** When the user creates a contact, the user should use `alicloud.getMscSubContactVerificationMessage` to receive the verification message and confirm it.
     */
    @JvmName("ddvwutqnomcffdvp")
    public suspend fun position(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.position = mapped
    }

    internal fun build(): MscSubContractArgs = MscSubContractArgs(
        contactName = contactName,
        email = email,
        mobile = mobile,
        position = position,
    )
}
