@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [MscSubSubscription].
 */
@PulumiTagMarker
public class MscSubSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MscSubSubscriptionArgs = MscSubSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MscSubSubscriptionArgsBuilder.() -> Unit) {
        val builder = MscSubSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MscSubSubscription {
        val builtJavaResource = com.pulumi.alicloud.MscSubSubscription(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MscSubSubscription(builtJavaResource)
    }
}

/**
 * Provides a Msc Sub Subscription resource.
 * > **NOTE:** Available since v1.135.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.MscSubSubscription("example", {
 *     itemName: "Notifications of Product Expiration",
 *     smsStatus: 1,
 *     emailStatus: 1,
 *     pmsgStatus: 1,
 *     ttsStatus: 1,
 *     webhookStatus: 0,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.MscSubSubscription("example",
 *     item_name="Notifications of Product Expiration",
 *     sms_status=1,
 *     email_status=1,
 *     pmsg_status=1,
 *     tts_status=1,
 *     webhook_status=0)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.MscSubSubscription("example", new()
 *     {
 *         ItemName = "Notifications of Product Expiration",
 *         SmsStatus = 1,
 *         EmailStatus = 1,
 *         PmsgStatus = 1,
 *         TtsStatus = 1,
 *         WebhookStatus = 0,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := alicloud.NewMscSubSubscription(ctx, "example", &alicloud.MscSubSubscriptionArgs{
 * 			ItemName:      pulumi.String("Notifications of Product Expiration"),
 * 			SmsStatus:     pulumi.Int(1),
 * 			EmailStatus:   pulumi.Int(1),
 * 			PmsgStatus:    pulumi.Int(1),
 * 			TtsStatus:     pulumi.Int(1),
 * 			WebhookStatus: pulumi.Int(0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.MscSubSubscription;
 * import com.pulumi.alicloud.MscSubSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MscSubSubscription("example", MscSubSubscriptionArgs.builder()
 *             .itemName("Notifications of Product Expiration")
 *             .smsStatus("1")
 *             .emailStatus("1")
 *             .pmsgStatus("1")
 *             .ttsStatus("1")
 *             .webhookStatus("0")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:MscSubSubscription
 *     properties:
 *       itemName: Notifications of Product Expiration
 *       smsStatus: '1'
 *       emailStatus: '1'
 *       pmsgStatus: '1'
 *       ttsStatus: '1'
 *       webhookStatus: '0'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Msc Sub Subscription can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:index/mscSubSubscription:MscSubSubscription example <id>
 * ```
 */
public class MscSubSubscription internal constructor(
    override val javaResource: com.pulumi.alicloud.MscSubSubscription,
) : KotlinCustomResource(javaResource, MscSubSubscriptionMapper) {
    /**
     * The channel the Subscription.
     */
    public val channel: Output<String>
        get() = javaResource.channel().applyValue({ args0 -> args0 })

    /**
     * The ids of subscribed contacts.
     * **NOTE:** There is a potential diff error because of the order of `contact_ids` values indefinite.
     * So, from version 1.161.0, `contact_ids` type has been updated as `set` from `list`,
     * and you can use tolist to convert it to a list.
     */
    public val contactIds: Output<List<String>>
        get() = javaResource.contactIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The description of the Subscription.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The status of email subscription. Valid values: `-1`, `-2`, `0`, `1`. `-1` means required, `-2` means banned; `1` means subscribed; `0` means not subscribed.
     */
    public val emailStatus: Output<Int>?
        get() = javaResource.emailStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the Subscription. **NOTE:**  You should use the `alicloud.getMscSubSubscriptions` to query the available subscription item name.
     */
    public val itemName: Output<String>
        get() = javaResource.itemName().applyValue({ args0 -> args0 })

    /**
     * The status of pmsg subscription. Valid values: `-1`, `-2`, `0`, `1`. `-1` means required, `-2` means banned; `1` means subscribed; `0` means not subscribed.
     */
    public val pmsgStatus: Output<Int>?
        get() = javaResource.pmsgStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of sms subscription. Valid values: `-1`, `-2`, `0`, `1`. `-1` means required, `-2` means banned; `1` means subscribed; `0` means not subscribed.
     */
    public val smsStatus: Output<Int>?
        get() = javaResource.smsStatus().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The status of tts subscription. Valid values: `-1`, `-2`, `0`, `1`. `-1` means required, `-2` means banned; `1` means subscribed; `0` means not subscribed.
     */
    public val ttsStatus: Output<Int>?
        get() = javaResource.ttsStatus().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ids of subscribed webhooks.
     */
    public val webhookIds: Output<List<String>>?
        get() = javaResource.webhookIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The status of webhook subscription. Valid values: `-1`, `-2`, `0`, `1`. `-1` means required, `-2` means banned; `1` means subscribed; `0` means not subscribed.
     */
    public val webhookStatus: Output<Int>?
        get() = javaResource.webhookStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object MscSubSubscriptionMapper : ResourceMapper<MscSubSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.MscSubSubscription::class == javaResource::class

    override fun map(javaResource: Resource): MscSubSubscription = MscSubSubscription(
        javaResource as
            com.pulumi.alicloud.MscSubSubscription,
    )
}

/**
 * @see [MscSubSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MscSubSubscription].
 */
public suspend fun mscSubSubscription(
    name: String,
    block: suspend MscSubSubscriptionResourceBuilder.() -> Unit,
): MscSubSubscription {
    val builder = MscSubSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MscSubSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun mscSubSubscription(name: String): MscSubSubscription {
    val builder = MscSubSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
