@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kotlin

import com.pulumi.alicloud.MscSubSubscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Msc Sub Subscription resource.
 * > **NOTE:** Available since v1.135.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.MscSubSubscription("example", {
 *     itemName: "Notifications of Product Expiration",
 *     smsStatus: 1,
 *     emailStatus: 1,
 *     pmsgStatus: 1,
 *     ttsStatus: 1,
 *     webhookStatus: 0,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.MscSubSubscription("example",
 *     item_name="Notifications of Product Expiration",
 *     sms_status=1,
 *     email_status=1,
 *     pmsg_status=1,
 *     tts_status=1,
 *     webhook_status=0)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.MscSubSubscription("example", new()
 *     {
 *         ItemName = "Notifications of Product Expiration",
 *         SmsStatus = 1,
 *         EmailStatus = 1,
 *         PmsgStatus = 1,
 *         TtsStatus = 1,
 *         WebhookStatus = 0,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := alicloud.NewMscSubSubscription(ctx, "example", &alicloud.MscSubSubscriptionArgs{
 * 			ItemName:      pulumi.String("Notifications of Product Expiration"),
 * 			SmsStatus:     pulumi.Int(1),
 * 			EmailStatus:   pulumi.Int(1),
 * 			PmsgStatus:    pulumi.Int(1),
 * 			TtsStatus:     pulumi.Int(1),
 * 			WebhookStatus: pulumi.Int(0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.MscSubSubscription;
 * import com.pulumi.alicloud.MscSubSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MscSubSubscription("example", MscSubSubscriptionArgs.builder()
 *             .itemName("Notifications of Product Expiration")
 *             .smsStatus("1")
 *             .emailStatus("1")
 *             .pmsgStatus("1")
 *             .ttsStatus("1")
 *             .webhookStatus("0")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:MscSubSubscription
 *     properties:
 *       itemName: Notifications of Product Expiration
 *       smsStatus: '1'
 *       emailStatus: '1'
 *       pmsgStatus: '1'
 *       ttsStatus: '1'
 *       webhookStatus: '0'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Msc Sub Subscription can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:index/mscSubSubscription:MscSubSubscription example <id>
 * ```
 * @property contactIds The ids of subscribed contacts.
 * **NOTE:** There is a potential diff error because of the order of `contact_ids` values indefinite.
 * So, from version 1.161.0, `contact_ids` type has been updated as `set` from `list`,
 * and you can use tolist to convert it to a list.
 * @property emailStatus The status of email subscription. Valid values: `-1`, `-2`, `0`, `1`. `-1` means required, `-2` means banned; `1` means subscribed; `0` means not subscribed.
 * @property itemName The name of the Subscription. **NOTE:**  You should use the `alicloud.getMscSubSubscriptions` to query the available subscription item name.
 * @property pmsgStatus The status of pmsg subscription. Valid values: `-1`, `-2`, `0`, `1`. `-1` means required, `-2` means banned; `1` means subscribed; `0` means not subscribed.
 * @property smsStatus The status of sms subscription. Valid values: `-1`, `-2`, `0`, `1`. `-1` means required, `-2` means banned; `1` means subscribed; `0` means not subscribed.
 * @property ttsStatus The status of tts subscription. Valid values: `-1`, `-2`, `0`, `1`. `-1` means required, `-2` means banned; `1` means subscribed; `0` means not subscribed.
 * @property webhookIds The ids of subscribed webhooks.
 * @property webhookStatus The status of webhook subscription. Valid values: `-1`, `-2`, `0`, `1`. `-1` means required, `-2` means banned; `1` means subscribed; `0` means not subscribed.
 */
public data class MscSubSubscriptionArgs(
    public val contactIds: Output<List<String>>? = null,
    public val emailStatus: Output<Int>? = null,
    public val itemName: Output<String>? = null,
    public val pmsgStatus: Output<Int>? = null,
    public val smsStatus: Output<Int>? = null,
    public val ttsStatus: Output<Int>? = null,
    public val webhookIds: Output<List<String>>? = null,
    public val webhookStatus: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.MscSubSubscriptionArgs> {
    override fun toJava(): com.pulumi.alicloud.MscSubSubscriptionArgs =
        com.pulumi.alicloud.MscSubSubscriptionArgs.builder()
            .contactIds(contactIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .emailStatus(emailStatus?.applyValue({ args0 -> args0 }))
            .itemName(itemName?.applyValue({ args0 -> args0 }))
            .pmsgStatus(pmsgStatus?.applyValue({ args0 -> args0 }))
            .smsStatus(smsStatus?.applyValue({ args0 -> args0 }))
            .ttsStatus(ttsStatus?.applyValue({ args0 -> args0 }))
            .webhookIds(webhookIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .webhookStatus(webhookStatus?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MscSubSubscriptionArgs].
 */
@PulumiTagMarker
public class MscSubSubscriptionArgsBuilder internal constructor() {
    private var contactIds: Output<List<String>>? = null

    private var emailStatus: Output<Int>? = null

    private var itemName: Output<String>? = null

    private var pmsgStatus: Output<Int>? = null

    private var smsStatus: Output<Int>? = null

    private var ttsStatus: Output<Int>? = null

    private var webhookIds: Output<List<String>>? = null

    private var webhookStatus: Output<Int>? = null

    /**
     * @param value The ids of subscribed contacts.
     * **NOTE:** There is a potential diff error because of the order of `contact_ids` values indefinite.
     * So, from version 1.161.0, `contact_ids` type has been updated as `set` from `list`,
     * and you can use tolist to convert it to a list.
     */
    @JvmName("fbrqxrfiqostsqmb")
    public suspend fun contactIds(`value`: Output<List<String>>) {
        this.contactIds = value
    }

    @JvmName("svehswdbmiaqoupv")
    public suspend fun contactIds(vararg values: Output<String>) {
        this.contactIds = Output.all(values.asList())
    }

    /**
     * @param values The ids of subscribed contacts.
     * **NOTE:** There is a potential diff error because of the order of `contact_ids` values indefinite.
     * So, from version 1.161.0, `contact_ids` type has been updated as `set` from `list`,
     * and you can use tolist to convert it to a list.
     */
    @JvmName("iapuigqnkgorqfmp")
    public suspend fun contactIds(values: List<Output<String>>) {
        this.contactIds = Output.all(values)
    }

    /**
     * @param value The status of email subscription. Valid values: `-1`, `-2`, `0`, `1`. `-1` means required, `-2` means banned; `1` means subscribed; `0` means not subscribed.
     */
    @JvmName("eeyawcdaipslimpj")
    public suspend fun emailStatus(`value`: Output<Int>) {
        this.emailStatus = value
    }

    /**
     * @param value The name of the Subscription. **NOTE:**  You should use the `alicloud.getMscSubSubscriptions` to query the available subscription item name.
     */
    @JvmName("pfthultyianvrdjk")
    public suspend fun itemName(`value`: Output<String>) {
        this.itemName = value
    }

    /**
     * @param value The status of pmsg subscription. Valid values: `-1`, `-2`, `0`, `1`. `-1` means required, `-2` means banned; `1` means subscribed; `0` means not subscribed.
     */
    @JvmName("mpatjtuajukvgbgh")
    public suspend fun pmsgStatus(`value`: Output<Int>) {
        this.pmsgStatus = value
    }

    /**
     * @param value The status of sms subscription. Valid values: `-1`, `-2`, `0`, `1`. `-1` means required, `-2` means banned; `1` means subscribed; `0` means not subscribed.
     */
    @JvmName("slrlbuqftbyapojc")
    public suspend fun smsStatus(`value`: Output<Int>) {
        this.smsStatus = value
    }

    /**
     * @param value The status of tts subscription. Valid values: `-1`, `-2`, `0`, `1`. `-1` means required, `-2` means banned; `1` means subscribed; `0` means not subscribed.
     */
    @JvmName("bdclpykcacqwfeio")
    public suspend fun ttsStatus(`value`: Output<Int>) {
        this.ttsStatus = value
    }

    /**
     * @param value The ids of subscribed webhooks.
     */
    @JvmName("hdwheayoiavanbyc")
    public suspend fun webhookIds(`value`: Output<List<String>>) {
        this.webhookIds = value
    }

    @JvmName("tqrxijdvwlfmalke")
    public suspend fun webhookIds(vararg values: Output<String>) {
        this.webhookIds = Output.all(values.asList())
    }

    /**
     * @param values The ids of subscribed webhooks.
     */
    @JvmName("wgwhvhpftntlvvla")
    public suspend fun webhookIds(values: List<Output<String>>) {
        this.webhookIds = Output.all(values)
    }

    /**
     * @param value The status of webhook subscription. Valid values: `-1`, `-2`, `0`, `1`. `-1` means required, `-2` means banned; `1` means subscribed; `0` means not subscribed.
     */
    @JvmName("iedhvipvjlrydlbh")
    public suspend fun webhookStatus(`value`: Output<Int>) {
        this.webhookStatus = value
    }

    /**
     * @param value The ids of subscribed contacts.
     * **NOTE:** There is a potential diff error because of the order of `contact_ids` values indefinite.
     * So, from version 1.161.0, `contact_ids` type has been updated as `set` from `list`,
     * and you can use tolist to convert it to a list.
     */
    @JvmName("uxerirocahurvdki")
    public suspend fun contactIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactIds = mapped
    }

    /**
     * @param values The ids of subscribed contacts.
     * **NOTE:** There is a potential diff error because of the order of `contact_ids` values indefinite.
     * So, from version 1.161.0, `contact_ids` type has been updated as `set` from `list`,
     * and you can use tolist to convert it to a list.
     */
    @JvmName("jtgunbpupkeddccc")
    public suspend fun contactIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contactIds = mapped
    }

    /**
     * @param value The status of email subscription. Valid values: `-1`, `-2`, `0`, `1`. `-1` means required, `-2` means banned; `1` means subscribed; `0` means not subscribed.
     */
    @JvmName("qgeahhfcmwjlvfle")
    public suspend fun emailStatus(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailStatus = mapped
    }

    /**
     * @param value The name of the Subscription. **NOTE:**  You should use the `alicloud.getMscSubSubscriptions` to query the available subscription item name.
     */
    @JvmName("qdafqejbbdfchdrh")
    public suspend fun itemName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.itemName = mapped
    }

    /**
     * @param value The status of pmsg subscription. Valid values: `-1`, `-2`, `0`, `1`. `-1` means required, `-2` means banned; `1` means subscribed; `0` means not subscribed.
     */
    @JvmName("pbmkescdscrvbhtu")
    public suspend fun pmsgStatus(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pmsgStatus = mapped
    }

    /**
     * @param value The status of sms subscription. Valid values: `-1`, `-2`, `0`, `1`. `-1` means required, `-2` means banned; `1` means subscribed; `0` means not subscribed.
     */
    @JvmName("nbycevmclpnaqqkm")
    public suspend fun smsStatus(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smsStatus = mapped
    }

    /**
     * @param value The status of tts subscription. Valid values: `-1`, `-2`, `0`, `1`. `-1` means required, `-2` means banned; `1` means subscribed; `0` means not subscribed.
     */
    @JvmName("mdhjfgpubitlqgxu")
    public suspend fun ttsStatus(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ttsStatus = mapped
    }

    /**
     * @param value The ids of subscribed webhooks.
     */
    @JvmName("eduaorfsfrbmirrm")
    public suspend fun webhookIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webhookIds = mapped
    }

    /**
     * @param values The ids of subscribed webhooks.
     */
    @JvmName("fgvqwrbnysglfxly")
    public suspend fun webhookIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.webhookIds = mapped
    }

    /**
     * @param value The status of webhook subscription. Valid values: `-1`, `-2`, `0`, `1`. `-1` means required, `-2` means banned; `1` means subscribed; `0` means not subscribed.
     */
    @JvmName("fblxbmrurfkhpkig")
    public suspend fun webhookStatus(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webhookStatus = mapped
    }

    internal fun build(): MscSubSubscriptionArgs = MscSubSubscriptionArgs(
        contactIds = contactIds,
        emailStatus = emailStatus,
        itemName = itemName,
        pmsgStatus = pmsgStatus,
        smsStatus = smsStatus,
        ttsStatus = ttsStatus,
        webhookIds = webhookIds,
        webhookStatus = webhookStatus,
    )
}
