@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [MscSubWebhook].
 */
@PulumiTagMarker
public class MscSubWebhookResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MscSubWebhookArgs = MscSubWebhookArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MscSubWebhookArgsBuilder.() -> Unit) {
        val builder = MscSubWebhookArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MscSubWebhook {
        val builtJavaResource = com.pulumi.alicloud.MscSubWebhook(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MscSubWebhook(builtJavaResource)
    }
}

/**
 * Provides a Msc Sub Webhook resource.
 * > **NOTE:** Available since v1.141.0.
 * ## Import
 * Msc Sub Webhook can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:index/mscSubWebhook:MscSubWebhook example <id>
 * ```
 */
public class MscSubWebhook internal constructor(
    override val javaResource: com.pulumi.alicloud.MscSubWebhook,
) : KotlinCustomResource(javaResource, MscSubWebhookMapper) {
    /**
     * The serverUrl of the Webhook. This url must start with `https://oapi.dingtalk.com/robot/send?access_token=`.
     */
    public val serverUrl: Output<String>
        get() = javaResource.serverUrl().applyValue({ args0 -> args0 })

    /**
     * The name of the Webhook. **Note:** The name must be `2` to `12` characters in length, and can contain uppercase and lowercase letters.
     */
    public val webhookName: Output<String>
        get() = javaResource.webhookName().applyValue({ args0 -> args0 })
}

public object MscSubWebhookMapper : ResourceMapper<MscSubWebhook> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.MscSubWebhook::class == javaResource::class

    override fun map(javaResource: Resource): MscSubWebhook = MscSubWebhook(
        javaResource as
            com.pulumi.alicloud.MscSubWebhook,
    )
}

/**
 * @see [MscSubWebhook].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MscSubWebhook].
 */
public suspend fun mscSubWebhook(
    name: String,
    block: suspend MscSubWebhookResourceBuilder.() -> Unit,
): MscSubWebhook {
    val builder = MscSubWebhookResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MscSubWebhook].
 * @param name The _unique_ name of the resulting resource.
 */
public fun mscSubWebhook(name: String): MscSubWebhook {
    val builder = MscSubWebhookResourceBuilder()
    builder.name(name)
    return builder.build()
}
