@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kotlin

import com.pulumi.alicloud.MscSubWebhookArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Msc Sub Webhook resource.
 * > **NOTE:** Available since v1.141.0.
 * ## Import
 * Msc Sub Webhook can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:index/mscSubWebhook:MscSubWebhook example <id>
 * ```
 * @property serverUrl The serverUrl of the Webhook. This url must start with `https://oapi.dingtalk.com/robot/send?access_token=`.
 * @property webhookName The name of the Webhook. **Note:** The name must be `2` to `12` characters in length, and can contain uppercase and lowercase letters.
 */
public data class MscSubWebhookArgs(
    public val serverUrl: Output<String>? = null,
    public val webhookName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.MscSubWebhookArgs> {
    override fun toJava(): com.pulumi.alicloud.MscSubWebhookArgs =
        com.pulumi.alicloud.MscSubWebhookArgs.builder()
            .serverUrl(serverUrl?.applyValue({ args0 -> args0 }))
            .webhookName(webhookName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MscSubWebhookArgs].
 */
@PulumiTagMarker
public class MscSubWebhookArgsBuilder internal constructor() {
    private var serverUrl: Output<String>? = null

    private var webhookName: Output<String>? = null

    /**
     * @param value The serverUrl of the Webhook. This url must start with `https://oapi.dingtalk.com/robot/send?access_token=`.
     */
    @JvmName("dnoyhhyvpbpbqsbp")
    public suspend fun serverUrl(`value`: Output<String>) {
        this.serverUrl = value
    }

    /**
     * @param value The name of the Webhook. **Note:** The name must be `2` to `12` characters in length, and can contain uppercase and lowercase letters.
     */
    @JvmName("xkmchsmjxsfbstop")
    public suspend fun webhookName(`value`: Output<String>) {
        this.webhookName = value
    }

    /**
     * @param value The serverUrl of the Webhook. This url must start with `https://oapi.dingtalk.com/robot/send?access_token=`.
     */
    @JvmName("htpfeveumwuwftlh")
    public suspend fun serverUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverUrl = mapped
    }

    /**
     * @param value The name of the Webhook. **Note:** The name must be `2` to `12` characters in length, and can contain uppercase and lowercase letters.
     */
    @JvmName("jcjemkokkomwbrhi")
    public suspend fun webhookName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webhookName = mapped
    }

    internal fun build(): MscSubWebhookArgs = MscSubWebhookArgs(
        serverUrl = serverUrl,
        webhookName = webhookName,
    )
}
