@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kotlin

import com.pulumi.alicloud.ProviderArgs.builder
import com.pulumi.alicloud.kotlin.inputs.ProviderAssumeRoleArgs
import com.pulumi.alicloud.kotlin.inputs.ProviderAssumeRoleArgsBuilder
import com.pulumi.alicloud.kotlin.inputs.ProviderAssumeRoleWithOidcArgs
import com.pulumi.alicloud.kotlin.inputs.ProviderAssumeRoleWithOidcArgsBuilder
import com.pulumi.alicloud.kotlin.inputs.ProviderEndpointArgs
import com.pulumi.alicloud.kotlin.inputs.ProviderEndpointArgsBuilder
import com.pulumi.alicloud.kotlin.inputs.ProviderSignVersionArgs
import com.pulumi.alicloud.kotlin.inputs.ProviderSignVersionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The provider type for the alicloud package. By default, resources use package-wide configuration
 * settings, however an explicit `Provider` instance may be created and passed during resource
 * construction to achieve fine-grained programmatic control over provider settings. See the
 * [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.
 * @property accessKey The access key for API operations. You can retrieve this from the 'Security Management' section of the Alibaba Cloud
 * console.
 * @property accountId The account ID for some service API operations. You can retrieve this from the 'Security Settings' section of the
 * Alibaba Cloud console.
 * @property assumeRole
 * @property assumeRoleWithOidc
 * @property clientConnectTimeout The maximum timeout of the client connection server.
 * @property clientReadTimeout The maximum timeout of the client read request.
 * @property configurationSource
 * @property credentialsUri The URI of sidecar credentials service.
 * @property ecsRoleName The RAM Role Name attached on a ECS instance for API operations. You can retrieve this from the 'Access Control' section
 * of the Alibaba Cloud console.
 * @property endpoints
 * @property fc
 * @property logEndpoint
 * @property maxRetryTimeout The maximum retry timeout of the request.
 * @property mnsEndpoint
 * @property otsInstanceName
 * @property profile The profile for API operations. If not set, the default profile created with `aliyun configure` will be used.
 * @property protocol
 * @property region The region where Alibaba Cloud operations will take place. Examples are cn-beijing, cn-hangzhou, eu-central-1, etc.
 * @property secretKey The secret key for API operations. You can retrieve this from the 'Security Management' section of the Alibaba Cloud
 * console.
 * @property secureTransport The security transport for the assume role invoking.
 * @property securityToken security token. A security token is only required if you are using Security Token Service.
 * @property securityTransport
 * @property sharedCredentialsFile The path to the shared credentials file. If not set this defaults to ~/.aliyun/config.json
 * @property signVersion
 * @property skipRegionValidation Skip static validation of region ID. Used by users of alternative AlibabaCloud-like APIs or users w/ access to regions
 * that are not public (yet).
 * @property sourceIp The source ip for the assume role invoking.
 */
public data class ProviderArgs(
    public val accessKey: Output<String>? = null,
    public val accountId: Output<String>? = null,
    public val assumeRole: Output<ProviderAssumeRoleArgs>? = null,
    public val assumeRoleWithOidc: Output<ProviderAssumeRoleWithOidcArgs>? = null,
    public val clientConnectTimeout: Output<Int>? = null,
    public val clientReadTimeout: Output<Int>? = null,
    public val configurationSource: Output<String>? = null,
    public val credentialsUri: Output<String>? = null,
    public val ecsRoleName: Output<String>? = null,
    public val endpoints: Output<List<ProviderEndpointArgs>>? = null,
    @Deprecated(
        message = """
  Field 'fc' has been deprecated from provider version 1.28.0. New field 'fc' which in nested
      endpoints instead.
  """,
    )
    public val fc: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'log_endpoint' has been deprecated from provider version 1.28.0. New field 'log' which in
      nested endpoints instead.
  """,
    )
    public val logEndpoint: Output<String>? = null,
    public val maxRetryTimeout: Output<Int>? = null,
    @Deprecated(
        message = """
  Field 'mns_endpoint' has been deprecated from provider version 1.28.0. New field 'mns' which in
      nested endpoints instead.
  """,
    )
    public val mnsEndpoint: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'ots_instance_name' has been deprecated from provider version 1.10.0. New field
      'instance_name' of resource 'alicloud_ots_table' instead.
  """,
    )
    public val otsInstanceName: Output<String>? = null,
    public val profile: Output<String>? = null,
    public val protocol: Output<String>? = null,
    public val region: Output<String>? = null,
    public val secretKey: Output<String>? = null,
    public val secureTransport: Output<String>? = null,
    public val securityToken: Output<String>? = null,
    public val securityTransport: Output<String>? = null,
    public val sharedCredentialsFile: Output<String>? = null,
    public val signVersion: Output<ProviderSignVersionArgs>? = null,
    public val skipRegionValidation: Output<Boolean>? = null,
    public val sourceIp: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ProviderArgs> {
    override fun toJava(): com.pulumi.alicloud.ProviderArgs =
        com.pulumi.alicloud.ProviderArgs.builder()
            .accessKey(accessKey?.applyValue({ args0 -> args0 }))
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .assumeRole(assumeRole?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .assumeRoleWithOidc(
                assumeRoleWithOidc?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .clientConnectTimeout(clientConnectTimeout?.applyValue({ args0 -> args0 }))
            .clientReadTimeout(clientReadTimeout?.applyValue({ args0 -> args0 }))
            .configurationSource(configurationSource?.applyValue({ args0 -> args0 }))
            .credentialsUri(credentialsUri?.applyValue({ args0 -> args0 }))
            .ecsRoleName(ecsRoleName?.applyValue({ args0 -> args0 }))
            .endpoints(
                endpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .fc(fc?.applyValue({ args0 -> args0 }))
            .logEndpoint(logEndpoint?.applyValue({ args0 -> args0 }))
            .maxRetryTimeout(maxRetryTimeout?.applyValue({ args0 -> args0 }))
            .mnsEndpoint(mnsEndpoint?.applyValue({ args0 -> args0 }))
            .otsInstanceName(otsInstanceName?.applyValue({ args0 -> args0 }))
            .profile(profile?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .region(region?.applyValue({ args0 -> args0 }))
            .secretKey(secretKey?.applyValue({ args0 -> args0 }))
            .secureTransport(secureTransport?.applyValue({ args0 -> args0 }))
            .securityToken(securityToken?.applyValue({ args0 -> args0 }))
            .securityTransport(securityTransport?.applyValue({ args0 -> args0 }))
            .sharedCredentialsFile(sharedCredentialsFile?.applyValue({ args0 -> args0 }))
            .signVersion(signVersion?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .skipRegionValidation(skipRegionValidation?.applyValue({ args0 -> args0 }))
            .sourceIp(sourceIp?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProviderArgs].
 */
@PulumiTagMarker
public class ProviderArgsBuilder internal constructor() {
    private var accessKey: Output<String>? = null

    private var accountId: Output<String>? = null

    private var assumeRole: Output<ProviderAssumeRoleArgs>? = null

    private var assumeRoleWithOidc: Output<ProviderAssumeRoleWithOidcArgs>? = null

    private var clientConnectTimeout: Output<Int>? = null

    private var clientReadTimeout: Output<Int>? = null

    private var configurationSource: Output<String>? = null

    private var credentialsUri: Output<String>? = null

    private var ecsRoleName: Output<String>? = null

    private var endpoints: Output<List<ProviderEndpointArgs>>? = null

    private var fc: Output<String>? = null

    private var logEndpoint: Output<String>? = null

    private var maxRetryTimeout: Output<Int>? = null

    private var mnsEndpoint: Output<String>? = null

    private var otsInstanceName: Output<String>? = null

    private var profile: Output<String>? = null

    private var protocol: Output<String>? = null

    private var region: Output<String>? = null

    private var secretKey: Output<String>? = null

    private var secureTransport: Output<String>? = null

    private var securityToken: Output<String>? = null

    private var securityTransport: Output<String>? = null

    private var sharedCredentialsFile: Output<String>? = null

    private var signVersion: Output<ProviderSignVersionArgs>? = null

    private var skipRegionValidation: Output<Boolean>? = null

    private var sourceIp: Output<String>? = null

    /**
     * @param value The access key for API operations. You can retrieve this from the 'Security Management' section of the Alibaba Cloud
     * console.
     */
    @JvmName("vqjapfsrvmawpill")
    public suspend fun accessKey(`value`: Output<String>) {
        this.accessKey = value
    }

    /**
     * @param value The account ID for some service API operations. You can retrieve this from the 'Security Settings' section of the
     * Alibaba Cloud console.
     */
    @JvmName("ppktasrdlkffvcva")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value
     */
    @JvmName("grelgcnucsxwyjxd")
    public suspend fun assumeRole(`value`: Output<ProviderAssumeRoleArgs>) {
        this.assumeRole = value
    }

    /**
     * @param value
     */
    @JvmName("jfpehsuctxfpwlhv")
    public suspend fun assumeRoleWithOidc(`value`: Output<ProviderAssumeRoleWithOidcArgs>) {
        this.assumeRoleWithOidc = value
    }

    /**
     * @param value The maximum timeout of the client connection server.
     */
    @JvmName("pqywccvjavvqjgvw")
    public suspend fun clientConnectTimeout(`value`: Output<Int>) {
        this.clientConnectTimeout = value
    }

    /**
     * @param value The maximum timeout of the client read request.
     */
    @JvmName("dmgpjdnxpirraxcd")
    public suspend fun clientReadTimeout(`value`: Output<Int>) {
        this.clientReadTimeout = value
    }

    /**
     * @param value
     */
    @JvmName("kbhyasrexrdshqib")
    public suspend fun configurationSource(`value`: Output<String>) {
        this.configurationSource = value
    }

    /**
     * @param value The URI of sidecar credentials service.
     */
    @JvmName("bgccnqemheqvjtvk")
    public suspend fun credentialsUri(`value`: Output<String>) {
        this.credentialsUri = value
    }

    /**
     * @param value The RAM Role Name attached on a ECS instance for API operations. You can retrieve this from the 'Access Control' section
     * of the Alibaba Cloud console.
     */
    @JvmName("ypdfovnxtmkngjqj")
    public suspend fun ecsRoleName(`value`: Output<String>) {
        this.ecsRoleName = value
    }

    /**
     * @param value
     */
    @JvmName("frkqfacxbdsflbcf")
    public suspend fun endpoints(`value`: Output<List<ProviderEndpointArgs>>) {
        this.endpoints = value
    }

    @JvmName("duuloedfhoyuyopt")
    public suspend fun endpoints(vararg values: Output<ProviderEndpointArgs>) {
        this.endpoints = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("sexjbvusnwpjqodj")
    public suspend fun endpoints(values: List<Output<ProviderEndpointArgs>>) {
        this.endpoints = Output.all(values)
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'fc' has been deprecated from provider version 1.28.0. New field 'fc' which in nested
      endpoints instead.
  """,
    )
    @JvmName("tnnhocqetbrltbbr")
    public suspend fun fc(`value`: Output<String>) {
        this.fc = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'log_endpoint' has been deprecated from provider version 1.28.0. New field 'log' which in
      nested endpoints instead.
  """,
    )
    @JvmName("eobcfcveicwmdqft")
    public suspend fun logEndpoint(`value`: Output<String>) {
        this.logEndpoint = value
    }

    /**
     * @param value The maximum retry timeout of the request.
     */
    @JvmName("tbhoyoyjfjgtwtip")
    public suspend fun maxRetryTimeout(`value`: Output<Int>) {
        this.maxRetryTimeout = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'mns_endpoint' has been deprecated from provider version 1.28.0. New field 'mns' which in
      nested endpoints instead.
  """,
    )
    @JvmName("jhwumymsgnixbybw")
    public suspend fun mnsEndpoint(`value`: Output<String>) {
        this.mnsEndpoint = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'ots_instance_name' has been deprecated from provider version 1.10.0. New field
      'instance_name' of resource 'alicloud_ots_table' instead.
  """,
    )
    @JvmName("lqkoniftcmwxyufe")
    public suspend fun otsInstanceName(`value`: Output<String>) {
        this.otsInstanceName = value
    }

    /**
     * @param value The profile for API operations. If not set, the default profile created with `aliyun configure` will be used.
     */
    @JvmName("fxusaiamcgwtaxfj")
    public suspend fun profile(`value`: Output<String>) {
        this.profile = value
    }

    /**
     * @param value
     */
    @JvmName("bufecnxbhbdsxggi")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value The region where Alibaba Cloud operations will take place. Examples are cn-beijing, cn-hangzhou, eu-central-1, etc.
     */
    @JvmName("wnmwctiyxvlidpev")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value The secret key for API operations. You can retrieve this from the 'Security Management' section of the Alibaba Cloud
     * console.
     */
    @JvmName("oxethebaibbgkavy")
    public suspend fun secretKey(`value`: Output<String>) {
        this.secretKey = value
    }

    /**
     * @param value The security transport for the assume role invoking.
     */
    @JvmName("unkdswurihetacxk")
    public suspend fun secureTransport(`value`: Output<String>) {
        this.secureTransport = value
    }

    /**
     * @param value security token. A security token is only required if you are using Security Token Service.
     */
    @JvmName("wkowxbogayxjhvvn")
    public suspend fun securityToken(`value`: Output<String>) {
        this.securityToken = value
    }

    /**
     * @param value
     */
    @JvmName("trkveoipmmrxyhdt")
    public suspend fun securityTransport(`value`: Output<String>) {
        this.securityTransport = value
    }

    /**
     * @param value The path to the shared credentials file. If not set this defaults to ~/.aliyun/config.json
     */
    @JvmName("yrstebcukgrukwly")
    public suspend fun sharedCredentialsFile(`value`: Output<String>) {
        this.sharedCredentialsFile = value
    }

    /**
     * @param value
     */
    @JvmName("lunpdgksdrxjkjqh")
    public suspend fun signVersion(`value`: Output<ProviderSignVersionArgs>) {
        this.signVersion = value
    }

    /**
     * @param value Skip static validation of region ID. Used by users of alternative AlibabaCloud-like APIs or users w/ access to regions
     * that are not public (yet).
     */
    @JvmName("fritslaqfkpuifhf")
    public suspend fun skipRegionValidation(`value`: Output<Boolean>) {
        this.skipRegionValidation = value
    }

    /**
     * @param value The source ip for the assume role invoking.
     */
    @JvmName("ghknxwhenkpebaic")
    public suspend fun sourceIp(`value`: Output<String>) {
        this.sourceIp = value
    }

    /**
     * @param value The access key for API operations. You can retrieve this from the 'Security Management' section of the Alibaba Cloud
     * console.
     */
    @JvmName("spenrwssnprmtubp")
    public suspend fun accessKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessKey = mapped
    }

    /**
     * @param value The account ID for some service API operations. You can retrieve this from the 'Security Settings' section of the
     * Alibaba Cloud console.
     */
    @JvmName("ycvoakiuvcoouldo")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value
     */
    @JvmName("pvbupgciualktpnl")
    public suspend fun assumeRole(`value`: ProviderAssumeRoleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assumeRole = mapped
    }

    /**
     * @param argument
     */
    @JvmName("nunioxkaecpjhjtt")
    public suspend fun assumeRole(argument: suspend ProviderAssumeRoleArgsBuilder.() -> Unit) {
        val toBeMapped = ProviderAssumeRoleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.assumeRole = mapped
    }

    /**
     * @param value
     */
    @JvmName("bmbaalrlqwvvsrwc")
    public suspend fun assumeRoleWithOidc(`value`: ProviderAssumeRoleWithOidcArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assumeRoleWithOidc = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gsbekmrbfirucgoo")
    public suspend fun assumeRoleWithOidc(argument: suspend ProviderAssumeRoleWithOidcArgsBuilder.() -> Unit) {
        val toBeMapped = ProviderAssumeRoleWithOidcArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.assumeRoleWithOidc = mapped
    }

    /**
     * @param value The maximum timeout of the client connection server.
     */
    @JvmName("cvddtoqqgffayyqc")
    public suspend fun clientConnectTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientConnectTimeout = mapped
    }

    /**
     * @param value The maximum timeout of the client read request.
     */
    @JvmName("owdggwdxwptoultf")
    public suspend fun clientReadTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientReadTimeout = mapped
    }

    /**
     * @param value
     */
    @JvmName("uoijgopidvbgdnfo")
    public suspend fun configurationSource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationSource = mapped
    }

    /**
     * @param value The URI of sidecar credentials service.
     */
    @JvmName("gmeytsfpydintiru")
    public suspend fun credentialsUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentialsUri = mapped
    }

    /**
     * @param value The RAM Role Name attached on a ECS instance for API operations. You can retrieve this from the 'Access Control' section
     * of the Alibaba Cloud console.
     */
    @JvmName("bfqttvcakmjmtvmk")
    public suspend fun ecsRoleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecsRoleName = mapped
    }

    /**
     * @param value
     */
    @JvmName("gvyaendyokvtxkrh")
    public suspend fun endpoints(`value`: List<ProviderEndpointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hndyjodjkumbbflm")
    public suspend fun endpoints(argument: List<suspend ProviderEndpointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ProviderEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param argument
     */
    @JvmName("jjihfyypwksexwie")
    public suspend fun endpoints(vararg argument: suspend ProviderEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ProviderEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qbahllxnekhjuowm")
    public suspend fun endpoints(argument: suspend ProviderEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ProviderEndpointArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param values
     */
    @JvmName("aplvsamsbfddynnw")
    public suspend fun endpoints(vararg values: ProviderEndpointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'fc' has been deprecated from provider version 1.28.0. New field 'fc' which in nested
      endpoints instead.
  """,
    )
    @JvmName("ecgeqpcmfuhatlsq")
    public suspend fun fc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fc = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'log_endpoint' has been deprecated from provider version 1.28.0. New field 'log' which in
      nested endpoints instead.
  """,
    )
    @JvmName("mujgpdrlhtnsvcbg")
    public suspend fun logEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logEndpoint = mapped
    }

    /**
     * @param value The maximum retry timeout of the request.
     */
    @JvmName("wkjwqmyowbyerrax")
    public suspend fun maxRetryTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxRetryTimeout = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'mns_endpoint' has been deprecated from provider version 1.28.0. New field 'mns' which in
      nested endpoints instead.
  """,
    )
    @JvmName("wrckxgivhqqvgepl")
    public suspend fun mnsEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mnsEndpoint = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'ots_instance_name' has been deprecated from provider version 1.10.0. New field
      'instance_name' of resource 'alicloud_ots_table' instead.
  """,
    )
    @JvmName("yfpiwxcqernxwtfm")
    public suspend fun otsInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.otsInstanceName = mapped
    }

    /**
     * @param value The profile for API operations. If not set, the default profile created with `aliyun configure` will be used.
     */
    @JvmName("smqudydkupfxfdeq")
    public suspend fun profile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profile = mapped
    }

    /**
     * @param value
     */
    @JvmName("eisyviuysiudphri")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The region where Alibaba Cloud operations will take place. Examples are cn-beijing, cn-hangzhou, eu-central-1, etc.
     */
    @JvmName("awctlqchpfxwxjtk")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value The secret key for API operations. You can retrieve this from the 'Security Management' section of the Alibaba Cloud
     * console.
     */
    @JvmName("gkopkqwimhgoaiji")
    public suspend fun secretKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretKey = mapped
    }

    /**
     * @param value The security transport for the assume role invoking.
     */
    @JvmName("ewifukfrlcxuckjd")
    public suspend fun secureTransport(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secureTransport = mapped
    }

    /**
     * @param value security token. A security token is only required if you are using Security Token Service.
     */
    @JvmName("tnxinuwaktbopagl")
    public suspend fun securityToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityToken = mapped
    }

    /**
     * @param value
     */
    @JvmName("sptiorqyfpeohyyu")
    public suspend fun securityTransport(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityTransport = mapped
    }

    /**
     * @param value The path to the shared credentials file. If not set this defaults to ~/.aliyun/config.json
     */
    @JvmName("qqnftqdscgvubwmg")
    public suspend fun sharedCredentialsFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedCredentialsFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("ofwljdofmtcfxytg")
    public suspend fun signVersion(`value`: ProviderSignVersionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signVersion = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dwlrgxggxvbcivrn")
    public suspend fun signVersion(argument: suspend ProviderSignVersionArgsBuilder.() -> Unit) {
        val toBeMapped = ProviderSignVersionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.signVersion = mapped
    }

    /**
     * @param value Skip static validation of region ID. Used by users of alternative AlibabaCloud-like APIs or users w/ access to regions
     * that are not public (yet).
     */
    @JvmName("pbuhiluldmqmfvqy")
    public suspend fun skipRegionValidation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipRegionValidation = mapped
    }

    /**
     * @param value The source ip for the assume role invoking.
     */
    @JvmName("ondgwejsjtrifyga")
    public suspend fun sourceIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIp = mapped
    }

    internal fun build(): ProviderArgs = ProviderArgs(
        accessKey = accessKey,
        accountId = accountId,
        assumeRole = assumeRole,
        assumeRoleWithOidc = assumeRoleWithOidc,
        clientConnectTimeout = clientConnectTimeout,
        clientReadTimeout = clientReadTimeout,
        configurationSource = configurationSource,
        credentialsUri = credentialsUri,
        ecsRoleName = ecsRoleName,
        endpoints = endpoints,
        fc = fc,
        logEndpoint = logEndpoint,
        maxRetryTimeout = maxRetryTimeout,
        mnsEndpoint = mnsEndpoint,
        otsInstanceName = otsInstanceName,
        profile = profile,
        protocol = protocol,
        region = region,
        secretKey = secretKey,
        secureTransport = secureTransport,
        securityToken = securityToken,
        securityTransport = securityTransport,
        sharedCredentialsFile = sharedCredentialsFile,
        signVersion = signVersion,
        skipRegionValidation = skipRegionValidation,
        sourceIp = sourceIp,
    )
}
