@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kotlin.inputs

import com.pulumi.alicloud.inputs.GetFileCrc64ChecksumPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getFileCrc64Checksum.
 * @property filename The name of the file to be computed crc64 checksum.
 * @property outputFile
 */
public data class GetFileCrc64ChecksumPlainArgs(
    public val filename: String,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.inputs.GetFileCrc64ChecksumPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.inputs.GetFileCrc64ChecksumPlainArgs =
        com.pulumi.alicloud.inputs.GetFileCrc64ChecksumPlainArgs.builder()
            .filename(filename.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFileCrc64ChecksumPlainArgs].
 */
@PulumiTagMarker
public class GetFileCrc64ChecksumPlainArgsBuilder internal constructor() {
    private var filename: String? = null

    private var outputFile: String? = null

    /**
     * @param value The name of the file to be computed crc64 checksum.
     */
    @JvmName("sgcsvgkocgntlhvn")
    public suspend fun filename(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filename = mapped
    }

    /**
     * @param value
     */
    @JvmName("mrwekvcvbqpdwwhc")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetFileCrc64ChecksumPlainArgs = GetFileCrc64ChecksumPlainArgs(
        filename = filename ?: throw PulumiNullFieldException("filename"),
        outputFile = outputFile,
    )
}
