@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kotlin.inputs

import com.pulumi.alicloud.inputs.GetMscSubContactVerificationMessagePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getMscSubContactVerificationMessage.
 * @property contactId The ID of the Contact.
 * @property type How a user receives verification messages. Valid values : `1`, `2`.
 */
public data class GetMscSubContactVerificationMessagePlainArgs(
    public val contactId: String,
    public val type: Int,
) : ConvertibleToJava<com.pulumi.alicloud.inputs.GetMscSubContactVerificationMessagePlainArgs> {
    override fun toJava(): com.pulumi.alicloud.inputs.GetMscSubContactVerificationMessagePlainArgs =
        com.pulumi.alicloud.inputs.GetMscSubContactVerificationMessagePlainArgs.builder()
            .contactId(contactId.let({ args0 -> args0 }))
            .type(type.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMscSubContactVerificationMessagePlainArgs].
 */
@PulumiTagMarker
public class GetMscSubContactVerificationMessagePlainArgsBuilder internal constructor() {
    private var contactId: String? = null

    private var type: Int? = null

    /**
     * @param value The ID of the Contact.
     */
    @JvmName("npabblbhuttsinfd")
    public suspend fun contactId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.contactId = mapped
    }

    /**
     * @param value How a user receives verification messages. Valid values : `1`, `2`.
     */
    @JvmName("twmyjarkxshthshh")
    public suspend fun type(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): GetMscSubContactVerificationMessagePlainArgs =
        GetMscSubContactVerificationMessagePlainArgs(
            contactId = contactId ?: throw PulumiNullFieldException("contactId"),
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
