@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kotlin.inputs

import com.pulumi.alicloud.inputs.GetMscSubSubscriptionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getMscSubSubscriptions.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetMscSubSubscriptionsPlainArgs(
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.inputs.GetMscSubSubscriptionsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.inputs.GetMscSubSubscriptionsPlainArgs =
        com.pulumi.alicloud.inputs.GetMscSubSubscriptionsPlainArgs.builder()
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMscSubSubscriptionsPlainArgs].
 */
@PulumiTagMarker
public class GetMscSubSubscriptionsPlainArgsBuilder internal constructor() {
    private var outputFile: String? = null

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("oqkkhjxpkuwehthc")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetMscSubSubscriptionsPlainArgs = GetMscSubSubscriptionsPlainArgs(
        outputFile = outputFile,
    )
}
