@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kotlin.inputs

import com.pulumi.alicloud.inputs.GetRegionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRegions.
 * @property current Set to true to match only the region configured in the provider.
 * @property name The name of the region to select, such as `eu-central-1`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * > **NOTE:** You will get an error if you set `current` to true and `name` to a different value from the one you configured in the provider.
 * It is better to either use `name` or `current`, but not both at the same time.
 */
public data class GetRegionsPlainArgs(
    public val current: Boolean? = null,
    public val name: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.inputs.GetRegionsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.inputs.GetRegionsPlainArgs =
        com.pulumi.alicloud.inputs.GetRegionsPlainArgs.builder()
            .current(current?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRegionsPlainArgs].
 */
@PulumiTagMarker
public class GetRegionsPlainArgsBuilder internal constructor() {
    private var current: Boolean? = null

    private var name: String? = null

    private var outputFile: String? = null

    /**
     * @param value Set to true to match only the region configured in the provider.
     */
    @JvmName("ptqfgywpvcwstebf")
    public suspend fun current(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.current = mapped
    }

    /**
     * @param value The name of the region to select, such as `eu-central-1`.
     */
    @JvmName("icbrpwawbvufpetc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     * > **NOTE:** You will get an error if you set `current` to true and `name` to a different value from the one you configured in the provider.
     * It is better to either use `name` or `current`, but not both at the same time.
     */
    @JvmName("ehagkweymyhpwyxn")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetRegionsPlainArgs = GetRegionsPlainArgs(
        current = current,
        name = name,
        outputFile = outputFile,
    )
}
