@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kotlin.inputs

import com.pulumi.alicloud.inputs.GetZonesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getZones.
 * @property availableDiskCategory Filter the results by a specific disk category. Can be either `cloud`, `cloud_efficiency`, `cloud_ssd`, `ephemeral_ssd`.
 * @property availableInstanceType Filter the results by a specific instance type.
 * @property availableResourceCreation Filter the results by a specific resource type.
 * Valid values: `Instance`, `Disk`, `VSwitch`, `Rds`, `KVStore`, `FunctionCompute`, `Elasticsearch`, `Slb`.
 * > **NOTE:** From version 1.134.0, the `available_resource_creation` value "Rds" has been deprecated.
 * If you want to fetch the available zones for RDS instance, you can use datasource alicloud_db_zones
 * @property availableSlbAddressIpVersion Filter the results by a slb instance address version. Can be either `ipv4`, or `ipv6`.
 * > **NOTE:** The disk category `cloud` has been outdated and can only be used by non-I/O Optimized ECS instances. Many availability zones don't support it. It is recommended to use `cloud_efficiency` or `cloud_ssd`.
 * @property availableSlbAddressType Filter the results by a slb instance address type. Can be either `Vpc`, `classic_internet` or `classic_intranet`
 * @property enableDetails Default to false and only output `id` in the `zones` block. Set it to true can output more details.
 * @property instanceChargeType Filter the results by a specific ECS instance charge type. Valid values: `PrePaid` and `PostPaid`. Default to `PostPaid`.
 * @property multi Indicate whether the zones can be used in a multi AZ configuration. Default to `false`. Multi AZ is usually used to launch RDS instances.
 * @property networkType Filter the results by a specific network type. Valid values: `Classic` and `Vpc`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property spotStrategy - (Optional) Filter the results by a specific ECS spot type. Valid values: `NoSpot`, `SpotWithPriceLimit` and `SpotAsPriceGo`. Default to `NoSpot`.
 */
public data class GetZonesPlainArgs(
    public val availableDiskCategory: String? = null,
    public val availableInstanceType: String? = null,
    public val availableResourceCreation: String? = null,
    public val availableSlbAddressIpVersion: String? = null,
    public val availableSlbAddressType: String? = null,
    public val enableDetails: Boolean? = null,
    public val instanceChargeType: String? = null,
    public val multi: Boolean? = null,
    public val networkType: String? = null,
    public val outputFile: String? = null,
    public val spotStrategy: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.inputs.GetZonesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.inputs.GetZonesPlainArgs =
        com.pulumi.alicloud.inputs.GetZonesPlainArgs.builder()
            .availableDiskCategory(availableDiskCategory?.let({ args0 -> args0 }))
            .availableInstanceType(availableInstanceType?.let({ args0 -> args0 }))
            .availableResourceCreation(availableResourceCreation?.let({ args0 -> args0 }))
            .availableSlbAddressIpVersion(availableSlbAddressIpVersion?.let({ args0 -> args0 }))
            .availableSlbAddressType(availableSlbAddressType?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType?.let({ args0 -> args0 }))
            .multi(multi?.let({ args0 -> args0 }))
            .networkType(networkType?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .spotStrategy(spotStrategy?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetZonesPlainArgs].
 */
@PulumiTagMarker
public class GetZonesPlainArgsBuilder internal constructor() {
    private var availableDiskCategory: String? = null

    private var availableInstanceType: String? = null

    private var availableResourceCreation: String? = null

    private var availableSlbAddressIpVersion: String? = null

    private var availableSlbAddressType: String? = null

    private var enableDetails: Boolean? = null

    private var instanceChargeType: String? = null

    private var multi: Boolean? = null

    private var networkType: String? = null

    private var outputFile: String? = null

    private var spotStrategy: String? = null

    /**
     * @param value Filter the results by a specific disk category. Can be either `cloud`, `cloud_efficiency`, `cloud_ssd`, `ephemeral_ssd`.
     */
    @JvmName("bcyqdoukxgfgufjb")
    public suspend fun availableDiskCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.availableDiskCategory = mapped
    }

    /**
     * @param value Filter the results by a specific instance type.
     */
    @JvmName("ysmepsoywedtvmgx")
    public suspend fun availableInstanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.availableInstanceType = mapped
    }

    /**
     * @param value Filter the results by a specific resource type.
     * Valid values: `Instance`, `Disk`, `VSwitch`, `Rds`, `KVStore`, `FunctionCompute`, `Elasticsearch`, `Slb`.
     * > **NOTE:** From version 1.134.0, the `available_resource_creation` value "Rds" has been deprecated.
     * If you want to fetch the available zones for RDS instance, you can use datasource alicloud_db_zones
     */
    @JvmName("txymllgcxtihiawv")
    public suspend fun availableResourceCreation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.availableResourceCreation = mapped
    }

    /**
     * @param value Filter the results by a slb instance address version. Can be either `ipv4`, or `ipv6`.
     * > **NOTE:** The disk category `cloud` has been outdated and can only be used by non-I/O Optimized ECS instances. Many availability zones don't support it. It is recommended to use `cloud_efficiency` or `cloud_ssd`.
     */
    @JvmName("yaeujhnasgflnvsg")
    public suspend fun availableSlbAddressIpVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.availableSlbAddressIpVersion = mapped
    }

    /**
     * @param value Filter the results by a slb instance address type. Can be either `Vpc`, `classic_internet` or `classic_intranet`
     */
    @JvmName("yofxbhpknjclsfcy")
    public suspend fun availableSlbAddressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.availableSlbAddressType = mapped
    }

    /**
     * @param value Default to false and only output `id` in the `zones` block. Set it to true can output more details.
     */
    @JvmName("jrbcwfspvmqphtbc")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value Filter the results by a specific ECS instance charge type. Valid values: `PrePaid` and `PostPaid`. Default to `PostPaid`.
     */
    @JvmName("dyohjyckvjwbesfx")
    public suspend fun instanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceChargeType = mapped
    }

    /**
     * @param value Indicate whether the zones can be used in a multi AZ configuration. Default to `false`. Multi AZ is usually used to launch RDS instances.
     */
    @JvmName("owxcyvyiwkikhubt")
    public suspend fun multi(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.multi = mapped
    }

    /**
     * @param value Filter the results by a specific network type. Valid values: `Classic` and `Vpc`.
     */
    @JvmName("ujneditrkxdsuiph")
    public suspend fun networkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.networkType = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("nksfoqrrfkbxxrww")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value - (Optional) Filter the results by a specific ECS spot type. Valid values: `NoSpot`, `SpotWithPriceLimit` and `SpotAsPriceGo`. Default to `NoSpot`.
     */
    @JvmName("jdjvhnadckxgtnxe")
    public suspend fun spotStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.spotStrategy = mapped
    }

    internal fun build(): GetZonesPlainArgs = GetZonesPlainArgs(
        availableDiskCategory = availableDiskCategory,
        availableInstanceType = availableInstanceType,
        availableResourceCreation = availableResourceCreation,
        availableSlbAddressIpVersion = availableSlbAddressIpVersion,
        availableSlbAddressType = availableSlbAddressType,
        enableDetails = enableDetails,
        instanceChargeType = instanceChargeType,
        multi = multi,
        networkType = networkType,
        outputFile = outputFile,
        spotStrategy = spotStrategy,
    )
}
