@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kotlin.inputs

import com.pulumi.alicloud.inputs.ProviderAssumeRoleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property externalId
 * @property policy The permissions applied when assuming a role. You cannot use, this policy to grant further permissions that are in excess to those of the, role that is being assumed.
 * @property roleArn The ARN of a RAM role to assume prior to making API calls.
 * @property sessionExpiration The time after which the established session for assuming role expires. Valid value range: [900-3600] seconds. Default to 0 (in this case Alicloud use own default value).
 * @property sessionName
 */
public data class ProviderAssumeRoleArgs(
    public val externalId: Output<String>? = null,
    public val policy: Output<String>? = null,
    public val roleArn: Output<String>,
    public val sessionExpiration: Output<Int>? = null,
    public val sessionName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.inputs.ProviderAssumeRoleArgs> {
    override fun toJava(): com.pulumi.alicloud.inputs.ProviderAssumeRoleArgs =
        com.pulumi.alicloud.inputs.ProviderAssumeRoleArgs.builder()
            .externalId(externalId?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .sessionExpiration(sessionExpiration?.applyValue({ args0 -> args0 }))
            .sessionName(sessionName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProviderAssumeRoleArgs].
 */
@PulumiTagMarker
public class ProviderAssumeRoleArgsBuilder internal constructor() {
    private var externalId: Output<String>? = null

    private var policy: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var sessionExpiration: Output<Int>? = null

    private var sessionName: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("tekvrbgrygogthcd")
    public suspend fun externalId(`value`: Output<String>) {
        this.externalId = value
    }

    /**
     * @param value The permissions applied when assuming a role. You cannot use, this policy to grant further permissions that are in excess to those of the, role that is being assumed.
     */
    @JvmName("ycwjjutoayvtafmw")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The ARN of a RAM role to assume prior to making API calls.
     */
    @JvmName("fepqeflxmyguuebi")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The time after which the established session for assuming role expires. Valid value range: [900-3600] seconds. Default to 0 (in this case Alicloud use own default value).
     */
    @JvmName("jxwraaibmrgoaufy")
    public suspend fun sessionExpiration(`value`: Output<Int>) {
        this.sessionExpiration = value
    }

    /**
     * @param value
     */
    @JvmName("tjbyqjwouvyvsmri")
    public suspend fun sessionName(`value`: Output<String>) {
        this.sessionName = value
    }

    /**
     * @param value
     */
    @JvmName("mxmbxmmtckydsbos")
    public suspend fun externalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalId = mapped
    }

    /**
     * @param value The permissions applied when assuming a role. You cannot use, this policy to grant further permissions that are in excess to those of the, role that is being assumed.
     */
    @JvmName("hymcikquhvqbwagt")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The ARN of a RAM role to assume prior to making API calls.
     */
    @JvmName("vaohhryleskkwgfg")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The time after which the established session for assuming role expires. Valid value range: [900-3600] seconds. Default to 0 (in this case Alicloud use own default value).
     */
    @JvmName("yapnxahhifqbdhpi")
    public suspend fun sessionExpiration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionExpiration = mapped
    }

    /**
     * @param value
     */
    @JvmName("srwdxqwwdjhbggoo")
    public suspend fun sessionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionName = mapped
    }

    internal fun build(): ProviderAssumeRoleArgs = ProviderAssumeRoleArgs(
        externalId = externalId,
        policy = policy,
        roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        sessionExpiration = sessionExpiration,
        sessionName = sessionName,
    )
}
