@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kotlin.inputs

import com.pulumi.alicloud.inputs.ProviderAssumeRoleWithOidcArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property oidcProviderArn ARN of the OIDC IdP.
 * @property oidcToken
 * @property oidcTokenFile The file path of OIDC token that is issued by the external IdP.
 * @property policy The policy that specifies the permissions of the returned STS token. You can use this parameter to grant the STS token fewer permissions than the permissions granted to the RAM role.
 * @property roleArn ARN of a RAM role to assume prior to making API calls.
 * @property roleSessionName The custom name of the role session. Set this parameter based on your business requirements. In most cases, this parameter is set to the identity of the user who calls the operation, for example, the username.
 * @property sessionExpiration The validity period of the STS token. Unit: seconds. Default value: 3600. Minimum value: 900. Maximum value: the value of the MaxSessionDuration parameter when creating a ram role.
 */
public data class ProviderAssumeRoleWithOidcArgs(
    public val oidcProviderArn: Output<String>,
    public val oidcToken: Output<String>? = null,
    public val oidcTokenFile: Output<String>? = null,
    public val policy: Output<String>? = null,
    public val roleArn: Output<String>,
    public val roleSessionName: Output<String>? = null,
    public val sessionExpiration: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.inputs.ProviderAssumeRoleWithOidcArgs> {
    override fun toJava(): com.pulumi.alicloud.inputs.ProviderAssumeRoleWithOidcArgs =
        com.pulumi.alicloud.inputs.ProviderAssumeRoleWithOidcArgs.builder()
            .oidcProviderArn(oidcProviderArn.applyValue({ args0 -> args0 }))
            .oidcToken(oidcToken?.applyValue({ args0 -> args0 }))
            .oidcTokenFile(oidcTokenFile?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .roleSessionName(roleSessionName?.applyValue({ args0 -> args0 }))
            .sessionExpiration(sessionExpiration?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProviderAssumeRoleWithOidcArgs].
 */
@PulumiTagMarker
public class ProviderAssumeRoleWithOidcArgsBuilder internal constructor() {
    private var oidcProviderArn: Output<String>? = null

    private var oidcToken: Output<String>? = null

    private var oidcTokenFile: Output<String>? = null

    private var policy: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var roleSessionName: Output<String>? = null

    private var sessionExpiration: Output<Int>? = null

    /**
     * @param value ARN of the OIDC IdP.
     */
    @JvmName("rbjarkqvcfounxtl")
    public suspend fun oidcProviderArn(`value`: Output<String>) {
        this.oidcProviderArn = value
    }

    /**
     * @param value
     */
    @JvmName("vtiofbogcqncdqxi")
    public suspend fun oidcToken(`value`: Output<String>) {
        this.oidcToken = value
    }

    /**
     * @param value The file path of OIDC token that is issued by the external IdP.
     */
    @JvmName("xyuxtsfjjulrvcnk")
    public suspend fun oidcTokenFile(`value`: Output<String>) {
        this.oidcTokenFile = value
    }

    /**
     * @param value The policy that specifies the permissions of the returned STS token. You can use this parameter to grant the STS token fewer permissions than the permissions granted to the RAM role.
     */
    @JvmName("lfidsonpwxxsbqpm")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value ARN of a RAM role to assume prior to making API calls.
     */
    @JvmName("ubkfspwjtbxtlwpq")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The custom name of the role session. Set this parameter based on your business requirements. In most cases, this parameter is set to the identity of the user who calls the operation, for example, the username.
     */
    @JvmName("cfqqjpeekoltmexm")
    public suspend fun roleSessionName(`value`: Output<String>) {
        this.roleSessionName = value
    }

    /**
     * @param value The validity period of the STS token. Unit: seconds. Default value: 3600. Minimum value: 900. Maximum value: the value of the MaxSessionDuration parameter when creating a ram role.
     */
    @JvmName("ckymijlimqembbtc")
    public suspend fun sessionExpiration(`value`: Output<Int>) {
        this.sessionExpiration = value
    }

    /**
     * @param value ARN of the OIDC IdP.
     */
    @JvmName("qcumvsbukkatrgqu")
    public suspend fun oidcProviderArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.oidcProviderArn = mapped
    }

    /**
     * @param value
     */
    @JvmName("cfuuykivahgmhqsi")
    public suspend fun oidcToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oidcToken = mapped
    }

    /**
     * @param value The file path of OIDC token that is issued by the external IdP.
     */
    @JvmName("fkxhqlhpvdxheftg")
    public suspend fun oidcTokenFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oidcTokenFile = mapped
    }

    /**
     * @param value The policy that specifies the permissions of the returned STS token. You can use this parameter to grant the STS token fewer permissions than the permissions granted to the RAM role.
     */
    @JvmName("yplsadkildcsybpx")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value ARN of a RAM role to assume prior to making API calls.
     */
    @JvmName("alitlldfshymbory")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The custom name of the role session. Set this parameter based on your business requirements. In most cases, this parameter is set to the identity of the user who calls the operation, for example, the username.
     */
    @JvmName("dgjeyqeckkubyddn")
    public suspend fun roleSessionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleSessionName = mapped
    }

    /**
     * @param value The validity period of the STS token. Unit: seconds. Default value: 3600. Minimum value: 900. Maximum value: the value of the MaxSessionDuration parameter when creating a ram role.
     */
    @JvmName("assvnuvljndktren")
    public suspend fun sessionExpiration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionExpiration = mapped
    }

    internal fun build(): ProviderAssumeRoleWithOidcArgs = ProviderAssumeRoleWithOidcArgs(
        oidcProviderArn = oidcProviderArn ?: throw PulumiNullFieldException("oidcProviderArn"),
        oidcToken = oidcToken,
        oidcTokenFile = oidcTokenFile,
        policy = policy,
        roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        roleSessionName = roleSessionName,
        sessionExpiration = sessionExpiration,
    )
}
