@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kotlin.inputs

import com.pulumi.alicloud.inputs.ProviderEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property acr Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom acr endpoints.
 * @property actiontrail Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Actiontrail endpoints.
 * @property adb Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom AnalyticDB endpoints.
 * @property alb Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom alb endpoints.
 * @property alidfs Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom alidfs endpoints.
 * @property alidns Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom alidns endpoints.
 * @property alikafka Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ALIKAFKA endpoints.
 * @property apigateway Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Api Gateway endpoints.
 * @property arms Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom arms endpoints.
 * @property bastionhost Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom bastionhost endpoints.
 * @property beebot Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom beebot endpoints.
 * @property bpstudio Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom bpstudio endpoints.
 * @property brainIndustrial Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom brain_industrial endpoints.
 * @property bssopenapi Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom BSSOPENAPI endpoints.
 * @property cas Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom CAS endpoints.
 * @property cassandra Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cassandra endpoints.
 * @property cbn Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cbn endpoints.
 * @property cbs Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cbs endpoints.
 * @property cddc Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cddc endpoints.
 * @property cdn Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom CDN endpoints.
 * @property cds Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cds endpoints.
 * @property clickhouse Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom clickhouse endpoints.
 * @property cloudauth Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cloudauth endpoints.
 * @property cloudfirewall Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cloudfirewall endpoints.
 * @property cloudfw Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cloudfw endpoints.
 * @property cloudphone Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cloudphone endpoints.
 * @property cloudsso Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cloudsso endpoints.
 * @property cms Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Cloud Monitor endpoints.
 * @property computenest Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom computenest endpoints.
 * @property config Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom config endpoints.
 * @property cr Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Container Registry endpoints.
 * @property cs Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Container Service endpoints.
 * @property das Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom das endpoints.
 * @property datahub Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Datahub endpoints.
 * @property dataworkspublic Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dataworkspublic endpoints.
 * @property dbfs Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dbfs endpoints.
 * @property dcdn Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dcdn endpoints.
 * @property ddosbasic Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ddosbasic endpoints.
 * @property ddosbgp Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom DDOSBGP endpoints.
 * @property ddoscoo Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom DDOSCOO endpoints.
 * @property dds Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom MongoDB endpoints.
 * @property devopsrdc Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom devopsrdc endpoints.
 * @property dg Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dg endpoints.
 * @property dm Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dm endpoints.
 * @property dmsEnterprise Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dms_enterprise endpoints.
 * @property dmsenterprise Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dmsenterprise endpoints.
 * @property dns Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom DNS endpoints.
 * @property drds Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom DRDS endpoints.
 * @property dts Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dts endpoints.
 * @property dysms
 * @property eais Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom eais endpoints.
 * @property ebs Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ebs endpoints.
 * @property eci Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom eci endpoints.
 * @property ecs Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ECS endpoints.
 * @property edas Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom edas endpoints.
 * @property edasschedulerx Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom edasschedulerx endpoints.
 * @property edsuser Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom edsuser endpoints.
 * @property eflo Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom eflo endpoints.
 * @property ehpc Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ehpc endpoints.
 * @property ehs Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ehs endpoints.
 * @property eipanycast Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom eipanycast endpoints.
 * @property elasticsearch Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Elasticsearch endpoints.
 * @property emr Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom EMR endpoints.
 * @property ens Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ens endpoints.
 * @property ess Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Autoscaling endpoints.
 * @property eventbridge Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom eventbridge_share endpoints.
 * @property fc Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Function Computing endpoints.
 * @property fnf Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom fnf endpoints.
 * @property ga Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ga endpoints.
 * @property gaplus Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom gaplus endpoints.
 * @property gds Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom gds endpoints.
 * @property gpdb Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom GPDB endpoints.
 * @property gwsecd Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom gwsecd endpoints.
 * @property hbr Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom hbr endpoints.
 * @property hcsSgw Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom hcs_sgw endpoints.
 * @property hitsdb Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom hitsdb endpoints.
 * @property imm Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom imm endpoints.
 * @property imp Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom imp endpoints.
 * @property ims Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ims endpoints.
 * @property iot Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom iot endpoints.
 * @property kms Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom KMS endpoints.
 * @property kvstore Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom R-KVStore endpoints.
 * @property location Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Location Service endpoints.
 * @property log Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Log Service endpoints.
 * @property market Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Market Place endpoints.
 * @property maxcompute Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom MaxCompute endpoints.
 * @property mhub Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom mhub endpoints.
 * @property mns Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom MNS endpoints.
 * @property mscopensubscription Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom mscopensubscription endpoints.
 * @property mse Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom mse endpoints.
 * @property nas Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom NAS endpoints.
 * @property nlb Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom nlb endpoints.
 * @property oceanbase Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom oceanbase endpoints.
 * @property ons Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ONS endpoints.
 * @property onsproxy Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom onsproxy endpoints.
 * @property oos Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom oos endpoints.
 * @property opensearch Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom opensearch endpoints.
 * @property oss Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom OSS endpoints.
 * @property ots Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Table Store endpoints.
 * @property polardb Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom PolarDB endpoints.
 * @property privatelink Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom privatelink endpoints.
 * @property pvtz Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Private Zone endpoints.
 * @property quickbi Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom quickbi endpoints.
 * @property quotas Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom quotas endpoints.
 * @property rKvstore Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom r_kvstore endpoints.
 * @property ram Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom RAM endpoints.
 * @property rds Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom RDS endpoints.
 * @property redisa Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom redisa endpoints.
 * @property resourcemanager Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom resourcemanager endpoints.
 * @property ressharing Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom resourcesharing endpoints.
 * @property ros Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ros endpoints.
 * @property sas Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom sas endpoints.
 * @property scdn Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom scdn endpoints.
 * @property sddp Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom sddp endpoints.
 * @property selectdb Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom selectdb endpoints.
 * @property serverless Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom serverless endpoints.
 * @property servicemesh Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom servicemesh endpoints.
 * @property sgw Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom sgw endpoints.
 * @property slb Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom SLB endpoints.
 * @property smartag Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom smartag endpoints.
 * @property srvcatalog Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom srvcatalog endpoints.
 * @property sts Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom STS endpoints.
 * @property swas Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom swas endpoints.
 * @property tag Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom tag endpoints.
 * @property vod Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom vod endpoints.
 * @property vpc Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom VPC and VPN endpoints.
 * @property vpcpeer Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom vpcpeer endpoints.
 * @property vs Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom vs endpoints.
 * @property waf Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom waf endpoints.
 * @property wafOpenapi Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom waf_openapi endpoints.
 */
public data class ProviderEndpointArgs(
    public val acr: Output<String>? = null,
    public val actiontrail: Output<String>? = null,
    public val adb: Output<String>? = null,
    public val alb: Output<String>? = null,
    public val alidfs: Output<String>? = null,
    public val alidns: Output<String>? = null,
    public val alikafka: Output<String>? = null,
    public val apigateway: Output<String>? = null,
    public val arms: Output<String>? = null,
    public val bastionhost: Output<String>? = null,
    public val beebot: Output<String>? = null,
    public val bpstudio: Output<String>? = null,
    public val brainIndustrial: Output<String>? = null,
    public val bssopenapi: Output<String>? = null,
    public val cas: Output<String>? = null,
    public val cassandra: Output<String>? = null,
    public val cbn: Output<String>? = null,
    public val cbs: Output<String>? = null,
    public val cddc: Output<String>? = null,
    public val cdn: Output<String>? = null,
    public val cds: Output<String>? = null,
    public val clickhouse: Output<String>? = null,
    public val cloudauth: Output<String>? = null,
    public val cloudfirewall: Output<String>? = null,
    public val cloudfw: Output<String>? = null,
    public val cloudphone: Output<String>? = null,
    public val cloudsso: Output<String>? = null,
    public val cms: Output<String>? = null,
    public val computenest: Output<String>? = null,
    public val config: Output<String>? = null,
    public val cr: Output<String>? = null,
    public val cs: Output<String>? = null,
    public val das: Output<String>? = null,
    public val datahub: Output<String>? = null,
    public val dataworkspublic: Output<String>? = null,
    public val dbfs: Output<String>? = null,
    public val dcdn: Output<String>? = null,
    public val ddosbasic: Output<String>? = null,
    public val ddosbgp: Output<String>? = null,
    public val ddoscoo: Output<String>? = null,
    public val dds: Output<String>? = null,
    public val devopsrdc: Output<String>? = null,
    public val dg: Output<String>? = null,
    public val dm: Output<String>? = null,
    public val dmsEnterprise: Output<String>? = null,
    public val dmsenterprise: Output<String>? = null,
    public val dns: Output<String>? = null,
    public val drds: Output<String>? = null,
    public val dts: Output<String>? = null,
    public val dysms: Output<String>? = null,
    public val eais: Output<String>? = null,
    public val ebs: Output<String>? = null,
    public val eci: Output<String>? = null,
    public val ecs: Output<String>? = null,
    public val edas: Output<String>? = null,
    public val edasschedulerx: Output<String>? = null,
    public val edsuser: Output<String>? = null,
    public val eflo: Output<String>? = null,
    public val ehpc: Output<String>? = null,
    public val ehs: Output<String>? = null,
    public val eipanycast: Output<String>? = null,
    public val elasticsearch: Output<String>? = null,
    public val emr: Output<String>? = null,
    public val ens: Output<String>? = null,
    public val ess: Output<String>? = null,
    public val eventbridge: Output<String>? = null,
    public val fc: Output<String>? = null,
    public val fnf: Output<String>? = null,
    public val ga: Output<String>? = null,
    public val gaplus: Output<String>? = null,
    public val gds: Output<String>? = null,
    public val gpdb: Output<String>? = null,
    public val gwsecd: Output<String>? = null,
    public val hbr: Output<String>? = null,
    public val hcsSgw: Output<String>? = null,
    public val hitsdb: Output<String>? = null,
    public val imm: Output<String>? = null,
    public val imp: Output<String>? = null,
    public val ims: Output<String>? = null,
    public val iot: Output<String>? = null,
    public val kms: Output<String>? = null,
    public val kvstore: Output<String>? = null,
    public val location: Output<String>? = null,
    public val log: Output<String>? = null,
    public val market: Output<String>? = null,
    public val maxcompute: Output<String>? = null,
    public val mhub: Output<String>? = null,
    public val mns: Output<String>? = null,
    public val mscopensubscription: Output<String>? = null,
    public val mse: Output<String>? = null,
    public val nas: Output<String>? = null,
    public val nlb: Output<String>? = null,
    public val oceanbase: Output<String>? = null,
    public val ons: Output<String>? = null,
    public val onsproxy: Output<String>? = null,
    public val oos: Output<String>? = null,
    public val opensearch: Output<String>? = null,
    public val oss: Output<String>? = null,
    public val ots: Output<String>? = null,
    public val polardb: Output<String>? = null,
    public val privatelink: Output<String>? = null,
    public val pvtz: Output<String>? = null,
    public val quickbi: Output<String>? = null,
    public val quotas: Output<String>? = null,
    public val rKvstore: Output<String>? = null,
    public val ram: Output<String>? = null,
    public val rds: Output<String>? = null,
    public val redisa: Output<String>? = null,
    public val resourcemanager: Output<String>? = null,
    public val ressharing: Output<String>? = null,
    public val ros: Output<String>? = null,
    public val sas: Output<String>? = null,
    public val scdn: Output<String>? = null,
    public val sddp: Output<String>? = null,
    public val selectdb: Output<String>? = null,
    public val serverless: Output<String>? = null,
    public val servicemesh: Output<String>? = null,
    public val sgw: Output<String>? = null,
    public val slb: Output<String>? = null,
    public val smartag: Output<String>? = null,
    public val srvcatalog: Output<String>? = null,
    public val sts: Output<String>? = null,
    public val swas: Output<String>? = null,
    public val tag: Output<String>? = null,
    public val vod: Output<String>? = null,
    public val vpc: Output<String>? = null,
    public val vpcpeer: Output<String>? = null,
    public val vs: Output<String>? = null,
    public val waf: Output<String>? = null,
    public val wafOpenapi: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.inputs.ProviderEndpointArgs> {
    override fun toJava(): com.pulumi.alicloud.inputs.ProviderEndpointArgs =
        com.pulumi.alicloud.inputs.ProviderEndpointArgs.builder()
            .acr(acr?.applyValue({ args0 -> args0 }))
            .actiontrail(actiontrail?.applyValue({ args0 -> args0 }))
            .adb(adb?.applyValue({ args0 -> args0 }))
            .alb(alb?.applyValue({ args0 -> args0 }))
            .alidfs(alidfs?.applyValue({ args0 -> args0 }))
            .alidns(alidns?.applyValue({ args0 -> args0 }))
            .alikafka(alikafka?.applyValue({ args0 -> args0 }))
            .apigateway(apigateway?.applyValue({ args0 -> args0 }))
            .arms(arms?.applyValue({ args0 -> args0 }))
            .bastionhost(bastionhost?.applyValue({ args0 -> args0 }))
            .beebot(beebot?.applyValue({ args0 -> args0 }))
            .bpstudio(bpstudio?.applyValue({ args0 -> args0 }))
            .brainIndustrial(brainIndustrial?.applyValue({ args0 -> args0 }))
            .bssopenapi(bssopenapi?.applyValue({ args0 -> args0 }))
            .cas(cas?.applyValue({ args0 -> args0 }))
            .cassandra(cassandra?.applyValue({ args0 -> args0 }))
            .cbn(cbn?.applyValue({ args0 -> args0 }))
            .cbs(cbs?.applyValue({ args0 -> args0 }))
            .cddc(cddc?.applyValue({ args0 -> args0 }))
            .cdn(cdn?.applyValue({ args0 -> args0 }))
            .cds(cds?.applyValue({ args0 -> args0 }))
            .clickhouse(clickhouse?.applyValue({ args0 -> args0 }))
            .cloudauth(cloudauth?.applyValue({ args0 -> args0 }))
            .cloudfirewall(cloudfirewall?.applyValue({ args0 -> args0 }))
            .cloudfw(cloudfw?.applyValue({ args0 -> args0 }))
            .cloudphone(cloudphone?.applyValue({ args0 -> args0 }))
            .cloudsso(cloudsso?.applyValue({ args0 -> args0 }))
            .cms(cms?.applyValue({ args0 -> args0 }))
            .computenest(computenest?.applyValue({ args0 -> args0 }))
            .config(config?.applyValue({ args0 -> args0 }))
            .cr(cr?.applyValue({ args0 -> args0 }))
            .cs(cs?.applyValue({ args0 -> args0 }))
            .das(das?.applyValue({ args0 -> args0 }))
            .datahub(datahub?.applyValue({ args0 -> args0 }))
            .dataworkspublic(dataworkspublic?.applyValue({ args0 -> args0 }))
            .dbfs(dbfs?.applyValue({ args0 -> args0 }))
            .dcdn(dcdn?.applyValue({ args0 -> args0 }))
            .ddosbasic(ddosbasic?.applyValue({ args0 -> args0 }))
            .ddosbgp(ddosbgp?.applyValue({ args0 -> args0 }))
            .ddoscoo(ddoscoo?.applyValue({ args0 -> args0 }))
            .dds(dds?.applyValue({ args0 -> args0 }))
            .devopsrdc(devopsrdc?.applyValue({ args0 -> args0 }))
            .dg(dg?.applyValue({ args0 -> args0 }))
            .dm(dm?.applyValue({ args0 -> args0 }))
            .dmsEnterprise(dmsEnterprise?.applyValue({ args0 -> args0 }))
            .dmsenterprise(dmsenterprise?.applyValue({ args0 -> args0 }))
            .dns(dns?.applyValue({ args0 -> args0 }))
            .drds(drds?.applyValue({ args0 -> args0 }))
            .dts(dts?.applyValue({ args0 -> args0 }))
            .dysms(dysms?.applyValue({ args0 -> args0 }))
            .eais(eais?.applyValue({ args0 -> args0 }))
            .ebs(ebs?.applyValue({ args0 -> args0 }))
            .eci(eci?.applyValue({ args0 -> args0 }))
            .ecs(ecs?.applyValue({ args0 -> args0 }))
            .edas(edas?.applyValue({ args0 -> args0 }))
            .edasschedulerx(edasschedulerx?.applyValue({ args0 -> args0 }))
            .edsuser(edsuser?.applyValue({ args0 -> args0 }))
            .eflo(eflo?.applyValue({ args0 -> args0 }))
            .ehpc(ehpc?.applyValue({ args0 -> args0 }))
            .ehs(ehs?.applyValue({ args0 -> args0 }))
            .eipanycast(eipanycast?.applyValue({ args0 -> args0 }))
            .elasticsearch(elasticsearch?.applyValue({ args0 -> args0 }))
            .emr(emr?.applyValue({ args0 -> args0 }))
            .ens(ens?.applyValue({ args0 -> args0 }))
            .ess(ess?.applyValue({ args0 -> args0 }))
            .eventbridge(eventbridge?.applyValue({ args0 -> args0 }))
            .fc(fc?.applyValue({ args0 -> args0 }))
            .fnf(fnf?.applyValue({ args0 -> args0 }))
            .ga(ga?.applyValue({ args0 -> args0 }))
            .gaplus(gaplus?.applyValue({ args0 -> args0 }))
            .gds(gds?.applyValue({ args0 -> args0 }))
            .gpdb(gpdb?.applyValue({ args0 -> args0 }))
            .gwsecd(gwsecd?.applyValue({ args0 -> args0 }))
            .hbr(hbr?.applyValue({ args0 -> args0 }))
            .hcsSgw(hcsSgw?.applyValue({ args0 -> args0 }))
            .hitsdb(hitsdb?.applyValue({ args0 -> args0 }))
            .imm(imm?.applyValue({ args0 -> args0 }))
            .imp(imp?.applyValue({ args0 -> args0 }))
            .ims(ims?.applyValue({ args0 -> args0 }))
            .iot(iot?.applyValue({ args0 -> args0 }))
            .kms(kms?.applyValue({ args0 -> args0 }))
            .kvstore(kvstore?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .log(log?.applyValue({ args0 -> args0 }))
            .market(market?.applyValue({ args0 -> args0 }))
            .maxcompute(maxcompute?.applyValue({ args0 -> args0 }))
            .mhub(mhub?.applyValue({ args0 -> args0 }))
            .mns(mns?.applyValue({ args0 -> args0 }))
            .mscopensubscription(mscopensubscription?.applyValue({ args0 -> args0 }))
            .mse(mse?.applyValue({ args0 -> args0 }))
            .nas(nas?.applyValue({ args0 -> args0 }))
            .nlb(nlb?.applyValue({ args0 -> args0 }))
            .oceanbase(oceanbase?.applyValue({ args0 -> args0 }))
            .ons(ons?.applyValue({ args0 -> args0 }))
            .onsproxy(onsproxy?.applyValue({ args0 -> args0 }))
            .oos(oos?.applyValue({ args0 -> args0 }))
            .opensearch(opensearch?.applyValue({ args0 -> args0 }))
            .oss(oss?.applyValue({ args0 -> args0 }))
            .ots(ots?.applyValue({ args0 -> args0 }))
            .polardb(polardb?.applyValue({ args0 -> args0 }))
            .privatelink(privatelink?.applyValue({ args0 -> args0 }))
            .pvtz(pvtz?.applyValue({ args0 -> args0 }))
            .quickbi(quickbi?.applyValue({ args0 -> args0 }))
            .quotas(quotas?.applyValue({ args0 -> args0 }))
            .rKvstore(rKvstore?.applyValue({ args0 -> args0 }))
            .ram(ram?.applyValue({ args0 -> args0 }))
            .rds(rds?.applyValue({ args0 -> args0 }))
            .redisa(redisa?.applyValue({ args0 -> args0 }))
            .resourcemanager(resourcemanager?.applyValue({ args0 -> args0 }))
            .ressharing(ressharing?.applyValue({ args0 -> args0 }))
            .ros(ros?.applyValue({ args0 -> args0 }))
            .sas(sas?.applyValue({ args0 -> args0 }))
            .scdn(scdn?.applyValue({ args0 -> args0 }))
            .sddp(sddp?.applyValue({ args0 -> args0 }))
            .selectdb(selectdb?.applyValue({ args0 -> args0 }))
            .serverless(serverless?.applyValue({ args0 -> args0 }))
            .servicemesh(servicemesh?.applyValue({ args0 -> args0 }))
            .sgw(sgw?.applyValue({ args0 -> args0 }))
            .slb(slb?.applyValue({ args0 -> args0 }))
            .smartag(smartag?.applyValue({ args0 -> args0 }))
            .srvcatalog(srvcatalog?.applyValue({ args0 -> args0 }))
            .sts(sts?.applyValue({ args0 -> args0 }))
            .swas(swas?.applyValue({ args0 -> args0 }))
            .tag(tag?.applyValue({ args0 -> args0 }))
            .vod(vod?.applyValue({ args0 -> args0 }))
            .vpc(vpc?.applyValue({ args0 -> args0 }))
            .vpcpeer(vpcpeer?.applyValue({ args0 -> args0 }))
            .vs(vs?.applyValue({ args0 -> args0 }))
            .waf(waf?.applyValue({ args0 -> args0 }))
            .wafOpenapi(wafOpenapi?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProviderEndpointArgs].
 */
@PulumiTagMarker
public class ProviderEndpointArgsBuilder internal constructor() {
    private var acr: Output<String>? = null

    private var actiontrail: Output<String>? = null

    private var adb: Output<String>? = null

    private var alb: Output<String>? = null

    private var alidfs: Output<String>? = null

    private var alidns: Output<String>? = null

    private var alikafka: Output<String>? = null

    private var apigateway: Output<String>? = null

    private var arms: Output<String>? = null

    private var bastionhost: Output<String>? = null

    private var beebot: Output<String>? = null

    private var bpstudio: Output<String>? = null

    private var brainIndustrial: Output<String>? = null

    private var bssopenapi: Output<String>? = null

    private var cas: Output<String>? = null

    private var cassandra: Output<String>? = null

    private var cbn: Output<String>? = null

    private var cbs: Output<String>? = null

    private var cddc: Output<String>? = null

    private var cdn: Output<String>? = null

    private var cds: Output<String>? = null

    private var clickhouse: Output<String>? = null

    private var cloudauth: Output<String>? = null

    private var cloudfirewall: Output<String>? = null

    private var cloudfw: Output<String>? = null

    private var cloudphone: Output<String>? = null

    private var cloudsso: Output<String>? = null

    private var cms: Output<String>? = null

    private var computenest: Output<String>? = null

    private var config: Output<String>? = null

    private var cr: Output<String>? = null

    private var cs: Output<String>? = null

    private var das: Output<String>? = null

    private var datahub: Output<String>? = null

    private var dataworkspublic: Output<String>? = null

    private var dbfs: Output<String>? = null

    private var dcdn: Output<String>? = null

    private var ddosbasic: Output<String>? = null

    private var ddosbgp: Output<String>? = null

    private var ddoscoo: Output<String>? = null

    private var dds: Output<String>? = null

    private var devopsrdc: Output<String>? = null

    private var dg: Output<String>? = null

    private var dm: Output<String>? = null

    private var dmsEnterprise: Output<String>? = null

    private var dmsenterprise: Output<String>? = null

    private var dns: Output<String>? = null

    private var drds: Output<String>? = null

    private var dts: Output<String>? = null

    private var dysms: Output<String>? = null

    private var eais: Output<String>? = null

    private var ebs: Output<String>? = null

    private var eci: Output<String>? = null

    private var ecs: Output<String>? = null

    private var edas: Output<String>? = null

    private var edasschedulerx: Output<String>? = null

    private var edsuser: Output<String>? = null

    private var eflo: Output<String>? = null

    private var ehpc: Output<String>? = null

    private var ehs: Output<String>? = null

    private var eipanycast: Output<String>? = null

    private var elasticsearch: Output<String>? = null

    private var emr: Output<String>? = null

    private var ens: Output<String>? = null

    private var ess: Output<String>? = null

    private var eventbridge: Output<String>? = null

    private var fc: Output<String>? = null

    private var fnf: Output<String>? = null

    private var ga: Output<String>? = null

    private var gaplus: Output<String>? = null

    private var gds: Output<String>? = null

    private var gpdb: Output<String>? = null

    private var gwsecd: Output<String>? = null

    private var hbr: Output<String>? = null

    private var hcsSgw: Output<String>? = null

    private var hitsdb: Output<String>? = null

    private var imm: Output<String>? = null

    private var imp: Output<String>? = null

    private var ims: Output<String>? = null

    private var iot: Output<String>? = null

    private var kms: Output<String>? = null

    private var kvstore: Output<String>? = null

    private var location: Output<String>? = null

    private var log: Output<String>? = null

    private var market: Output<String>? = null

    private var maxcompute: Output<String>? = null

    private var mhub: Output<String>? = null

    private var mns: Output<String>? = null

    private var mscopensubscription: Output<String>? = null

    private var mse: Output<String>? = null

    private var nas: Output<String>? = null

    private var nlb: Output<String>? = null

    private var oceanbase: Output<String>? = null

    private var ons: Output<String>? = null

    private var onsproxy: Output<String>? = null

    private var oos: Output<String>? = null

    private var opensearch: Output<String>? = null

    private var oss: Output<String>? = null

    private var ots: Output<String>? = null

    private var polardb: Output<String>? = null

    private var privatelink: Output<String>? = null

    private var pvtz: Output<String>? = null

    private var quickbi: Output<String>? = null

    private var quotas: Output<String>? = null

    private var rKvstore: Output<String>? = null

    private var ram: Output<String>? = null

    private var rds: Output<String>? = null

    private var redisa: Output<String>? = null

    private var resourcemanager: Output<String>? = null

    private var ressharing: Output<String>? = null

    private var ros: Output<String>? = null

    private var sas: Output<String>? = null

    private var scdn: Output<String>? = null

    private var sddp: Output<String>? = null

    private var selectdb: Output<String>? = null

    private var serverless: Output<String>? = null

    private var servicemesh: Output<String>? = null

    private var sgw: Output<String>? = null

    private var slb: Output<String>? = null

    private var smartag: Output<String>? = null

    private var srvcatalog: Output<String>? = null

    private var sts: Output<String>? = null

    private var swas: Output<String>? = null

    private var tag: Output<String>? = null

    private var vod: Output<String>? = null

    private var vpc: Output<String>? = null

    private var vpcpeer: Output<String>? = null

    private var vs: Output<String>? = null

    private var waf: Output<String>? = null

    private var wafOpenapi: Output<String>? = null

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom acr endpoints.
     */
    @JvmName("polfjeteaxjogwvn")
    public suspend fun acr(`value`: Output<String>) {
        this.acr = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Actiontrail endpoints.
     */
    @JvmName("hueoivgtsetidkpo")
    public suspend fun actiontrail(`value`: Output<String>) {
        this.actiontrail = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom AnalyticDB endpoints.
     */
    @JvmName("fplnnqvvltuyieff")
    public suspend fun adb(`value`: Output<String>) {
        this.adb = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom alb endpoints.
     */
    @JvmName("mdalblikntpjrmvv")
    public suspend fun alb(`value`: Output<String>) {
        this.alb = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom alidfs endpoints.
     */
    @JvmName("rkrqflwnfnafmpbl")
    public suspend fun alidfs(`value`: Output<String>) {
        this.alidfs = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom alidns endpoints.
     */
    @JvmName("ueikxcfvbwvoupld")
    public suspend fun alidns(`value`: Output<String>) {
        this.alidns = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ALIKAFKA endpoints.
     */
    @JvmName("rsofrqwircliaomf")
    public suspend fun alikafka(`value`: Output<String>) {
        this.alikafka = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Api Gateway endpoints.
     */
    @JvmName("wutcpffarfkvishi")
    public suspend fun apigateway(`value`: Output<String>) {
        this.apigateway = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom arms endpoints.
     */
    @JvmName("qnitmvobaynneuty")
    public suspend fun arms(`value`: Output<String>) {
        this.arms = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom bastionhost endpoints.
     */
    @JvmName("kfntfwsowgelvjxu")
    public suspend fun bastionhost(`value`: Output<String>) {
        this.bastionhost = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom beebot endpoints.
     */
    @JvmName("bpyghcgwnpbjogvo")
    public suspend fun beebot(`value`: Output<String>) {
        this.beebot = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom bpstudio endpoints.
     */
    @JvmName("clnmshvvtsmtosbl")
    public suspend fun bpstudio(`value`: Output<String>) {
        this.bpstudio = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom brain_industrial endpoints.
     */
    @JvmName("dvdgcyowarvrfrkf")
    public suspend fun brainIndustrial(`value`: Output<String>) {
        this.brainIndustrial = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom BSSOPENAPI endpoints.
     */
    @JvmName("efmflbtpkuwokfph")
    public suspend fun bssopenapi(`value`: Output<String>) {
        this.bssopenapi = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom CAS endpoints.
     */
    @JvmName("kujimvgdelhrdbdw")
    public suspend fun cas(`value`: Output<String>) {
        this.cas = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cassandra endpoints.
     */
    @JvmName("sdwawmuinwgnpsev")
    public suspend fun cassandra(`value`: Output<String>) {
        this.cassandra = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cbn endpoints.
     */
    @JvmName("riecqrlxsmrlpodh")
    public suspend fun cbn(`value`: Output<String>) {
        this.cbn = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cbs endpoints.
     */
    @JvmName("nxwdqecewwxapkvh")
    public suspend fun cbs(`value`: Output<String>) {
        this.cbs = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cddc endpoints.
     */
    @JvmName("hmcrbgnmahneqhoo")
    public suspend fun cddc(`value`: Output<String>) {
        this.cddc = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom CDN endpoints.
     */
    @JvmName("nmbruugjsxevmuql")
    public suspend fun cdn(`value`: Output<String>) {
        this.cdn = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cds endpoints.
     */
    @JvmName("ivfeqpewejhwhyef")
    public suspend fun cds(`value`: Output<String>) {
        this.cds = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom clickhouse endpoints.
     */
    @JvmName("onskltxfimspmxuv")
    public suspend fun clickhouse(`value`: Output<String>) {
        this.clickhouse = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cloudauth endpoints.
     */
    @JvmName("klgiegkwuguvlulh")
    public suspend fun cloudauth(`value`: Output<String>) {
        this.cloudauth = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cloudfirewall endpoints.
     */
    @JvmName("fxkritupwplfwmtt")
    public suspend fun cloudfirewall(`value`: Output<String>) {
        this.cloudfirewall = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cloudfw endpoints.
     */
    @JvmName("rgivkxvdljnoeubj")
    public suspend fun cloudfw(`value`: Output<String>) {
        this.cloudfw = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cloudphone endpoints.
     */
    @JvmName("aedogsisloylchjc")
    public suspend fun cloudphone(`value`: Output<String>) {
        this.cloudphone = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cloudsso endpoints.
     */
    @JvmName("nqtkgrmytirrakaa")
    public suspend fun cloudsso(`value`: Output<String>) {
        this.cloudsso = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Cloud Monitor endpoints.
     */
    @JvmName("ohxpfoqajrgmtefm")
    public suspend fun cms(`value`: Output<String>) {
        this.cms = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom computenest endpoints.
     */
    @JvmName("oifwedwkwhygdxwj")
    public suspend fun computenest(`value`: Output<String>) {
        this.computenest = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom config endpoints.
     */
    @JvmName("tbhuhnriyjshjjbw")
    public suspend fun config(`value`: Output<String>) {
        this.config = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Container Registry endpoints.
     */
    @JvmName("cecdiqokoqngvhaj")
    public suspend fun cr(`value`: Output<String>) {
        this.cr = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Container Service endpoints.
     */
    @JvmName("cubgogmgqoshhmja")
    public suspend fun cs(`value`: Output<String>) {
        this.cs = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom das endpoints.
     */
    @JvmName("bownyoorxtwaoggn")
    public suspend fun das(`value`: Output<String>) {
        this.das = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Datahub endpoints.
     */
    @JvmName("quqcokawvdxufiki")
    public suspend fun datahub(`value`: Output<String>) {
        this.datahub = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dataworkspublic endpoints.
     */
    @JvmName("qtomxfexkstshato")
    public suspend fun dataworkspublic(`value`: Output<String>) {
        this.dataworkspublic = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dbfs endpoints.
     */
    @JvmName("iiwabejknlelyoal")
    public suspend fun dbfs(`value`: Output<String>) {
        this.dbfs = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dcdn endpoints.
     */
    @JvmName("rwsavxmsmukcbmny")
    public suspend fun dcdn(`value`: Output<String>) {
        this.dcdn = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ddosbasic endpoints.
     */
    @JvmName("kjqewmculpxxginb")
    public suspend fun ddosbasic(`value`: Output<String>) {
        this.ddosbasic = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom DDOSBGP endpoints.
     */
    @JvmName("ihsbrgpwuctgmlyj")
    public suspend fun ddosbgp(`value`: Output<String>) {
        this.ddosbgp = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom DDOSCOO endpoints.
     */
    @JvmName("koykvkheaurbyuea")
    public suspend fun ddoscoo(`value`: Output<String>) {
        this.ddoscoo = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom MongoDB endpoints.
     */
    @JvmName("kvxwjblwvcmhxkfj")
    public suspend fun dds(`value`: Output<String>) {
        this.dds = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom devopsrdc endpoints.
     */
    @JvmName("pxottbfqqyhgpikl")
    public suspend fun devopsrdc(`value`: Output<String>) {
        this.devopsrdc = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dg endpoints.
     */
    @JvmName("ammexauwfqfrowgf")
    public suspend fun dg(`value`: Output<String>) {
        this.dg = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dm endpoints.
     */
    @JvmName("jowfwjcbjofjmmqb")
    public suspend fun dm(`value`: Output<String>) {
        this.dm = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dms_enterprise endpoints.
     */
    @JvmName("mvniahaxpgnvdiwv")
    public suspend fun dmsEnterprise(`value`: Output<String>) {
        this.dmsEnterprise = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dmsenterprise endpoints.
     */
    @JvmName("djckgfxjcwtoeuyi")
    public suspend fun dmsenterprise(`value`: Output<String>) {
        this.dmsenterprise = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom DNS endpoints.
     */
    @JvmName("pxiblffsipyqqoch")
    public suspend fun dns(`value`: Output<String>) {
        this.dns = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom DRDS endpoints.
     */
    @JvmName("uwdyypdrlwuxtyxa")
    public suspend fun drds(`value`: Output<String>) {
        this.drds = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dts endpoints.
     */
    @JvmName("nkigjchxbgleipsb")
    public suspend fun dts(`value`: Output<String>) {
        this.dts = value
    }

    /**
     * @param value
     */
    @JvmName("jcbpxdkcuuahollp")
    public suspend fun dysms(`value`: Output<String>) {
        this.dysms = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom eais endpoints.
     */
    @JvmName("goewyxnwbqnkjvvw")
    public suspend fun eais(`value`: Output<String>) {
        this.eais = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ebs endpoints.
     */
    @JvmName("vnncikavjtnuoqbr")
    public suspend fun ebs(`value`: Output<String>) {
        this.ebs = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom eci endpoints.
     */
    @JvmName("ptqndrhemwohdynp")
    public suspend fun eci(`value`: Output<String>) {
        this.eci = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ECS endpoints.
     */
    @JvmName("yursjlalearfpoxv")
    public suspend fun ecs(`value`: Output<String>) {
        this.ecs = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom edas endpoints.
     */
    @JvmName("vlpijcgvixljtges")
    public suspend fun edas(`value`: Output<String>) {
        this.edas = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom edasschedulerx endpoints.
     */
    @JvmName("lsiochgkhugoqyjx")
    public suspend fun edasschedulerx(`value`: Output<String>) {
        this.edasschedulerx = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom edsuser endpoints.
     */
    @JvmName("ygnrkkukfyoggewk")
    public suspend fun edsuser(`value`: Output<String>) {
        this.edsuser = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom eflo endpoints.
     */
    @JvmName("chdjqewkoigarveh")
    public suspend fun eflo(`value`: Output<String>) {
        this.eflo = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ehpc endpoints.
     */
    @JvmName("ppxakmolnuqlegso")
    public suspend fun ehpc(`value`: Output<String>) {
        this.ehpc = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ehs endpoints.
     */
    @JvmName("xfujroopbrlxtnnd")
    public suspend fun ehs(`value`: Output<String>) {
        this.ehs = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom eipanycast endpoints.
     */
    @JvmName("cvfvcufofmnluxvj")
    public suspend fun eipanycast(`value`: Output<String>) {
        this.eipanycast = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Elasticsearch endpoints.
     */
    @JvmName("bhunythfyhmhtlqm")
    public suspend fun elasticsearch(`value`: Output<String>) {
        this.elasticsearch = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom EMR endpoints.
     */
    @JvmName("vwtkxyspspqrqxpr")
    public suspend fun emr(`value`: Output<String>) {
        this.emr = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ens endpoints.
     */
    @JvmName("ilycugjtedslcrtv")
    public suspend fun ens(`value`: Output<String>) {
        this.ens = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Autoscaling endpoints.
     */
    @JvmName("cuepfpwybbetpxtl")
    public suspend fun ess(`value`: Output<String>) {
        this.ess = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom eventbridge_share endpoints.
     */
    @JvmName("rtlsdelobppsxbko")
    public suspend fun eventbridge(`value`: Output<String>) {
        this.eventbridge = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Function Computing endpoints.
     */
    @JvmName("ikxoxamyckumlhjr")
    public suspend fun fc(`value`: Output<String>) {
        this.fc = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom fnf endpoints.
     */
    @JvmName("uiggixqmvwnyveka")
    public suspend fun fnf(`value`: Output<String>) {
        this.fnf = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ga endpoints.
     */
    @JvmName("qaqspdxudvowecyv")
    public suspend fun ga(`value`: Output<String>) {
        this.ga = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom gaplus endpoints.
     */
    @JvmName("nhnkvmltqbadychs")
    public suspend fun gaplus(`value`: Output<String>) {
        this.gaplus = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom gds endpoints.
     */
    @JvmName("ghmgbrkqnvvxetwa")
    public suspend fun gds(`value`: Output<String>) {
        this.gds = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom GPDB endpoints.
     */
    @JvmName("iwquvnonhjhmqnya")
    public suspend fun gpdb(`value`: Output<String>) {
        this.gpdb = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom gwsecd endpoints.
     */
    @JvmName("heobatnscaflgqes")
    public suspend fun gwsecd(`value`: Output<String>) {
        this.gwsecd = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom hbr endpoints.
     */
    @JvmName("hliwckegkbvvhngf")
    public suspend fun hbr(`value`: Output<String>) {
        this.hbr = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom hcs_sgw endpoints.
     */
    @JvmName("jtyvkaytpmtdjasg")
    public suspend fun hcsSgw(`value`: Output<String>) {
        this.hcsSgw = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom hitsdb endpoints.
     */
    @JvmName("xvtsjumnqahetknt")
    public suspend fun hitsdb(`value`: Output<String>) {
        this.hitsdb = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom imm endpoints.
     */
    @JvmName("tvauvnsbhmmpbbmg")
    public suspend fun imm(`value`: Output<String>) {
        this.imm = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom imp endpoints.
     */
    @JvmName("qiricehsayquvrob")
    public suspend fun imp(`value`: Output<String>) {
        this.imp = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ims endpoints.
     */
    @JvmName("egaxppmqbgkkcxrq")
    public suspend fun ims(`value`: Output<String>) {
        this.ims = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom iot endpoints.
     */
    @JvmName("idthbunsmjlkxpow")
    public suspend fun iot(`value`: Output<String>) {
        this.iot = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom KMS endpoints.
     */
    @JvmName("drlhxthtdhewyvtc")
    public suspend fun kms(`value`: Output<String>) {
        this.kms = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom R-KVStore endpoints.
     */
    @JvmName("dwgslobkydaduedp")
    public suspend fun kvstore(`value`: Output<String>) {
        this.kvstore = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Location Service endpoints.
     */
    @JvmName("rcfnuibheoboecir")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Log Service endpoints.
     */
    @JvmName("yjmoqmaptsdnyokp")
    public suspend fun log(`value`: Output<String>) {
        this.log = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Market Place endpoints.
     */
    @JvmName("jxlesyiyfyreqbxk")
    public suspend fun market(`value`: Output<String>) {
        this.market = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom MaxCompute endpoints.
     */
    @JvmName("ndlakugfvpbciqqi")
    public suspend fun maxcompute(`value`: Output<String>) {
        this.maxcompute = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom mhub endpoints.
     */
    @JvmName("grqwotngjtaxshnv")
    public suspend fun mhub(`value`: Output<String>) {
        this.mhub = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom MNS endpoints.
     */
    @JvmName("kalvivkxpfaboadh")
    public suspend fun mns(`value`: Output<String>) {
        this.mns = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom mscopensubscription endpoints.
     */
    @JvmName("bftsqwifcadxbuve")
    public suspend fun mscopensubscription(`value`: Output<String>) {
        this.mscopensubscription = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom mse endpoints.
     */
    @JvmName("bgobmswxnjwvrmpp")
    public suspend fun mse(`value`: Output<String>) {
        this.mse = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom NAS endpoints.
     */
    @JvmName("ekbljvmspbhukaie")
    public suspend fun nas(`value`: Output<String>) {
        this.nas = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom nlb endpoints.
     */
    @JvmName("ytyipdeorbxyoftm")
    public suspend fun nlb(`value`: Output<String>) {
        this.nlb = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom oceanbase endpoints.
     */
    @JvmName("nykkqkmdfkscwkuv")
    public suspend fun oceanbase(`value`: Output<String>) {
        this.oceanbase = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ONS endpoints.
     */
    @JvmName("ineuwcredrjovehk")
    public suspend fun ons(`value`: Output<String>) {
        this.ons = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom onsproxy endpoints.
     */
    @JvmName("dhicnqoojslgbgia")
    public suspend fun onsproxy(`value`: Output<String>) {
        this.onsproxy = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom oos endpoints.
     */
    @JvmName("oxdtkkqlhxhbrxog")
    public suspend fun oos(`value`: Output<String>) {
        this.oos = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom opensearch endpoints.
     */
    @JvmName("awpiwnkenvwwjqbw")
    public suspend fun opensearch(`value`: Output<String>) {
        this.opensearch = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom OSS endpoints.
     */
    @JvmName("xqyssvhsxiilhbxw")
    public suspend fun oss(`value`: Output<String>) {
        this.oss = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Table Store endpoints.
     */
    @JvmName("wqpfwvemsrnoxbpu")
    public suspend fun ots(`value`: Output<String>) {
        this.ots = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom PolarDB endpoints.
     */
    @JvmName("letmxihssxaserxp")
    public suspend fun polardb(`value`: Output<String>) {
        this.polardb = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom privatelink endpoints.
     */
    @JvmName("tjmkhydjfxxcyoiw")
    public suspend fun privatelink(`value`: Output<String>) {
        this.privatelink = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Private Zone endpoints.
     */
    @JvmName("kneiasyuxkyeaxak")
    public suspend fun pvtz(`value`: Output<String>) {
        this.pvtz = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom quickbi endpoints.
     */
    @JvmName("wjpfnqxjxadhrobn")
    public suspend fun quickbi(`value`: Output<String>) {
        this.quickbi = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom quotas endpoints.
     */
    @JvmName("bhhwxcxssmrsgdwb")
    public suspend fun quotas(`value`: Output<String>) {
        this.quotas = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom r_kvstore endpoints.
     */
    @JvmName("lujsvooaqsurwxvr")
    public suspend fun rKvstore(`value`: Output<String>) {
        this.rKvstore = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom RAM endpoints.
     */
    @JvmName("yvpcnwviqpbysldd")
    public suspend fun ram(`value`: Output<String>) {
        this.ram = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom RDS endpoints.
     */
    @JvmName("vsfstbjuuhmokqvr")
    public suspend fun rds(`value`: Output<String>) {
        this.rds = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom redisa endpoints.
     */
    @JvmName("dxtrtsunpgjbnpkv")
    public suspend fun redisa(`value`: Output<String>) {
        this.redisa = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom resourcemanager endpoints.
     */
    @JvmName("guyvjuukfqtwovto")
    public suspend fun resourcemanager(`value`: Output<String>) {
        this.resourcemanager = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom resourcesharing endpoints.
     */
    @JvmName("kpsndtcucutvcfvf")
    public suspend fun ressharing(`value`: Output<String>) {
        this.ressharing = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ros endpoints.
     */
    @JvmName("ncimmjmlkxqcehsd")
    public suspend fun ros(`value`: Output<String>) {
        this.ros = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom sas endpoints.
     */
    @JvmName("yfwwikbniaeyjisy")
    public suspend fun sas(`value`: Output<String>) {
        this.sas = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom scdn endpoints.
     */
    @JvmName("kofhfercipsiamay")
    public suspend fun scdn(`value`: Output<String>) {
        this.scdn = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom sddp endpoints.
     */
    @JvmName("syahaumspncyavxu")
    public suspend fun sddp(`value`: Output<String>) {
        this.sddp = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom selectdb endpoints.
     */
    @JvmName("vhelkqrdstrktpop")
    public suspend fun selectdb(`value`: Output<String>) {
        this.selectdb = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom serverless endpoints.
     */
    @JvmName("lrpqgodgidqbhrob")
    public suspend fun serverless(`value`: Output<String>) {
        this.serverless = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom servicemesh endpoints.
     */
    @JvmName("phgvpftfjggigxab")
    public suspend fun servicemesh(`value`: Output<String>) {
        this.servicemesh = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom sgw endpoints.
     */
    @JvmName("xgundnyydyclmmhh")
    public suspend fun sgw(`value`: Output<String>) {
        this.sgw = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom SLB endpoints.
     */
    @JvmName("usoodghkdgihpxja")
    public suspend fun slb(`value`: Output<String>) {
        this.slb = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom smartag endpoints.
     */
    @JvmName("slgchoqilhmrpisa")
    public suspend fun smartag(`value`: Output<String>) {
        this.smartag = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom srvcatalog endpoints.
     */
    @JvmName("agerqrburimyirxu")
    public suspend fun srvcatalog(`value`: Output<String>) {
        this.srvcatalog = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom STS endpoints.
     */
    @JvmName("vltwaturhygeoytt")
    public suspend fun sts(`value`: Output<String>) {
        this.sts = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom swas endpoints.
     */
    @JvmName("ykpfsfimunvofufe")
    public suspend fun swas(`value`: Output<String>) {
        this.swas = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom tag endpoints.
     */
    @JvmName("tfkwvtyhacrsyvgc")
    public suspend fun tag(`value`: Output<String>) {
        this.tag = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom vod endpoints.
     */
    @JvmName("nbestasdmepfeffe")
    public suspend fun vod(`value`: Output<String>) {
        this.vod = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom VPC and VPN endpoints.
     */
    @JvmName("mmnpojqnsnvjepdm")
    public suspend fun vpc(`value`: Output<String>) {
        this.vpc = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom vpcpeer endpoints.
     */
    @JvmName("uqjgnraryooklxst")
    public suspend fun vpcpeer(`value`: Output<String>) {
        this.vpcpeer = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom vs endpoints.
     */
    @JvmName("qkmqnairxifswfnp")
    public suspend fun vs(`value`: Output<String>) {
        this.vs = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom waf endpoints.
     */
    @JvmName("dmlsvyitkpmijsnm")
    public suspend fun waf(`value`: Output<String>) {
        this.waf = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom waf_openapi endpoints.
     */
    @JvmName("sryfupnsqraoddop")
    public suspend fun wafOpenapi(`value`: Output<String>) {
        this.wafOpenapi = value
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom acr endpoints.
     */
    @JvmName("blohaueprlilxvsa")
    public suspend fun acr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acr = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Actiontrail endpoints.
     */
    @JvmName("awhrhfdaxtonkfrr")
    public suspend fun actiontrail(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actiontrail = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom AnalyticDB endpoints.
     */
    @JvmName("nvcinquaugvnnxcs")
    public suspend fun adb(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adb = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom alb endpoints.
     */
    @JvmName("yjevjpnfhksjrngx")
    public suspend fun alb(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alb = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom alidfs endpoints.
     */
    @JvmName("uspsixeelwfqebkf")
    public suspend fun alidfs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alidfs = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom alidns endpoints.
     */
    @JvmName("gwnckrmiahispufu")
    public suspend fun alidns(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alidns = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ALIKAFKA endpoints.
     */
    @JvmName("qptvuyrupytoqayk")
    public suspend fun alikafka(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alikafka = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Api Gateway endpoints.
     */
    @JvmName("hjyrkicyxtchamsn")
    public suspend fun apigateway(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apigateway = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom arms endpoints.
     */
    @JvmName("vcklqatprunimkef")
    public suspend fun arms(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arms = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom bastionhost endpoints.
     */
    @JvmName("ihpqosegcdktknsg")
    public suspend fun bastionhost(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bastionhost = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom beebot endpoints.
     */
    @JvmName("mtfhrpumjotijhlm")
    public suspend fun beebot(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.beebot = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom bpstudio endpoints.
     */
    @JvmName("ihkcvcnapboprtuv")
    public suspend fun bpstudio(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bpstudio = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom brain_industrial endpoints.
     */
    @JvmName("cpqjmuwpjbsrgfki")
    public suspend fun brainIndustrial(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.brainIndustrial = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom BSSOPENAPI endpoints.
     */
    @JvmName("xcpbfgksnobwdlyx")
    public suspend fun bssopenapi(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bssopenapi = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom CAS endpoints.
     */
    @JvmName("wxdmuuyoeuepmrcr")
    public suspend fun cas(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cas = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cassandra endpoints.
     */
    @JvmName("xcnexmlrdqbdyoxg")
    public suspend fun cassandra(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cassandra = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cbn endpoints.
     */
    @JvmName("sobjehlgoruhngog")
    public suspend fun cbn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cbn = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cbs endpoints.
     */
    @JvmName("irniftwtggquchyq")
    public suspend fun cbs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cbs = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cddc endpoints.
     */
    @JvmName("flenqnksxesgqrqq")
    public suspend fun cddc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cddc = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom CDN endpoints.
     */
    @JvmName("unrqvqbgjgwiqtwi")
    public suspend fun cdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cdn = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cds endpoints.
     */
    @JvmName("hbynpuunybrecaoa")
    public suspend fun cds(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cds = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom clickhouse endpoints.
     */
    @JvmName("xiowltiwrlhmiith")
    public suspend fun clickhouse(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clickhouse = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cloudauth endpoints.
     */
    @JvmName("njkhovdlrlhevklx")
    public suspend fun cloudauth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudauth = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cloudfirewall endpoints.
     */
    @JvmName("xgaavauhatfnjags")
    public suspend fun cloudfirewall(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudfirewall = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cloudfw endpoints.
     */
    @JvmName("mipusqwpqmbrvniu")
    public suspend fun cloudfw(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudfw = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cloudphone endpoints.
     */
    @JvmName("acnlpkdrufpuvigs")
    public suspend fun cloudphone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudphone = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom cloudsso endpoints.
     */
    @JvmName("abknuffryedonlgp")
    public suspend fun cloudsso(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudsso = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Cloud Monitor endpoints.
     */
    @JvmName("rwjctedhviwcoekj")
    public suspend fun cms(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cms = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom computenest endpoints.
     */
    @JvmName("bgvilhaoxrtbxpss")
    public suspend fun computenest(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computenest = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom config endpoints.
     */
    @JvmName("qlglfypudohsvbeh")
    public suspend fun config(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.config = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Container Registry endpoints.
     */
    @JvmName("iugpfuwtrcndkurp")
    public suspend fun cr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cr = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Container Service endpoints.
     */
    @JvmName("jxorypcgmtbykcdo")
    public suspend fun cs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cs = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom das endpoints.
     */
    @JvmName("dgdkyuqoihwfypxm")
    public suspend fun das(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.das = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Datahub endpoints.
     */
    @JvmName("tomrifhdcbwrrwcm")
    public suspend fun datahub(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datahub = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dataworkspublic endpoints.
     */
    @JvmName("mdawdjyuyygtrrmj")
    public suspend fun dataworkspublic(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataworkspublic = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dbfs endpoints.
     */
    @JvmName("cxfqnpuwxnfmuhwe")
    public suspend fun dbfs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbfs = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dcdn endpoints.
     */
    @JvmName("jangcwylykaflwfg")
    public suspend fun dcdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dcdn = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ddosbasic endpoints.
     */
    @JvmName("tuhmempvcenxllif")
    public suspend fun ddosbasic(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ddosbasic = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom DDOSBGP endpoints.
     */
    @JvmName("chtydguogikqwqhd")
    public suspend fun ddosbgp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ddosbgp = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom DDOSCOO endpoints.
     */
    @JvmName("aqomepgyqguipfbm")
    public suspend fun ddoscoo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ddoscoo = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom MongoDB endpoints.
     */
    @JvmName("qpmjnnsxiehmkkne")
    public suspend fun dds(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dds = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom devopsrdc endpoints.
     */
    @JvmName("sjoiwvgsxnbptysw")
    public suspend fun devopsrdc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.devopsrdc = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dg endpoints.
     */
    @JvmName("jmthakgwevyyblwr")
    public suspend fun dg(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dg = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dm endpoints.
     */
    @JvmName("nkjchofvmwdimvij")
    public suspend fun dm(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dm = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dms_enterprise endpoints.
     */
    @JvmName("eufnroifntbwfeil")
    public suspend fun dmsEnterprise(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dmsEnterprise = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dmsenterprise endpoints.
     */
    @JvmName("agouvfpxiikpvkyy")
    public suspend fun dmsenterprise(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dmsenterprise = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom DNS endpoints.
     */
    @JvmName("ofdalhhhxbgytymf")
    public suspend fun dns(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dns = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom DRDS endpoints.
     */
    @JvmName("lxjdhwnilhiygugv")
    public suspend fun drds(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.drds = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom dts endpoints.
     */
    @JvmName("rjjafysgreivnbsw")
    public suspend fun dts(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dts = mapped
    }

    /**
     * @param value
     */
    @JvmName("twwrpeehjcyswnqh")
    public suspend fun dysms(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dysms = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom eais endpoints.
     */
    @JvmName("pjckmqvckenjufbv")
    public suspend fun eais(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eais = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ebs endpoints.
     */
    @JvmName("dfgfclhdvhleygro")
    public suspend fun ebs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebs = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom eci endpoints.
     */
    @JvmName("wfjrnxoiwnxtqepc")
    public suspend fun eci(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eci = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ECS endpoints.
     */
    @JvmName("mqsyqwojtsmwsstr")
    public suspend fun ecs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecs = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom edas endpoints.
     */
    @JvmName("fngucjvqlvkuvuvn")
    public suspend fun edas(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.edas = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom edasschedulerx endpoints.
     */
    @JvmName("skeuigyglaacmmfj")
    public suspend fun edasschedulerx(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.edasschedulerx = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom edsuser endpoints.
     */
    @JvmName("ppvpohigjpddrqus")
    public suspend fun edsuser(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.edsuser = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom eflo endpoints.
     */
    @JvmName("nxmjuytpwagpnxpw")
    public suspend fun eflo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eflo = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ehpc endpoints.
     */
    @JvmName("vcwtvsspcejydblc")
    public suspend fun ehpc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ehpc = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ehs endpoints.
     */
    @JvmName("ifwggxfftaltvckd")
    public suspend fun ehs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ehs = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom eipanycast endpoints.
     */
    @JvmName("wspphmkchbimouys")
    public suspend fun eipanycast(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eipanycast = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Elasticsearch endpoints.
     */
    @JvmName("nedqmhsfsxntcwik")
    public suspend fun elasticsearch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticsearch = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom EMR endpoints.
     */
    @JvmName("qdkymfjncfhpupbd")
    public suspend fun emr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emr = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ens endpoints.
     */
    @JvmName("gngjpfhsbebtguta")
    public suspend fun ens(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ens = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Autoscaling endpoints.
     */
    @JvmName("pbthfmisnlqsxxca")
    public suspend fun ess(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ess = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom eventbridge_share endpoints.
     */
    @JvmName("eooeynqttobuhpou")
    public suspend fun eventbridge(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventbridge = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Function Computing endpoints.
     */
    @JvmName("yekfdgsvyymuhqfj")
    public suspend fun fc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fc = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom fnf endpoints.
     */
    @JvmName("xxmifrtmwcrhhqqv")
    public suspend fun fnf(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fnf = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ga endpoints.
     */
    @JvmName("fowocigcjfkjyhyu")
    public suspend fun ga(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ga = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom gaplus endpoints.
     */
    @JvmName("tdosyfbbteoyeqnt")
    public suspend fun gaplus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gaplus = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom gds endpoints.
     */
    @JvmName("egdovqcfapqvfyhi")
    public suspend fun gds(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gds = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom GPDB endpoints.
     */
    @JvmName("cswwokqogfasgljg")
    public suspend fun gpdb(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gpdb = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom gwsecd endpoints.
     */
    @JvmName("nhvpcasrgesxldve")
    public suspend fun gwsecd(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gwsecd = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom hbr endpoints.
     */
    @JvmName("ebvnmnhkmoixqdhq")
    public suspend fun hbr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hbr = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom hcs_sgw endpoints.
     */
    @JvmName("oimyjxrfganwpspx")
    public suspend fun hcsSgw(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hcsSgw = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom hitsdb endpoints.
     */
    @JvmName("sxyrcnwjpbtkiavq")
    public suspend fun hitsdb(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hitsdb = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom imm endpoints.
     */
    @JvmName("pwluxdirnywnhrpl")
    public suspend fun imm(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imm = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom imp endpoints.
     */
    @JvmName("qnldnwxbhcrqhwdw")
    public suspend fun imp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imp = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ims endpoints.
     */
    @JvmName("ugccejlseaguttly")
    public suspend fun ims(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ims = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom iot endpoints.
     */
    @JvmName("enmujbaftlaxegqt")
    public suspend fun iot(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iot = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom KMS endpoints.
     */
    @JvmName("nkyybxkvxoxctbsx")
    public suspend fun kms(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kms = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom R-KVStore endpoints.
     */
    @JvmName("hparuuejssrfyoxn")
    public suspend fun kvstore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kvstore = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Location Service endpoints.
     */
    @JvmName("prmywinvsxlnmlws")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Log Service endpoints.
     */
    @JvmName("imdlmvxtjhperidw")
    public suspend fun log(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.log = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Market Place endpoints.
     */
    @JvmName("vxitpjymrlygnfrv")
    public suspend fun market(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.market = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom MaxCompute endpoints.
     */
    @JvmName("nrifascvlfpbwmtv")
    public suspend fun maxcompute(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxcompute = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom mhub endpoints.
     */
    @JvmName("uieydbfiapswwwkf")
    public suspend fun mhub(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mhub = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom MNS endpoints.
     */
    @JvmName("unywvqtshkvdhscx")
    public suspend fun mns(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mns = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom mscopensubscription endpoints.
     */
    @JvmName("jyqloargkfvtbstw")
    public suspend fun mscopensubscription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mscopensubscription = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom mse endpoints.
     */
    @JvmName("cetomgnesrtyoygd")
    public suspend fun mse(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mse = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom NAS endpoints.
     */
    @JvmName("jvqskxaqhuuvtrbn")
    public suspend fun nas(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nas = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom nlb endpoints.
     */
    @JvmName("fxiykadujtdkqxcc")
    public suspend fun nlb(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nlb = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom oceanbase endpoints.
     */
    @JvmName("ccjdbvreeoosbwud")
    public suspend fun oceanbase(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oceanbase = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ONS endpoints.
     */
    @JvmName("lpmhmhnodggsplis")
    public suspend fun ons(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ons = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom onsproxy endpoints.
     */
    @JvmName("nvoukpakbemwqiqi")
    public suspend fun onsproxy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onsproxy = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom oos endpoints.
     */
    @JvmName("drdtehnuftyrxihq")
    public suspend fun oos(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oos = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom opensearch endpoints.
     */
    @JvmName("asmltinweahvggsq")
    public suspend fun opensearch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.opensearch = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom OSS endpoints.
     */
    @JvmName("aunqkwvoldlflreu")
    public suspend fun oss(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oss = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Table Store endpoints.
     */
    @JvmName("sablxsmbmkvukcqh")
    public suspend fun ots(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ots = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom PolarDB endpoints.
     */
    @JvmName("myphgkdylpfajqvu")
    public suspend fun polardb(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.polardb = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom privatelink endpoints.
     */
    @JvmName("udqvhrlvqofrgloh")
    public suspend fun privatelink(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privatelink = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom Private Zone endpoints.
     */
    @JvmName("dvcqjwjftmjbbdtn")
    public suspend fun pvtz(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pvtz = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom quickbi endpoints.
     */
    @JvmName("qsbhpqjttlkkpiwi")
    public suspend fun quickbi(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quickbi = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom quotas endpoints.
     */
    @JvmName("bgcihwvxcamnsmqd")
    public suspend fun quotas(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quotas = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom r_kvstore endpoints.
     */
    @JvmName("tejpwycrbhxgwrwt")
    public suspend fun rKvstore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rKvstore = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom RAM endpoints.
     */
    @JvmName("rgnvwueooiwhmwjx")
    public suspend fun ram(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ram = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom RDS endpoints.
     */
    @JvmName("atijtmbsvrjjvbun")
    public suspend fun rds(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rds = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom redisa endpoints.
     */
    @JvmName("ysheakhmatcaajpe")
    public suspend fun redisa(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redisa = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom resourcemanager endpoints.
     */
    @JvmName("hmnxnwwcoptcmcsr")
    public suspend fun resourcemanager(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourcemanager = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom resourcesharing endpoints.
     */
    @JvmName("uwrpcswoidnsnmxl")
    public suspend fun ressharing(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ressharing = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom ros endpoints.
     */
    @JvmName("njildogjbtxahbge")
    public suspend fun ros(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ros = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom sas endpoints.
     */
    @JvmName("uymxjitmtofckoqv")
    public suspend fun sas(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sas = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom scdn endpoints.
     */
    @JvmName("cgmuatkhugmmufob")
    public suspend fun scdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scdn = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom sddp endpoints.
     */
    @JvmName("txkcwrdmcnvscucu")
    public suspend fun sddp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sddp = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom selectdb endpoints.
     */
    @JvmName("maugjqamycqnjuku")
    public suspend fun selectdb(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selectdb = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom serverless endpoints.
     */
    @JvmName("qwnpnraaoppprowr")
    public suspend fun serverless(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverless = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom servicemesh endpoints.
     */
    @JvmName("xkpgxijqasasmeor")
    public suspend fun servicemesh(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicemesh = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom sgw endpoints.
     */
    @JvmName("gecqdqkhocajitaa")
    public suspend fun sgw(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sgw = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom SLB endpoints.
     */
    @JvmName("rqpiofeaamdhwkef")
    public suspend fun slb(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slb = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom smartag endpoints.
     */
    @JvmName("lxjebpcoybinserv")
    public suspend fun smartag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smartag = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom srvcatalog endpoints.
     */
    @JvmName("whtsknquwnfmqujn")
    public suspend fun srvcatalog(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.srvcatalog = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom STS endpoints.
     */
    @JvmName("btjgilramhyhcbmu")
    public suspend fun sts(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sts = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom swas endpoints.
     */
    @JvmName("vlusymdjrivbofba")
    public suspend fun swas(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.swas = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom tag endpoints.
     */
    @JvmName("rrpochckutjgokpp")
    public suspend fun tag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tag = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom vod endpoints.
     */
    @JvmName("becmriylsuyywxiq")
    public suspend fun vod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vod = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom VPC and VPN endpoints.
     */
    @JvmName("npipcooqvgrbcfgm")
    public suspend fun vpc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpc = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom vpcpeer endpoints.
     */
    @JvmName("iniovrohkfujsllm")
    public suspend fun vpcpeer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcpeer = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom vs endpoints.
     */
    @JvmName("kyujrjefeupkkcaq")
    public suspend fun vs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vs = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom waf endpoints.
     */
    @JvmName("enhhciqmdyxlfbht")
    public suspend fun waf(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.waf = mapped
    }

    /**
     * @param value Use this to override the default endpoint URL constructed from the `region`. It's typically used to connect to custom waf_openapi endpoints.
     */
    @JvmName("llboqefoqcmmgaxl")
    public suspend fun wafOpenapi(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wafOpenapi = mapped
    }

    internal fun build(): ProviderEndpointArgs = ProviderEndpointArgs(
        acr = acr,
        actiontrail = actiontrail,
        adb = adb,
        alb = alb,
        alidfs = alidfs,
        alidns = alidns,
        alikafka = alikafka,
        apigateway = apigateway,
        arms = arms,
        bastionhost = bastionhost,
        beebot = beebot,
        bpstudio = bpstudio,
        brainIndustrial = brainIndustrial,
        bssopenapi = bssopenapi,
        cas = cas,
        cassandra = cassandra,
        cbn = cbn,
        cbs = cbs,
        cddc = cddc,
        cdn = cdn,
        cds = cds,
        clickhouse = clickhouse,
        cloudauth = cloudauth,
        cloudfirewall = cloudfirewall,
        cloudfw = cloudfw,
        cloudphone = cloudphone,
        cloudsso = cloudsso,
        cms = cms,
        computenest = computenest,
        config = config,
        cr = cr,
        cs = cs,
        das = das,
        datahub = datahub,
        dataworkspublic = dataworkspublic,
        dbfs = dbfs,
        dcdn = dcdn,
        ddosbasic = ddosbasic,
        ddosbgp = ddosbgp,
        ddoscoo = ddoscoo,
        dds = dds,
        devopsrdc = devopsrdc,
        dg = dg,
        dm = dm,
        dmsEnterprise = dmsEnterprise,
        dmsenterprise = dmsenterprise,
        dns = dns,
        drds = drds,
        dts = dts,
        dysms = dysms,
        eais = eais,
        ebs = ebs,
        eci = eci,
        ecs = ecs,
        edas = edas,
        edasschedulerx = edasschedulerx,
        edsuser = edsuser,
        eflo = eflo,
        ehpc = ehpc,
        ehs = ehs,
        eipanycast = eipanycast,
        elasticsearch = elasticsearch,
        emr = emr,
        ens = ens,
        ess = ess,
        eventbridge = eventbridge,
        fc = fc,
        fnf = fnf,
        ga = ga,
        gaplus = gaplus,
        gds = gds,
        gpdb = gpdb,
        gwsecd = gwsecd,
        hbr = hbr,
        hcsSgw = hcsSgw,
        hitsdb = hitsdb,
        imm = imm,
        imp = imp,
        ims = ims,
        iot = iot,
        kms = kms,
        kvstore = kvstore,
        location = location,
        log = log,
        market = market,
        maxcompute = maxcompute,
        mhub = mhub,
        mns = mns,
        mscopensubscription = mscopensubscription,
        mse = mse,
        nas = nas,
        nlb = nlb,
        oceanbase = oceanbase,
        ons = ons,
        onsproxy = onsproxy,
        oos = oos,
        opensearch = opensearch,
        oss = oss,
        ots = ots,
        polardb = polardb,
        privatelink = privatelink,
        pvtz = pvtz,
        quickbi = quickbi,
        quotas = quotas,
        rKvstore = rKvstore,
        ram = ram,
        rds = rds,
        redisa = redisa,
        resourcemanager = resourcemanager,
        ressharing = ressharing,
        ros = ros,
        sas = sas,
        scdn = scdn,
        sddp = sddp,
        selectdb = selectdb,
        serverless = serverless,
        servicemesh = servicemesh,
        sgw = sgw,
        slb = slb,
        smartag = smartag,
        srvcatalog = srvcatalog,
        sts = sts,
        swas = swas,
        tag = tag,
        vod = vod,
        vpc = vpc,
        vpcpeer = vpcpeer,
        vs = vs,
        waf = waf,
        wafOpenapi = wafOpenapi,
    )
}
