@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kotlin.inputs

import com.pulumi.alicloud.inputs.ProviderSignVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property oss
 * @property sls
 */
public data class ProviderSignVersionArgs(
    public val oss: Output<String>? = null,
    public val sls: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.inputs.ProviderSignVersionArgs> {
    override fun toJava(): com.pulumi.alicloud.inputs.ProviderSignVersionArgs =
        com.pulumi.alicloud.inputs.ProviderSignVersionArgs.builder()
            .oss(oss?.applyValue({ args0 -> args0 }))
            .sls(sls?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProviderSignVersionArgs].
 */
@PulumiTagMarker
public class ProviderSignVersionArgsBuilder internal constructor() {
    private var oss: Output<String>? = null

    private var sls: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("gwadphukaixrjacl")
    public suspend fun oss(`value`: Output<String>) {
        this.oss = value
    }

    /**
     * @param value
     */
    @JvmName("nvdsgatntwndutsm")
    public suspend fun sls(`value`: Output<String>) {
        this.sls = value
    }

    /**
     * @param value
     */
    @JvmName("wwsxycukelvvgwwo")
    public suspend fun oss(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oss = mapped
    }

    /**
     * @param value
     */
    @JvmName("vxuwxpbxakefugno")
    public suspend fun sls(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sls = mapped
    }

    internal fun build(): ProviderSignVersionArgs = ProviderSignVersionArgs(
        oss = oss,
        sls = sls,
    )
}
