@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getCallerIdentity.
 * @property accountId Account ID.
 * @property arn The Alibaba Cloud Resource Name (ARN) of the user making the call.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property identityType The type of the princiapal. RAMUser for users.
 */
public data class GetCallerIdentityResult(
    public val accountId: String,
    public val arn: String,
    public val id: String,
    public val identityType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.outputs.GetCallerIdentityResult): GetCallerIdentityResult = GetCallerIdentityResult(
            accountId = javaType.accountId(),
            arn = javaType.arn(),
            id = javaType.id(),
            identityType = javaType.identityType(),
        )
    }
}
