@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getFileCrc64Checksum.
 * @property checksum the file checksum of crc64.
 * @property filename
 * @property id The provider-assigned unique ID for this managed resource.
 * @property outputFile
 */
public data class GetFileCrc64ChecksumResult(
    public val checksum: String,
    public val filename: String,
    public val id: String,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.outputs.GetFileCrc64ChecksumResult): GetFileCrc64ChecksumResult = GetFileCrc64ChecksumResult(
            checksum = javaType.checksum(),
            filename = javaType.filename(),
            id = javaType.id(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
