@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountUid UID.
 * @property contactId The first ID of the resource.
 * @property contactName The User's Contact Name. **Note:** The name must be 2 to 12 characters in length, and can contain uppercase and lowercase letters.
 * @property email The User's Contact Email Address.
 * @property id The ID of the Contact.
 * @property isAccount Indicates Whether the BGP Group Is the Account Itself.
 * @property isObsolete Whether They Have Expired Or Not.
 * @property isVerifiedEmail Email Validation for.
 * @property isVerifiedMobile If the Phone Verification.
 * @property lastEmailVerificationTimeStamp Last Verification Email Transmission Time.
 * @property lastMobileVerificationTimeStamp The Pieces of Authentication SMS Sending Time.
 * @property mobile The User's Telephone.
 * @property position The User's Position. Valid values: `CEO`, `Technical Director`, `Maintenance Director`, `Project Director`,`Finance Director` and `Other`.
 */
public data class GetMscSubContactsContact(
    public val accountUid: String,
    public val contactId: String,
    public val contactName: String,
    public val email: String,
    public val id: String,
    public val isAccount: Boolean,
    public val isObsolete: Boolean,
    public val isVerifiedEmail: Boolean,
    public val isVerifiedMobile: Boolean,
    public val lastEmailVerificationTimeStamp: String,
    public val lastMobileVerificationTimeStamp: String,
    public val mobile: String,
    public val position: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.outputs.GetMscSubContactsContact): GetMscSubContactsContact = GetMscSubContactsContact(
            accountUid = javaType.accountUid(),
            contactId = javaType.contactId(),
            contactName = javaType.contactName(),
            email = javaType.email(),
            id = javaType.id(),
            isAccount = javaType.isAccount(),
            isObsolete = javaType.isObsolete(),
            isVerifiedEmail = javaType.isVerifiedEmail(),
            isVerifiedMobile = javaType.isVerifiedMobile(),
            lastEmailVerificationTimeStamp = javaType.lastEmailVerificationTimeStamp(),
            lastMobileVerificationTimeStamp = javaType.lastMobileVerificationTimeStamp(),
            mobile = javaType.mobile(),
            position = javaType.position(),
        )
    }
}
