@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getMscSubSubscriptions.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property outputFile
 * @property subscriptions
 */
public data class GetMscSubSubscriptionsResult(
    public val id: String,
    public val outputFile: String? = null,
    public val subscriptions: List<GetMscSubSubscriptionsSubscription>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.outputs.GetMscSubSubscriptionsResult): GetMscSubSubscriptionsResult = GetMscSubSubscriptionsResult(
            id = javaType.id(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            subscriptions = javaType.subscriptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.kotlin.outputs.GetMscSubSubscriptionsSubscription.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
