@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property channel The channel the Subscription.
 * @property contactIds The ids of subscribed contacts.
 * @property description The description of the Subscription.
 * @property emailStatus The status of email subscription. Valid values: `-1`, `-2`, `0`, `1`. `-1` means required, `-2` means banned; `1` means subscribed; `0` means not subscribed.
 * @property id The ID of the Subscription.
 * @property itemId The ID of the Subscription.
 * @property itemName The name of the Subscription.
 * @property pmsgStatus The status of pmsg subscription. Valid values: `-1`, `-2`, `0`, `1`. `-1` means required, `-2` means banned; `1` means subscribed; `0` means not subscribed.
 * @property smsStatus The status of sms subscription. Valid values: `-1`, `-2`, `0`, `1`. `-1` means required, `-2` means banned; `1` means subscribed; `0` means not subscribed.
 * @property ttsStatus The status of tts subscription. Valid values: `-1`, `-2`, `0`, `1`. `-1` means required, `-2` means banned; `1` means subscribed; `0` means not subscribed.
 * @property webhookIds The ids of subscribed webhooks.
 * @property webhookStatus The status of webhook subscription. Valid values: `-1`, `-2`, `0`, `1`. `-1` means required, `-2` means banned; `1` means subscribed; `0` means not subscribed.
 */
public data class GetMscSubSubscriptionsSubscription(
    public val channel: String,
    public val contactIds: List<Int>,
    public val description: String,
    public val emailStatus: Int,
    public val id: String,
    public val itemId: String,
    public val itemName: String,
    public val pmsgStatus: Int,
    public val smsStatus: Int,
    public val ttsStatus: Int,
    public val webhookIds: List<Int>,
    public val webhookStatus: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.outputs.GetMscSubSubscriptionsSubscription): GetMscSubSubscriptionsSubscription = GetMscSubSubscriptionsSubscription(
            channel = javaType.channel(),
            contactIds = javaType.contactIds().map({ args0 -> args0 }),
            description = javaType.description(),
            emailStatus = javaType.emailStatus(),
            id = javaType.id(),
            itemId = javaType.itemId(),
            itemName = javaType.itemName(),
            pmsgStatus = javaType.pmsgStatus(),
            smsStatus = javaType.smsStatus(),
            ttsStatus = javaType.ttsStatus(),
            webhookIds = javaType.webhookIds().map({ args0 -> args0 }),
            webhookStatus = javaType.webhookStatus(),
        )
    }
}
