@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getMscSubWebhooks.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property webhooks
 */
public data class GetMscSubWebhooksResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val webhooks: List<GetMscSubWebhooksWebhook>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.outputs.GetMscSubWebhooksResult): GetMscSubWebhooksResult = GetMscSubWebhooksResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            webhooks = javaType.webhooks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.kotlin.outputs.GetMscSubWebhooksWebhook.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
