@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ID of the Webhook.
 * @property serverUrl The serverUrl of the Subscription.
 * @property webhookId The first ID of the resource.
 * @property webhookName The name of the Webhook. **Note:** The name must be `2` to `12` characters in length, and can contain uppercase and lowercase letters.
 */
public data class GetMscSubWebhooksWebhook(
    public val id: String,
    public val serverUrl: String,
    public val webhookId: String,
    public val webhookName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.outputs.GetMscSubWebhooksWebhook): GetMscSubWebhooksWebhook = GetMscSubWebhooksWebhook(
            id = javaType.id(),
            serverUrl = javaType.serverUrl(),
            webhookId = javaType.webhookId(),
            webhookName = javaType.webhookName(),
        )
    }
}
