@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRegions.
 * @property current
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of region IDs.
 * @property name
 * @property outputFile
 * @property regions A list of regions. Each element contains the following attributes:
 */
public data class GetRegionsResult(
    public val current: Boolean,
    public val id: String,
    public val ids: List<String>,
    public val name: String,
    public val outputFile: String? = null,
    public val regions: List<GetRegionsRegion>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.outputs.GetRegionsResult): GetRegionsResult =
            GetRegionsResult(
                current = javaType.current(),
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                name = javaType.name(),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
                regions = javaType.regions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.kotlin.outputs.GetRegionsRegion.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
