@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getZones.
 * @property availableDiskCategory
 * @property availableInstanceType
 * @property availableResourceCreation Type of resources that can be created.
 * @property availableSlbAddressIpVersion
 * @property availableSlbAddressType
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of zone IDs.
 * @property instanceChargeType
 * @property multi
 * @property networkType
 * @property outputFile
 * @property spotStrategy
 * @property zones A list of availability zones. Each element contains the following attributes:
 */
public data class GetZonesResult(
    public val availableDiskCategory: String? = null,
    public val availableInstanceType: String? = null,
    public val availableResourceCreation: String? = null,
    public val availableSlbAddressIpVersion: String? = null,
    public val availableSlbAddressType: String? = null,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val instanceChargeType: String? = null,
    public val multi: Boolean? = null,
    public val networkType: String? = null,
    public val outputFile: String? = null,
    public val spotStrategy: String? = null,
    public val zones: List<GetZonesZone>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.outputs.GetZonesResult): GetZonesResult =
            GetZonesResult(
                availableDiskCategory = javaType.availableDiskCategory().map({ args0 -> args0 }).orElse(null),
                availableInstanceType = javaType.availableInstanceType().map({ args0 -> args0 }).orElse(null),
                availableResourceCreation = javaType.availableResourceCreation().map({ args0 ->
                    args0
                }).orElse(null),
                availableSlbAddressIpVersion = javaType.availableSlbAddressIpVersion().map({ args0 ->
                    args0
                }).orElse(null),
                availableSlbAddressType = javaType.availableSlbAddressType().map({ args0 -> args0 }).orElse(null),
                enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                instanceChargeType = javaType.instanceChargeType().map({ args0 -> args0 }).orElse(null),
                multi = javaType.multi().map({ args0 -> args0 }).orElse(null),
                networkType = javaType.networkType().map({ args0 -> args0 }).orElse(null),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
                spotStrategy = javaType.spotStrategy().map({ args0 -> args0 }).orElse(null),
                zones = javaType.zones().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.kotlin.outputs.GetZonesZone.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
