@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property availableDiskCategories Set of supported disk categories.
 * @property availableInstanceTypes Allowed instance types.
 * @property availableResourceCreations Filter the results by a specific resource type.
 * Valid values: `Instance`, `Disk`, `VSwitch`, `Rds`, `KVStore`, `FunctionCompute`, `Elasticsearch`, `Slb`.
 * > **NOTE:** From version 1.134.0, the `available_resource_creation` value "Rds" has been deprecated.
 * If you want to fetch the available zones for RDS instance, you can use datasource alicloud_db_zones
 * @property id ID of the zone.
 * @property localName Name of the zone in the local language.
 * @property multiZoneIds A list of zone ids in which the multi zone.
 * @property slbSlaveZoneIds A list of slb slave zone ids in which the slb master zone.
 */
public data class GetZonesZone(
    public val availableDiskCategories: List<String>,
    public val availableInstanceTypes: List<String>,
    public val availableResourceCreations: List<String>,
    public val id: String,
    public val localName: String,
    public val multiZoneIds: List<String>,
    public val slbSlaveZoneIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.outputs.GetZonesZone): GetZonesZone =
            GetZonesZone(
                availableDiskCategories = javaType.availableDiskCategories().map({ args0 -> args0 }),
                availableInstanceTypes = javaType.availableInstanceTypes().map({ args0 -> args0 }),
                availableResourceCreations = javaType.availableResourceCreations().map({ args0 -> args0 }),
                id = javaType.id(),
                localName = javaType.localName(),
                multiZoneIds = javaType.multiZoneIds().map({ args0 -> args0 }),
                slbSlaveZoneIds = javaType.slbSlaveZoneIds().map({ args0 -> args0 }),
            )
    }
}
