@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kvstore.kotlin

import com.pulumi.alicloud.kvstore.BackupPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * > **DEPRECATED:**  This resource  has been deprecated from version `1.104.0`. Please use resource alicloud_kvstore_instance.
 * Provides a backup policy for ApsaraDB Redis / Memcache instance resource.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "kvstorebackuppolicyvpc";
 * const default = alicloud.kvstore.getZones({});
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: name,
 * });
 * const defaultInstance = new alicloud.kvstore.Instance("default", {
 *     dbInstanceName: name,
 *     vswitchId: defaultSwitch.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     instanceClass: "redis.master.large.default",
 *     instanceType: "Redis",
 *     engineVersion: "5.0",
 *     securityIps: ["10&#46;23&#46;12&#46;24"],
 *     config: {
 *         appendonly: "yes",
 *         "lazyfree-lazy-eviction": "yes",
 *     },
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * const defaultBackupPolicy = new alicloud.kvstore.BackupPolicy("default", {
 *     instanceId: defaultInstance.id,
 *     backupPeriods: [
 *         "Tuesday",
 *         "Wednesday",
 *     ],
 *     backupTime: "10:00Z-11:00Z",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "kvstorebackuppolicyvpc"
 * default = alicloud.kvstore.get_zones()
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=name)
 * default_instance = alicloud.kvstore.Instance("default",
 *     db_instance_name=name,
 *     vswitch_id=default_switch.id,
 *     zone_id=default.zones[0].id,
 *     instance_class="redis.master.large.default",
 *     instance_type="Redis",
 *     engine_version="5.0",
 *     security_ips=["10&#46;23&#46;12&#46;24"],
 *     config={
 *         "appendonly": "yes",
 *         "lazyfree-lazy-eviction": "yes",
 *     },
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * default_backup_policy = alicloud.kvstore.BackupPolicy("default",
 *     instance_id=default_instance.id,
 *     backup_periods=[
 *         "Tuesday",
 *         "Wednesday",
 *     ],
 *     backup_time="10:00Z-11:00Z")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "kvstorebackuppolicyvpc";
 *     var @default = AliCloud.KVStore.GetZones.Invoke();
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = name,
 *     });
 *     var defaultInstance = new AliCloud.KVStore.Instance("default", new()
 *     {
 *         DbInstanceName = name,
 *         VswitchId = defaultSwitch.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         InstanceClass = "redis.master.large.default",
 *         InstanceType = "Redis",
 *         EngineVersion = "5.0",
 *         SecurityIps = new[]
 *         {
 *             "10.23.12.24",
 *         },
 *         Config =
 *         {
 *             { "appendonly", "yes" },
 *             { "lazyfree-lazy-eviction", "yes" },
 *         },
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 *     var defaultBackupPolicy = new AliCloud.KVStore.BackupPolicy("default", new()
 *     {
 *         InstanceId = defaultInstance.Id,
 *         BackupPeriods = new[]
 *         {
 *             "Tuesday",
 *             "Wednesday",
 *         },
 *         BackupTime = "10:00Z-11:00Z",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kvstore"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "kvstorebackuppolicyvpc"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := kvstore.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := kvstore.NewInstance(ctx, "default", &kvstore.InstanceArgs{
 * 			DbInstanceName: pulumi.String(name),
 * 			VswitchId:      defaultSwitch.ID(),
 * 			ZoneId:         pulumi.String(_default.Zones[0].Id),
 * 			InstanceClass:  pulumi.String("redis.master.large.default"),
 * 			InstanceType:   pulumi.String("Redis"),
 * 			EngineVersion:  pulumi.String("5.0"),
 * 			SecurityIps: pulumi.StringArray{
 * 				pulumi.String("10.23.12.24"),
 * 			},
 * 			Config: pulumi.StringMap{
 * 				"appendonly":             pulumi.String("yes"),
 * 				"lazyfree-lazy-eviction": pulumi.String("yes"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = kvstore.NewBackupPolicy(ctx, "default", &kvstore.BackupPolicyArgs{
 * 			InstanceId: defaultInstance.ID(),
 * 			BackupPeriods: pulumi.StringArray{
 * 				pulumi.String("Tuesday"),
 * 				pulumi.String("Wednesday"),
 * 			},
 * 			BackupTime: pulumi.String("10:00Z-11:00Z"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.kvstore.KvstoreFunctions;
 * import com.pulumi.alicloud.kvstore.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.kvstore.Instance;
 * import com.pulumi.alicloud.kvstore.InstanceArgs;
 * import com.pulumi.alicloud.kvstore.BackupPolicy;
 * import com.pulumi.alicloud.kvstore.BackupPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("kvstorebackuppolicyvpc");
 *         final var default = KvstoreFunctions.getZones();
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(name)
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .dbInstanceName(name)
 *             .vswitchId(defaultSwitch.id())
 *             .zoneId(default_.zones()[0].id())
 *             .instanceClass("redis.master.large.default")
 *             .instanceType("Redis")
 *             .engineVersion("5.0")
 *             .securityIps("10.23.12.24")
 *             .config(Map.ofEntries(
 *                 Map.entry("appendonly", "yes"),
 *                 Map.entry("lazyfree-lazy-eviction", "yes")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .build());
 *         var defaultBackupPolicy = new BackupPolicy("defaultBackupPolicy", BackupPolicyArgs.builder()
 *             .instanceId(defaultInstance.id())
 *             .backupPeriods(
 *                 "Tuesday",
 *                 "Wednesday")
 *             .backupTime("10:00Z-11:00Z")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: kvstorebackuppolicyvpc
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${name}
 *   defaultInstance:
 *     type: alicloud:kvstore:Instance
 *     name: default
 *     properties:
 *       dbInstanceName: ${name}
 *       vswitchId: ${defaultSwitch.id}
 *       zoneId: ${default.zones[0].id}
 *       instanceClass: redis.master.large.default
 *       instanceType: Redis
 *       engineVersion: '5.0'
 *       securityIps:
 *         - 10.23.12.24
 *       config:
 *         appendonly: yes
 *         lazyfree-lazy-eviction: yes
 *       tags:
 *         Created: TF
 *         For: example
 *   defaultBackupPolicy:
 *     type: alicloud:kvstore:BackupPolicy
 *     name: default
 *     properties:
 *       instanceId: ${defaultInstance.id}
 *       backupPeriods:
 *         - Tuesday
 *         - Wednesday
 *       backupTime: 10:00Z-11:00Z
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:kvstore:getZones
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * KVStore backup policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:kvstore/backupPolicy:BackupPolicy example r-abc12345678
 * ```
 * @property backupPeriods Backup Cycle. Allowed values: Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday
 * @property backupTime Backup time, in the format of HH:mmZ- HH:mm Z
 * @property instanceId The id of ApsaraDB for Redis or Memcache intance.
 */
public data class BackupPolicyArgs(
    public val backupPeriods: Output<List<String>>? = null,
    public val backupTime: Output<String>? = null,
    public val instanceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.kvstore.BackupPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.kvstore.BackupPolicyArgs =
        com.pulumi.alicloud.kvstore.BackupPolicyArgs.builder()
            .backupPeriods(backupPeriods?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .backupTime(backupTime?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BackupPolicyArgs].
 */
@PulumiTagMarker
public class BackupPolicyArgsBuilder internal constructor() {
    private var backupPeriods: Output<List<String>>? = null

    private var backupTime: Output<String>? = null

    private var instanceId: Output<String>? = null

    /**
     * @param value Backup Cycle. Allowed values: Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday
     */
    @JvmName("jmfwksauooqfokyw")
    public suspend fun backupPeriods(`value`: Output<List<String>>) {
        this.backupPeriods = value
    }

    @JvmName("qsfpdpqmvibnbvho")
    public suspend fun backupPeriods(vararg values: Output<String>) {
        this.backupPeriods = Output.all(values.asList())
    }

    /**
     * @param values Backup Cycle. Allowed values: Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday
     */
    @JvmName("fsbmxbphnjraroty")
    public suspend fun backupPeriods(values: List<Output<String>>) {
        this.backupPeriods = Output.all(values)
    }

    /**
     * @param value Backup time, in the format of HH:mmZ- HH:mm Z
     */
    @JvmName("rjmricpowtjjqapm")
    public suspend fun backupTime(`value`: Output<String>) {
        this.backupTime = value
    }

    /**
     * @param value The id of ApsaraDB for Redis or Memcache intance.
     */
    @JvmName("jiixwwtmkeuhvgyf")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value Backup Cycle. Allowed values: Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday
     */
    @JvmName("enbqcbwmdufldsdc")
    public suspend fun backupPeriods(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupPeriods = mapped
    }

    /**
     * @param values Backup Cycle. Allowed values: Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday
     */
    @JvmName("kcvebvyhhvryohsy")
    public suspend fun backupPeriods(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupPeriods = mapped
    }

    /**
     * @param value Backup time, in the format of HH:mmZ- HH:mm Z
     */
    @JvmName("ebnqoqxqoiaxwjtl")
    public suspend fun backupTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupTime = mapped
    }

    /**
     * @param value The id of ApsaraDB for Redis or Memcache intance.
     */
    @JvmName("towelnoyccbeokey")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    internal fun build(): BackupPolicyArgs = BackupPolicyArgs(
        backupPeriods = backupPeriods,
        backupTime = backupTime,
        instanceId = instanceId,
    )
}
