@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kvstore.kotlin

import com.pulumi.alicloud.kvstore.kotlin.outputs.InstanceParameter
import com.pulumi.alicloud.kvstore.kotlin.outputs.InstanceParameter.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource = com.pulumi.alicloud.kvstore.Instance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Instance(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * KVStore instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:kvstore/instance:Instance example r-abc12345678
 * ```
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.alicloud.kvstore.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * Whether to renewal a KVStore DBInstance automatically or not. It is valid when payment_type is `PrePaid`. Default value: `false`.
     */
    public val autoRenew: Output<Boolean>?
        get() = javaResource.autoRenew().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Auto-renewal period of an KVStore DBInstance, in the unit of the month. It is valid when payment_type is `PrePaid`. Valid values: [1~12]. Default value: `1`.
     */
    public val autoRenewPeriod: Output<Int>?
        get() = javaResource.autoRenewPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to use a coupon. Default value: `false`.
     */
    public val autoUseCoupon: Output<Boolean>?
        get() = javaResource.autoUseCoupon().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * It has been deprecated from provider version 1.101.0 and `zone_id` instead.
     */
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from version 1.101.0. Use 'zone_id' instead.
  """,
    )
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * The ID of the backup file of the source instance.
     */
    public val backupId: Output<String>?
        get() = javaResource.backupId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Backup period.
     */
    public val backupPeriods: Output<List<String>>
        get() = javaResource.backupPeriods().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Backup time, the format is HH:mmZ-HH:mmZ (UTC time).
     */
    public val backupTime: Output<String>
        get() = javaResource.backupTime().applyValue({ args0 -> args0 })

    /**
     * The bandwidth.
     */
    public val bandwidth: Output<Int>
        get() = javaResource.bandwidth().applyValue({ args0 -> args0 })

    /**
     * The ID of the event or the business information.
     */
    public val businessInfo: Output<String>?
        get() = javaResource.businessInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The storage capacity of the KVStore DBInstance. Unit: MB.
     */
    public val capacity: Output<Int>
        get() = javaResource.capacity().applyValue({ args0 -> args0 })

    /**
     * The configuration of the KVStore DBInstance. Available parameters can refer to the latest docs [Instance configurations table](https://www.alibabacloud.com/help/en/redis/user-guide/supported-parameters).
     */
    public val config: Output<Map<String, String>>
        get() = javaResource.config().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Intranet connection address of the KVStore instance.
     */
    public val connectionDomain: Output<String>
        get() = javaResource.connectionDomain().applyValue({ args0 -> args0 })

    /**
     * Indicates whether the address is a private endpoint.
     */
    @Deprecated(
        message = """
  Field 'connection_string' has been deprecated from version 1.101.0. Please use resource
      'alicloud_kvstore_connection' instead.
  """,
    )
    public val connectionString: Output<String>
        get() = javaResource.connectionString().applyValue({ args0 -> args0 })

    /**
     * It has been deprecated from provider version 1.101.0 and resource `alicloud.kvstore.Connection` instead.
     */
    @Deprecated(
        message = """
  Field 'connection_string_prefix' has been deprecated from version 1.101.0. Please use resource
      'alicloud_kvstore_connection' instead.
  """,
    )
    public val connectionStringPrefix: Output<String>?
        get() = javaResource.connectionStringPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The coupon code. **NOTE:** The default value `youhuiquan_promotion_option_id_for_blank` removed since v1.216.0, this can cause your status file to change even if it has not been modified, so please review your change plan before apply change plan.
     */
    public val couponNo: Output<String>?
        get() = javaResource.couponNo().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of KVStore DBInstance. It is a string of 2 to 256 characters.
     */
    public val dbInstanceName: Output<String>
        get() = javaResource.dbInstanceName().applyValue({ args0 -> args0 })

    /**
     * The ID of the dedicated cluster. This parameter is required when you create an ApsaraDB for Redis instance in a dedicated cluster.
     */
    public val dedicatedHostGroupId: Output<String>?
        get() = javaResource.dedicatedHostGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to precheck the request. Valid values:
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The time when the database is switched after the instance is migrated, or when the major version is upgraded, or when the instance class is upgraded. Valid values:
     * - `Immediately` (Default): The configurations are immediately changed.
     * - `MaintainTime`: The configurations are changed within the maintenance window. You can set `maintain_start_time` and `maintain_end_time` to change the maintenance window.
     */
    public val effectiveTime: Output<String>?
        get() = javaResource.effectiveTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Turn on or off incremental backup. Valid values: `1`, `0`. Default value: `0`
     */
    public val enableBackupLog: Output<Int>?
        get() = javaResource.enableBackupLog().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * It has been deprecated from provider version 1.101.0 and resource `alicloud.kvstore.Connection` instead.
     */
    @Deprecated(
        message = """
  Field 'enable_public' has been deprecated from version 1.101.0. Please use resource
      'alicloud_kvstore_connection' instead.
  """,
    )
    public val enablePublic: Output<Boolean>
        get() = javaResource.enablePublic().applyValue({ args0 -> args0 })

    /**
     * The Custom key ID, which you can get by calling DescribeEncryptionKeyList.If this parameter is not passed, the key is automatically generated by the key management service. To create a custom key, you can call the CreateKey interface of the key management service.
     */
    public val encryptionKey: Output<String>
        get() = javaResource.encryptionKey().applyValue({ args0 -> args0 })

    /**
     * The Encryption algorithm, default AES-CTR-256.Note that this parameter is only available when the TDEStatus parameter is Enabled.
     */
    public val encryptionName: Output<String>
        get() = javaResource.encryptionName().applyValue({ args0 -> args0 })

    /**
     * The expiration time of the prepaid instance.
     */
    public val endTime: Output<String>
        get() = javaResource.endTime().applyValue({ args0 -> args0 })

    /**
     * The engine version of the KVStore DBInstance. Valid values: ["2&#46;8", "4&#46;0", "5&#46;0", "6&#46;0", "7&#46;0"]. Default value: `5.0`.
     * **NOTE:** When `instance_type = Memcache`, the `engine_version` only supports "4.0".
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to forcibly change the type. Default value: `true`.
     */
    public val forceUpgrade: Output<Boolean>?
        get() = javaResource.forceUpgrade().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to create a distributed cache. Default value: `false`.
     */
    public val globalInstance: Output<Boolean>?
        get() = javaResource.globalInstance().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of distributed cache.
     */
    public val globalInstanceId: Output<String>?
        get() = javaResource.globalInstanceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * It has been deprecated from provider version 1.101.0 and `payment_type` instead.
     */
    @Deprecated(
        message = """
  Field 'instance_charge_type' has been deprecated from version 1.101.0. Use 'payment_type' instead.
  """,
    )
    public val instanceChargeType: Output<String>
        get() = javaResource.instanceChargeType().applyValue({ args0 -> args0 })

    /**
     * Type of the applied ApsaraDB for Redis instance. It can be retrieved by data source `alicloud.kvstore.getInstanceClasses`
     * or referring to help-docs [Instance type table](https://www.alibabacloud.com/help/doc-detail/26350.htm).
     */
    public val instanceClass: Output<String>?
        get() = javaResource.instanceClass().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * It has been deprecated from provider version 1.101.0 and `db_instance_name` instead.
     */
    @Deprecated(
        message = """
  Field `instance_name` has been deprecated from version 1.101.0. Use `db_instance_name` instead.
  """,
    )
    public val instanceName: Output<String>
        get() = javaResource.instanceName().applyValue({ args0 -> args0 })

    /**
     * Whether to open the release protection.
     */
    public val instanceReleaseProtection: Output<Boolean>?
        get() = javaResource.instanceReleaseProtection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The engine type of the KVStore DBInstance. Valid values: `Redis` or `Memcache`. Default value: `Redis`.
     */
    public val instanceType: Output<String>?
        get() = javaResource.instanceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to enable automatic minor version update. Valid values:
     */
    public val isAutoUpgradeOpen: Output<String>
        get() = javaResource.isAutoUpgradeOpen().applyValue({ args0 -> args0 })

    /**
     * An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored.
     */
    public val kmsEncryptedPassword: Output<String>?
        get() = javaResource.kmsEncryptedPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    public val kmsEncryptionContext: Output<Map<String, String>>?
        get() = javaResource.kmsEncryptionContext().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * The end time of the operation and maintenance time period of the KVStore DBInstance, in the format of HH:mmZ (UTC time).
     */
    public val maintainEndTime: Output<String>
        get() = javaResource.maintainEndTime().applyValue({ args0 -> args0 })

    /**
     * The start time of the operation and maintenance time period of the KVStore DBInstance, in the format of HH:mmZ (UTC time).
     */
    public val maintainStartTime: Output<String>
        get() = javaResource.maintainStartTime().applyValue({ args0 -> args0 })

    /**
     * "Field `node_type` has been deprecated from version 1.120.1". This parameter is determined by the `instance_class`.
     */
    @Deprecated(
        message = """
  Field 'node_type' has been deprecated from version 1.120.1
  """,
    )
    public val nodeType: Output<String>
        get() = javaResource.nodeType().applyValue({ args0 -> args0 })

    /**
     * Specifies a change type when you change the configuration of a subscription instance. Valid values: `UPGRADE`, `DOWNGRADE`. Default value: `UPGRADE`. `UPGRADE` means upgrades the configuration of a subscription instance. `DOWNGRADE` means downgrades the configuration of a subscription instance.
     */
    public val orderType: Output<String>?
        get() = javaResource.orderType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * It has been deprecated from provider version 1.101.0 and `config` instead. See `parameters` below.
     */
    @Deprecated(
        message = """
  Field 'parameters' has been deprecated from version 1.101.0. Use 'config' instead.
  """,
    )
    public val parameters: Output<List<InstanceParameter>>
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The password of the KVStore DBInstance. The password that is used to connect to the instance. The password must be 8 to 32 characters in length and must contain at least three of the following character types: uppercase letters, lowercase letters, special characters, and digits. Special characters include: `! @ # $ % ^ & * ( ) _ + - =`
     */
    public val password: Output<String>?
        get() = javaResource.password().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The billing method of the KVStore DBInstance. Valid values: `PrePaid`, `PostPaid`. Default value: `PostPaid`.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The duration that you will buy KVStore DBInstance (in month). It is valid when payment_type is `PrePaid`. Valid values: `[1~9]`, `12`, `24`, `36`.
     */
    public val period: Output<String>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * It has been deprecated from provider version 1.101.0 and resource `alicloud.kvstore.Connection` instead.
     */
    public val port: Output<Int>?
        get() = javaResource.port().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Private network connection port, used to modify the private network connection port.
     */
    public val privateConnectionPort: Output<String>
        get() = javaResource.privateConnectionPort().applyValue({ args0 -> args0 })

    /**
     * Private network connection prefix, used to modify the private network connection address. Only supports updating private network connections for existing instance.
     */
    public val privateConnectionPrefix: Output<String>?
        get() = javaResource.privateConnectionPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The internal IP address of the instance.
     */
    public val privateIp: Output<String>
        get() = javaResource.privateIp().applyValue({ args0 -> args0 })

    /**
     * Theoretical maximum QPS value.
     */
    public val qps: Output<Int>
        get() = javaResource.qps().applyValue({ args0 -> args0 })

    /**
     * The number of read replicas in the primary zone. Valid values: `1` to `9`.
     */
    public val readOnlyCount: Output<Int>?
        get() = javaResource.readOnlyCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of resource group which the resource belongs.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The point in time of a backup file.
     */
    public val restoreTime: Output<String>?
        get() = javaResource.restoreTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Specify the global resource descriptor ARN (Alibaba Cloud Resource Name) information of the role to be authorized, and use the related key management services after the authorization is completed, in the format: `acs:ram::$accountID:role/$roleName`.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * The ID of the secondary zone to which you want to migrate the ApsaraDB for Redis instance.
     * > **NOTE:** If you specify this parameter, the master node and replica node of the instance can be deployed in different zones and disaster recovery is implemented across zones. The instance can withstand failures in data centers.
     */
    public val secondaryZoneId: Output<String>?
        get() = javaResource.secondaryZoneId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of security groups. Separate multiple security group IDs with commas (,), such as `sg-***,sg-***,sg-***`.
     */
    public val securityGroupId: Output<String>?
        get() = javaResource.securityGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The value of this parameter is empty by default. The attribute of the whitelist group. The console does not display the whitelist group whose value of this parameter is hidden.
     */
    public val securityIpGroupAttribute: Output<String>?
        get() = javaResource.securityIpGroupAttribute().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the whitelist group.
     */
    public val securityIpGroupName: Output<String>
        get() = javaResource.securityIpGroupName().applyValue({ args0 -> args0 })

    /**
     * The IP addresses in the whitelist group. The maximum number of IP addresses in the whitelist group is 1000.
     */
    public val securityIps: Output<List<String>>
        get() = javaResource.securityIps().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The number of data shards. This parameter is available only if you create a cluster instance that uses cloud disks. You can use this parameter to specify a custom number of data shards. **NOTE:** From version 1.216.0, `shard_count` can be modified.
     */
    public val shardCount: Output<Int>
        get() = javaResource.shardCount().applyValue({ args0 -> args0 })

    /**
     * The number of read replicas in the secondary zone. **NOTE:**: When you create a multi-zone read/write splitting instance, you must specify both `secondary_zone_id` and `slave_read_only_count`.
     * > **NOTE:** The sum of `read_only_count` and `slave_read_only_count` cannot be greater than `9`.
     */
    public val slaveReadOnlyCount: Output<Int>?
        get() = javaResource.slaveReadOnlyCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the source instance.
     */
    public val srcdbInstanceId: Output<String>?
        get() = javaResource.srcdbInstanceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Modifies the SSL status. Valid values: `Disable`, `Enable` and `Update`.
     * **NOTE:** This functionality is supported by Cluster mode (Redis 2.8, 4.0, 5.0) and Standard mode( Redis 2.8 only).
     */
    public val sslEnable: Output<String>
        get() = javaResource.sslEnable().applyValue({ args0 -> args0 })

    /**
     * The status of KVStore DBInstance.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Specifies whether to enable TDE. Valid values: `Enabled`.
     * **NOTE:**: TDE cannot be disabled after it is enabled. Before you enable it, evaluate whether this feature affects.
     * your business. For more information, see [Enable TDE](https://www.alibabacloud.com/help/en/redis/user-guide/enable-tde).
     */
    public val tdeStatus: Output<String>
        get() = javaResource.tdeStatus().applyValue({ args0 -> args0 })

    /**
     * Only meaningful if instance_type is `Redis` and network type is VPC. Valid values: `Close`, `Open`. Default value: `Open`. `Close` means the redis instance can be accessed without authentication. `Open` means authentication is required.
     */
    public val vpcAuthMode: Output<String>?
        get() = javaResource.vpcAuthMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of VSwitch.
     */
    public val vswitchId: Output<String>?
        get() = javaResource.vswitchId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the zone.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.kvstore.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.alicloud.kvstore.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
