@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kvstore.kotlin

import com.pulumi.alicloud.kvstore.InstanceArgs.builder
import com.pulumi.alicloud.kvstore.kotlin.inputs.InstanceParameterArgs
import com.pulumi.alicloud.kvstore.kotlin.inputs.InstanceParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * KVStore instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:kvstore/instance:Instance example r-abc12345678
 * ```
 * @property autoRenew Whether to renewal a KVStore DBInstance automatically or not. It is valid when payment_type is `PrePaid`. Default value: `false`.
 * @property autoRenewPeriod Auto-renewal period of an KVStore DBInstance, in the unit of the month. It is valid when payment_type is `PrePaid`. Valid values: [1~12]. Default value: `1`.
 * @property autoUseCoupon Specifies whether to use a coupon. Default value: `false`.
 * @property availabilityZone It has been deprecated from provider version 1.101.0 and `zone_id` instead.
 * @property backupId The ID of the backup file of the source instance.
 * @property backupPeriods Backup period.
 * @property backupTime Backup time, the format is HH:mmZ-HH:mmZ (UTC time).
 * @property businessInfo The ID of the event or the business information.
 * @property capacity The storage capacity of the KVStore DBInstance. Unit: MB.
 * @property config The configuration of the KVStore DBInstance. Available parameters can refer to the latest docs [Instance configurations table](https://www.alibabacloud.com/help/en/redis/user-guide/supported-parameters).
 * @property connectionStringPrefix It has been deprecated from provider version 1.101.0 and resource `alicloud.kvstore.Connection` instead.
 * @property couponNo The coupon code. **NOTE:** The default value `youhuiquan_promotion_option_id_for_blank` removed since v1.216.0, this can cause your status file to change even if it has not been modified, so please review your change plan before apply change plan.
 * @property dbInstanceName The name of KVStore DBInstance. It is a string of 2 to 256 characters.
 * @property dedicatedHostGroupId The ID of the dedicated cluster. This parameter is required when you create an ApsaraDB for Redis instance in a dedicated cluster.
 * @property dryRun Specifies whether to precheck the request. Valid values:
 * @property effectiveTime The time when the database is switched after the instance is migrated, or when the major version is upgraded, or when the instance class is upgraded. Valid values:
 * - `Immediately` (Default): The configurations are immediately changed.
 * - `MaintainTime`: The configurations are changed within the maintenance window. You can set `maintain_start_time` and `maintain_end_time` to change the maintenance window.
 * @property enableBackupLog Turn on or off incremental backup. Valid values: `1`, `0`. Default value: `0`
 * @property enablePublic It has been deprecated from provider version 1.101.0 and resource `alicloud.kvstore.Connection` instead.
 * @property encryptionKey The Custom key ID, which you can get by calling DescribeEncryptionKeyList.If this parameter is not passed, the key is automatically generated by the key management service. To create a custom key, you can call the CreateKey interface of the key management service.
 * @property encryptionName The Encryption algorithm, default AES-CTR-256.Note that this parameter is only available when the TDEStatus parameter is Enabled.
 * @property engineVersion The engine version of the KVStore DBInstance. Valid values: ["2&#46;8", "4&#46;0", "5&#46;0", "6&#46;0", "7&#46;0"]. Default value: `5.0`.
 * **NOTE:** When `instance_type = Memcache`, the `engine_version` only supports "4.0".
 * @property forceUpgrade Specifies whether to forcibly change the type. Default value: `true`.
 * @property globalInstance Whether to create a distributed cache. Default value: `false`.
 * @property globalInstanceId The ID of distributed cache.
 * @property instanceChargeType It has been deprecated from provider version 1.101.0 and `payment_type` instead.
 * @property instanceClass Type of the applied ApsaraDB for Redis instance. It can be retrieved by data source `alicloud.kvstore.getInstanceClasses`
 * or referring to help-docs [Instance type table](https://www.alibabacloud.com/help/doc-detail/26350.htm).
 * @property instanceName It has been deprecated from provider version 1.101.0 and `db_instance_name` instead.
 * @property instanceReleaseProtection Whether to open the release protection.
 * @property instanceType The engine type of the KVStore DBInstance. Valid values: `Redis` or `Memcache`. Default value: `Redis`.
 * @property isAutoUpgradeOpen Specifies whether to enable automatic minor version update. Valid values:
 * @property kmsEncryptedPassword An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored.
 * @property kmsEncryptionContext An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
 * @property maintainEndTime The end time of the operation and maintenance time period of the KVStore DBInstance, in the format of HH:mmZ (UTC time).
 * @property maintainStartTime The start time of the operation and maintenance time period of the KVStore DBInstance, in the format of HH:mmZ (UTC time).
 * @property nodeType "Field `node_type` has been deprecated from version 1.120.1". This parameter is determined by the `instance_class`.
 * @property orderType Specifies a change type when you change the configuration of a subscription instance. Valid values: `UPGRADE`, `DOWNGRADE`. Default value: `UPGRADE`. `UPGRADE` means upgrades the configuration of a subscription instance. `DOWNGRADE` means downgrades the configuration of a subscription instance.
 * @property parameters It has been deprecated from provider version 1.101.0 and `config` instead. See `parameters` below.
 * @property password The password of the KVStore DBInstance. The password that is used to connect to the instance. The password must be 8 to 32 characters in length and must contain at least three of the following character types: uppercase letters, lowercase letters, special characters, and digits. Special characters include: `! @ # $ % ^ & * ( ) _ + - =`
 * @property paymentType The billing method of the KVStore DBInstance. Valid values: `PrePaid`, `PostPaid`. Default value: `PostPaid`.
 * @property period The duration that you will buy KVStore DBInstance (in month). It is valid when payment_type is `PrePaid`. Valid values: `[1~9]`, `12`, `24`, `36`.
 * @property port It has been deprecated from provider version 1.101.0 and resource `alicloud.kvstore.Connection` instead.
 * @property privateConnectionPort Private network connection port, used to modify the private network connection port.
 * @property privateConnectionPrefix Private network connection prefix, used to modify the private network connection address. Only supports updating private network connections for existing instance.
 * @property privateIp The internal IP address of the instance.
 * @property readOnlyCount The number of read replicas in the primary zone. Valid values: `1` to `9`.
 * @property resourceGroupId The ID of resource group which the resource belongs.
 * @property restoreTime The point in time of a backup file.
 * @property roleArn The Specify the global resource descriptor ARN (Alibaba Cloud Resource Name) information of the role to be authorized, and use the related key management services after the authorization is completed, in the format: `acs:ram::$accountID:role/$roleName`.
 * @property secondaryZoneId The ID of the secondary zone to which you want to migrate the ApsaraDB for Redis instance.
 * > **NOTE:** If you specify this parameter, the master node and replica node of the instance can be deployed in different zones and disaster recovery is implemented across zones. The instance can withstand failures in data centers.
 * @property securityGroupId The ID of security groups. Separate multiple security group IDs with commas (,), such as `sg-***,sg-***,sg-***`.
 * @property securityIpGroupAttribute The value of this parameter is empty by default. The attribute of the whitelist group. The console does not display the whitelist group whose value of this parameter is hidden.
 * @property securityIpGroupName The name of the whitelist group.
 * @property securityIps The IP addresses in the whitelist group. The maximum number of IP addresses in the whitelist group is 1000.
 * @property shardCount The number of data shards. This parameter is available only if you create a cluster instance that uses cloud disks. You can use this parameter to specify a custom number of data shards. **NOTE:** From version 1.216.0, `shard_count` can be modified.
 * @property slaveReadOnlyCount The number of read replicas in the secondary zone. **NOTE:**: When you create a multi-zone read/write splitting instance, you must specify both `secondary_zone_id` and `slave_read_only_count`.
 * > **NOTE:** The sum of `read_only_count` and `slave_read_only_count` cannot be greater than `9`.
 * @property srcdbInstanceId The ID of the source instance.
 * @property sslEnable Modifies the SSL status. Valid values: `Disable`, `Enable` and `Update`.
 * **NOTE:** This functionality is supported by Cluster mode (Redis 2.8, 4.0, 5.0) and Standard mode( Redis 2.8 only).
 * @property tags A mapping of tags to assign to the resource.
 * @property tdeStatus Specifies whether to enable TDE. Valid values: `Enabled`.
 * **NOTE:**: TDE cannot be disabled after it is enabled. Before you enable it, evaluate whether this feature affects.
 * your business. For more information, see [Enable TDE](https://www.alibabacloud.com/help/en/redis/user-guide/enable-tde).
 * @property vpcAuthMode Only meaningful if instance_type is `Redis` and network type is VPC. Valid values: `Close`, `Open`. Default value: `Open`. `Close` means the redis instance can be accessed without authentication. `Open` means authentication is required.
 * @property vswitchId The ID of VSwitch.
 * @property zoneId The ID of the zone.
 */
public data class InstanceArgs(
    public val autoRenew: Output<Boolean>? = null,
    public val autoRenewPeriod: Output<Int>? = null,
    public val autoUseCoupon: Output<Boolean>? = null,
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from version 1.101.0. Use 'zone_id' instead.
  """,
    )
    public val availabilityZone: Output<String>? = null,
    public val backupId: Output<String>? = null,
    public val backupPeriods: Output<List<String>>? = null,
    public val backupTime: Output<String>? = null,
    public val businessInfo: Output<String>? = null,
    public val capacity: Output<Int>? = null,
    public val config: Output<Map<String, String>>? = null,
    @Deprecated(
        message = """
  Field 'connection_string_prefix' has been deprecated from version 1.101.0. Please use resource
      'alicloud_kvstore_connection' instead.
  """,
    )
    public val connectionStringPrefix: Output<String>? = null,
    public val couponNo: Output<String>? = null,
    public val dbInstanceName: Output<String>? = null,
    public val dedicatedHostGroupId: Output<String>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val effectiveTime: Output<String>? = null,
    public val enableBackupLog: Output<Int>? = null,
    @Deprecated(
        message = """
  Field 'enable_public' has been deprecated from version 1.101.0. Please use resource
      'alicloud_kvstore_connection' instead.
  """,
    )
    public val enablePublic: Output<Boolean>? = null,
    public val encryptionKey: Output<String>? = null,
    public val encryptionName: Output<String>? = null,
    public val engineVersion: Output<String>? = null,
    public val forceUpgrade: Output<Boolean>? = null,
    public val globalInstance: Output<Boolean>? = null,
    public val globalInstanceId: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'instance_charge_type' has been deprecated from version 1.101.0. Use 'payment_type' instead.
  """,
    )
    public val instanceChargeType: Output<String>? = null,
    public val instanceClass: Output<String>? = null,
    @Deprecated(
        message = """
  Field `instance_name` has been deprecated from version 1.101.0. Use `db_instance_name` instead.
  """,
    )
    public val instanceName: Output<String>? = null,
    public val instanceReleaseProtection: Output<Boolean>? = null,
    public val instanceType: Output<String>? = null,
    public val isAutoUpgradeOpen: Output<String>? = null,
    public val kmsEncryptedPassword: Output<String>? = null,
    public val kmsEncryptionContext: Output<Map<String, String>>? = null,
    public val maintainEndTime: Output<String>? = null,
    public val maintainStartTime: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'node_type' has been deprecated from version 1.120.1
  """,
    )
    public val nodeType: Output<String>? = null,
    public val orderType: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'parameters' has been deprecated from version 1.101.0. Use 'config' instead.
  """,
    )
    public val parameters: Output<List<InstanceParameterArgs>>? = null,
    public val password: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val privateConnectionPort: Output<String>? = null,
    public val privateConnectionPrefix: Output<String>? = null,
    public val privateIp: Output<String>? = null,
    public val readOnlyCount: Output<Int>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val restoreTime: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val secondaryZoneId: Output<String>? = null,
    public val securityGroupId: Output<String>? = null,
    public val securityIpGroupAttribute: Output<String>? = null,
    public val securityIpGroupName: Output<String>? = null,
    public val securityIps: Output<List<String>>? = null,
    public val shardCount: Output<Int>? = null,
    public val slaveReadOnlyCount: Output<Int>? = null,
    public val srcdbInstanceId: Output<String>? = null,
    public val sslEnable: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tdeStatus: Output<String>? = null,
    public val vpcAuthMode: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.kvstore.InstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.kvstore.InstanceArgs =
        com.pulumi.alicloud.kvstore.InstanceArgs.builder()
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .autoRenewPeriod(autoRenewPeriod?.applyValue({ args0 -> args0 }))
            .autoUseCoupon(autoUseCoupon?.applyValue({ args0 -> args0 }))
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .backupId(backupId?.applyValue({ args0 -> args0 }))
            .backupPeriods(backupPeriods?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .backupTime(backupTime?.applyValue({ args0 -> args0 }))
            .businessInfo(businessInfo?.applyValue({ args0 -> args0 }))
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .config(config?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .connectionStringPrefix(connectionStringPrefix?.applyValue({ args0 -> args0 }))
            .couponNo(couponNo?.applyValue({ args0 -> args0 }))
            .dbInstanceName(dbInstanceName?.applyValue({ args0 -> args0 }))
            .dedicatedHostGroupId(dedicatedHostGroupId?.applyValue({ args0 -> args0 }))
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .effectiveTime(effectiveTime?.applyValue({ args0 -> args0 }))
            .enableBackupLog(enableBackupLog?.applyValue({ args0 -> args0 }))
            .enablePublic(enablePublic?.applyValue({ args0 -> args0 }))
            .encryptionKey(encryptionKey?.applyValue({ args0 -> args0 }))
            .encryptionName(encryptionName?.applyValue({ args0 -> args0 }))
            .engineVersion(engineVersion?.applyValue({ args0 -> args0 }))
            .forceUpgrade(forceUpgrade?.applyValue({ args0 -> args0 }))
            .globalInstance(globalInstance?.applyValue({ args0 -> args0 }))
            .globalInstanceId(globalInstanceId?.applyValue({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType?.applyValue({ args0 -> args0 }))
            .instanceClass(instanceClass?.applyValue({ args0 -> args0 }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .instanceReleaseProtection(instanceReleaseProtection?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .isAutoUpgradeOpen(isAutoUpgradeOpen?.applyValue({ args0 -> args0 }))
            .kmsEncryptedPassword(kmsEncryptedPassword?.applyValue({ args0 -> args0 }))
            .kmsEncryptionContext(
                kmsEncryptionContext?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .maintainEndTime(maintainEndTime?.applyValue({ args0 -> args0 }))
            .maintainStartTime(maintainStartTime?.applyValue({ args0 -> args0 }))
            .nodeType(nodeType?.applyValue({ args0 -> args0 }))
            .orderType(orderType?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .password(password?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .privateConnectionPort(privateConnectionPort?.applyValue({ args0 -> args0 }))
            .privateConnectionPrefix(privateConnectionPrefix?.applyValue({ args0 -> args0 }))
            .privateIp(privateIp?.applyValue({ args0 -> args0 }))
            .readOnlyCount(readOnlyCount?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .restoreTime(restoreTime?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .secondaryZoneId(secondaryZoneId?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .securityIpGroupAttribute(securityIpGroupAttribute?.applyValue({ args0 -> args0 }))
            .securityIpGroupName(securityIpGroupName?.applyValue({ args0 -> args0 }))
            .securityIps(securityIps?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .shardCount(shardCount?.applyValue({ args0 -> args0 }))
            .slaveReadOnlyCount(slaveReadOnlyCount?.applyValue({ args0 -> args0 }))
            .srcdbInstanceId(srcdbInstanceId?.applyValue({ args0 -> args0 }))
            .sslEnable(sslEnable?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tdeStatus(tdeStatus?.applyValue({ args0 -> args0 }))
            .vpcAuthMode(vpcAuthMode?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var autoRenew: Output<Boolean>? = null

    private var autoRenewPeriod: Output<Int>? = null

    private var autoUseCoupon: Output<Boolean>? = null

    private var availabilityZone: Output<String>? = null

    private var backupId: Output<String>? = null

    private var backupPeriods: Output<List<String>>? = null

    private var backupTime: Output<String>? = null

    private var businessInfo: Output<String>? = null

    private var capacity: Output<Int>? = null

    private var config: Output<Map<String, String>>? = null

    private var connectionStringPrefix: Output<String>? = null

    private var couponNo: Output<String>? = null

    private var dbInstanceName: Output<String>? = null

    private var dedicatedHostGroupId: Output<String>? = null

    private var dryRun: Output<Boolean>? = null

    private var effectiveTime: Output<String>? = null

    private var enableBackupLog: Output<Int>? = null

    private var enablePublic: Output<Boolean>? = null

    private var encryptionKey: Output<String>? = null

    private var encryptionName: Output<String>? = null

    private var engineVersion: Output<String>? = null

    private var forceUpgrade: Output<Boolean>? = null

    private var globalInstance: Output<Boolean>? = null

    private var globalInstanceId: Output<String>? = null

    private var instanceChargeType: Output<String>? = null

    private var instanceClass: Output<String>? = null

    private var instanceName: Output<String>? = null

    private var instanceReleaseProtection: Output<Boolean>? = null

    private var instanceType: Output<String>? = null

    private var isAutoUpgradeOpen: Output<String>? = null

    private var kmsEncryptedPassword: Output<String>? = null

    private var kmsEncryptionContext: Output<Map<String, String>>? = null

    private var maintainEndTime: Output<String>? = null

    private var maintainStartTime: Output<String>? = null

    private var nodeType: Output<String>? = null

    private var orderType: Output<String>? = null

    private var parameters: Output<List<InstanceParameterArgs>>? = null

    private var password: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<String>? = null

    private var port: Output<Int>? = null

    private var privateConnectionPort: Output<String>? = null

    private var privateConnectionPrefix: Output<String>? = null

    private var privateIp: Output<String>? = null

    private var readOnlyCount: Output<Int>? = null

    private var resourceGroupId: Output<String>? = null

    private var restoreTime: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var secondaryZoneId: Output<String>? = null

    private var securityGroupId: Output<String>? = null

    private var securityIpGroupAttribute: Output<String>? = null

    private var securityIpGroupName: Output<String>? = null

    private var securityIps: Output<List<String>>? = null

    private var shardCount: Output<Int>? = null

    private var slaveReadOnlyCount: Output<Int>? = null

    private var srcdbInstanceId: Output<String>? = null

    private var sslEnable: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tdeStatus: Output<String>? = null

    private var vpcAuthMode: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value Whether to renewal a KVStore DBInstance automatically or not. It is valid when payment_type is `PrePaid`. Default value: `false`.
     */
    @JvmName("gcongxassvxobflv")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value Auto-renewal period of an KVStore DBInstance, in the unit of the month. It is valid when payment_type is `PrePaid`. Valid values: [1~12]. Default value: `1`.
     */
    @JvmName("pmipolnrqbwsktju")
    public suspend fun autoRenewPeriod(`value`: Output<Int>) {
        this.autoRenewPeriod = value
    }

    /**
     * @param value Specifies whether to use a coupon. Default value: `false`.
     */
    @JvmName("pnqovufurjydgoxt")
    public suspend fun autoUseCoupon(`value`: Output<Boolean>) {
        this.autoUseCoupon = value
    }

    /**
     * @param value It has been deprecated from provider version 1.101.0 and `zone_id` instead.
     */
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from version 1.101.0. Use 'zone_id' instead.
  """,
    )
    @JvmName("gvgyactmhrnsbexp")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value The ID of the backup file of the source instance.
     */
    @JvmName("qlovxypskjvamcrt")
    public suspend fun backupId(`value`: Output<String>) {
        this.backupId = value
    }

    /**
     * @param value Backup period.
     */
    @JvmName("urbdjwqnpnljjmsx")
    public suspend fun backupPeriods(`value`: Output<List<String>>) {
        this.backupPeriods = value
    }

    @JvmName("utdswcrijndgkxqa")
    public suspend fun backupPeriods(vararg values: Output<String>) {
        this.backupPeriods = Output.all(values.asList())
    }

    /**
     * @param values Backup period.
     */
    @JvmName("drqwavwsnulheyvs")
    public suspend fun backupPeriods(values: List<Output<String>>) {
        this.backupPeriods = Output.all(values)
    }

    /**
     * @param value Backup time, the format is HH:mmZ-HH:mmZ (UTC time).
     */
    @JvmName("saeieaebmxveuywo")
    public suspend fun backupTime(`value`: Output<String>) {
        this.backupTime = value
    }

    /**
     * @param value The ID of the event or the business information.
     */
    @JvmName("ylcdidwllblvhgwj")
    public suspend fun businessInfo(`value`: Output<String>) {
        this.businessInfo = value
    }

    /**
     * @param value The storage capacity of the KVStore DBInstance. Unit: MB.
     */
    @JvmName("pthpbjnrythsghkw")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value The configuration of the KVStore DBInstance. Available parameters can refer to the latest docs [Instance configurations table](https://www.alibabacloud.com/help/en/redis/user-guide/supported-parameters).
     */
    @JvmName("beqksarixlueeqpa")
    public suspend fun config(`value`: Output<Map<String, String>>) {
        this.config = value
    }

    /**
     * @param value It has been deprecated from provider version 1.101.0 and resource `alicloud.kvstore.Connection` instead.
     */
    @Deprecated(
        message = """
  Field 'connection_string_prefix' has been deprecated from version 1.101.0. Please use resource
      'alicloud_kvstore_connection' instead.
  """,
    )
    @JvmName("maklhdnawbjyfcbj")
    public suspend fun connectionStringPrefix(`value`: Output<String>) {
        this.connectionStringPrefix = value
    }

    /**
     * @param value The coupon code. **NOTE:** The default value `youhuiquan_promotion_option_id_for_blank` removed since v1.216.0, this can cause your status file to change even if it has not been modified, so please review your change plan before apply change plan.
     */
    @JvmName("btecddsavmttjatx")
    public suspend fun couponNo(`value`: Output<String>) {
        this.couponNo = value
    }

    /**
     * @param value The name of KVStore DBInstance. It is a string of 2 to 256 characters.
     */
    @JvmName("mdngdyehmlgcsccv")
    public suspend fun dbInstanceName(`value`: Output<String>) {
        this.dbInstanceName = value
    }

    /**
     * @param value The ID of the dedicated cluster. This parameter is required when you create an ApsaraDB for Redis instance in a dedicated cluster.
     */
    @JvmName("rwhkoxfgodylydjw")
    public suspend fun dedicatedHostGroupId(`value`: Output<String>) {
        this.dedicatedHostGroupId = value
    }

    /**
     * @param value Specifies whether to precheck the request. Valid values:
     */
    @JvmName("fejhfnhbcyvsiwrf")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value The time when the database is switched after the instance is migrated, or when the major version is upgraded, or when the instance class is upgraded. Valid values:
     * - `Immediately` (Default): The configurations are immediately changed.
     * - `MaintainTime`: The configurations are changed within the maintenance window. You can set `maintain_start_time` and `maintain_end_time` to change the maintenance window.
     */
    @JvmName("jtjdvkaneskgycsi")
    public suspend fun effectiveTime(`value`: Output<String>) {
        this.effectiveTime = value
    }

    /**
     * @param value Turn on or off incremental backup. Valid values: `1`, `0`. Default value: `0`
     */
    @JvmName("byqcqktpjyxuyfto")
    public suspend fun enableBackupLog(`value`: Output<Int>) {
        this.enableBackupLog = value
    }

    /**
     * @param value It has been deprecated from provider version 1.101.0 and resource `alicloud.kvstore.Connection` instead.
     */
    @Deprecated(
        message = """
  Field 'enable_public' has been deprecated from version 1.101.0. Please use resource
      'alicloud_kvstore_connection' instead.
  """,
    )
    @JvmName("fwqjodiwvdmsqlrq")
    public suspend fun enablePublic(`value`: Output<Boolean>) {
        this.enablePublic = value
    }

    /**
     * @param value The Custom key ID, which you can get by calling DescribeEncryptionKeyList.If this parameter is not passed, the key is automatically generated by the key management service. To create a custom key, you can call the CreateKey interface of the key management service.
     */
    @JvmName("vxgnofrahnuvdklg")
    public suspend fun encryptionKey(`value`: Output<String>) {
        this.encryptionKey = value
    }

    /**
     * @param value The Encryption algorithm, default AES-CTR-256.Note that this parameter is only available when the TDEStatus parameter is Enabled.
     */
    @JvmName("drvanbavcrwnohwk")
    public suspend fun encryptionName(`value`: Output<String>) {
        this.encryptionName = value
    }

    /**
     * @param value The engine version of the KVStore DBInstance. Valid values: ["2&#46;8", "4&#46;0", "5&#46;0", "6&#46;0", "7&#46;0"]. Default value: `5.0`.
     * **NOTE:** When `instance_type = Memcache`, the `engine_version` only supports "4.0".
     */
    @JvmName("kyvpaqxrggmfnycy")
    public suspend fun engineVersion(`value`: Output<String>) {
        this.engineVersion = value
    }

    /**
     * @param value Specifies whether to forcibly change the type. Default value: `true`.
     */
    @JvmName("gdlctkskgxfatbtu")
    public suspend fun forceUpgrade(`value`: Output<Boolean>) {
        this.forceUpgrade = value
    }

    /**
     * @param value Whether to create a distributed cache. Default value: `false`.
     */
    @JvmName("ryihqqemxxojknwh")
    public suspend fun globalInstance(`value`: Output<Boolean>) {
        this.globalInstance = value
    }

    /**
     * @param value The ID of distributed cache.
     */
    @JvmName("teerdianoefxgrlv")
    public suspend fun globalInstanceId(`value`: Output<String>) {
        this.globalInstanceId = value
    }

    /**
     * @param value It has been deprecated from provider version 1.101.0 and `payment_type` instead.
     */
    @Deprecated(
        message = """
  Field 'instance_charge_type' has been deprecated from version 1.101.0. Use 'payment_type' instead.
  """,
    )
    @JvmName("sdctslcqhwctumbn")
    public suspend fun instanceChargeType(`value`: Output<String>) {
        this.instanceChargeType = value
    }

    /**
     * @param value Type of the applied ApsaraDB for Redis instance. It can be retrieved by data source `alicloud.kvstore.getInstanceClasses`
     * or referring to help-docs [Instance type table](https://www.alibabacloud.com/help/doc-detail/26350.htm).
     */
    @JvmName("dtdfsjpopymhybvw")
    public suspend fun instanceClass(`value`: Output<String>) {
        this.instanceClass = value
    }

    /**
     * @param value It has been deprecated from provider version 1.101.0 and `db_instance_name` instead.
     */
    @Deprecated(
        message = """
  Field `instance_name` has been deprecated from version 1.101.0. Use `db_instance_name` instead.
  """,
    )
    @JvmName("okjnigfhqvxumskl")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value Whether to open the release protection.
     */
    @JvmName("qoynbtylujsfyyxi")
    public suspend fun instanceReleaseProtection(`value`: Output<Boolean>) {
        this.instanceReleaseProtection = value
    }

    /**
     * @param value The engine type of the KVStore DBInstance. Valid values: `Redis` or `Memcache`. Default value: `Redis`.
     */
    @JvmName("asnmngrnbvefonrj")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Specifies whether to enable automatic minor version update. Valid values:
     */
    @JvmName("yqnhhletwiftieuq")
    public suspend fun isAutoUpgradeOpen(`value`: Output<String>) {
        this.isAutoUpgradeOpen = value
    }

    /**
     * @param value An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored.
     */
    @JvmName("gjrfdblmynsbnjty")
    public suspend fun kmsEncryptedPassword(`value`: Output<String>) {
        this.kmsEncryptedPassword = value
    }

    /**
     * @param value An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("xvusmayrnpaxuomf")
    public suspend fun kmsEncryptionContext(`value`: Output<Map<String, String>>) {
        this.kmsEncryptionContext = value
    }

    /**
     * @param value The end time of the operation and maintenance time period of the KVStore DBInstance, in the format of HH:mmZ (UTC time).
     */
    @JvmName("aqpwfbtrkbplasyd")
    public suspend fun maintainEndTime(`value`: Output<String>) {
        this.maintainEndTime = value
    }

    /**
     * @param value The start time of the operation and maintenance time period of the KVStore DBInstance, in the format of HH:mmZ (UTC time).
     */
    @JvmName("ybibkjktjagyyeqt")
    public suspend fun maintainStartTime(`value`: Output<String>) {
        this.maintainStartTime = value
    }

    /**
     * @param value "Field `node_type` has been deprecated from version 1.120.1". This parameter is determined by the `instance_class`.
     */
    @Deprecated(
        message = """
  Field 'node_type' has been deprecated from version 1.120.1
  """,
    )
    @JvmName("nfrkdaccxkiptews")
    public suspend fun nodeType(`value`: Output<String>) {
        this.nodeType = value
    }

    /**
     * @param value Specifies a change type when you change the configuration of a subscription instance. Valid values: `UPGRADE`, `DOWNGRADE`. Default value: `UPGRADE`. `UPGRADE` means upgrades the configuration of a subscription instance. `DOWNGRADE` means downgrades the configuration of a subscription instance.
     */
    @JvmName("pytwtvjwjslosjuo")
    public suspend fun orderType(`value`: Output<String>) {
        this.orderType = value
    }

    /**
     * @param value It has been deprecated from provider version 1.101.0 and `config` instead. See `parameters` below.
     */
    @Deprecated(
        message = """
  Field 'parameters' has been deprecated from version 1.101.0. Use 'config' instead.
  """,
    )
    @JvmName("rwltdklpbcvebnmi")
    public suspend fun parameters(`value`: Output<List<InstanceParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("cethifbcjhytpila")
    public suspend fun parameters(vararg values: Output<InstanceParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values It has been deprecated from provider version 1.101.0 and `config` instead. See `parameters` below.
     */
    @Deprecated(
        message = """
  Field 'parameters' has been deprecated from version 1.101.0. Use 'config' instead.
  """,
    )
    @JvmName("qaowmwvckawaaxjr")
    public suspend fun parameters(values: List<Output<InstanceParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The password of the KVStore DBInstance. The password that is used to connect to the instance. The password must be 8 to 32 characters in length and must contain at least three of the following character types: uppercase letters, lowercase letters, special characters, and digits. Special characters include: `! @ # $ % ^ & * ( ) _ + - =`
     */
    @JvmName("ehhiuxjhxududuav")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The billing method of the KVStore DBInstance. Valid values: `PrePaid`, `PostPaid`. Default value: `PostPaid`.
     */
    @JvmName("wxdbmmearpalrwcc")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The duration that you will buy KVStore DBInstance (in month). It is valid when payment_type is `PrePaid`. Valid values: `[1~9]`, `12`, `24`, `36`.
     */
    @JvmName("cvlihjcumxbnliqx")
    public suspend fun period(`value`: Output<String>) {
        this.period = value
    }

    /**
     * @param value It has been deprecated from provider version 1.101.0 and resource `alicloud.kvstore.Connection` instead.
     */
    @JvmName("ogyvutwgvqglcvtq")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Private network connection port, used to modify the private network connection port.
     */
    @JvmName("ikfvncdvcgowqhah")
    public suspend fun privateConnectionPort(`value`: Output<String>) {
        this.privateConnectionPort = value
    }

    /**
     * @param value Private network connection prefix, used to modify the private network connection address. Only supports updating private network connections for existing instance.
     */
    @JvmName("flcpobextoccuwvu")
    public suspend fun privateConnectionPrefix(`value`: Output<String>) {
        this.privateConnectionPrefix = value
    }

    /**
     * @param value The internal IP address of the instance.
     */
    @JvmName("tqvrguktietxpjld")
    public suspend fun privateIp(`value`: Output<String>) {
        this.privateIp = value
    }

    /**
     * @param value The number of read replicas in the primary zone. Valid values: `1` to `9`.
     */
    @JvmName("imkandvlvhwjetsn")
    public suspend fun readOnlyCount(`value`: Output<Int>) {
        this.readOnlyCount = value
    }

    /**
     * @param value The ID of resource group which the resource belongs.
     */
    @JvmName("qhamqtsnxijprais")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The point in time of a backup file.
     */
    @JvmName("wnxpdgsosxfophrr")
    public suspend fun restoreTime(`value`: Output<String>) {
        this.restoreTime = value
    }

    /**
     * @param value The Specify the global resource descriptor ARN (Alibaba Cloud Resource Name) information of the role to be authorized, and use the related key management services after the authorization is completed, in the format: `acs:ram::$accountID:role/$roleName`.
     */
    @JvmName("ahhyblluahmehjog")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The ID of the secondary zone to which you want to migrate the ApsaraDB for Redis instance.
     * > **NOTE:** If you specify this parameter, the master node and replica node of the instance can be deployed in different zones and disaster recovery is implemented across zones. The instance can withstand failures in data centers.
     */
    @JvmName("ykrvlallnfauthma")
    public suspend fun secondaryZoneId(`value`: Output<String>) {
        this.secondaryZoneId = value
    }

    /**
     * @param value The ID of security groups. Separate multiple security group IDs with commas (,), such as `sg-***,sg-***,sg-***`.
     */
    @JvmName("kiciefnaoeposuus")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value The value of this parameter is empty by default. The attribute of the whitelist group. The console does not display the whitelist group whose value of this parameter is hidden.
     */
    @JvmName("olpdawychjdaockp")
    public suspend fun securityIpGroupAttribute(`value`: Output<String>) {
        this.securityIpGroupAttribute = value
    }

    /**
     * @param value The name of the whitelist group.
     */
    @JvmName("ogalfqyabodtnmjk")
    public suspend fun securityIpGroupName(`value`: Output<String>) {
        this.securityIpGroupName = value
    }

    /**
     * @param value The IP addresses in the whitelist group. The maximum number of IP addresses in the whitelist group is 1000.
     */
    @JvmName("gxbqxcxlumuralse")
    public suspend fun securityIps(`value`: Output<List<String>>) {
        this.securityIps = value
    }

    @JvmName("nyemrjivnxxahpgm")
    public suspend fun securityIps(vararg values: Output<String>) {
        this.securityIps = Output.all(values.asList())
    }

    /**
     * @param values The IP addresses in the whitelist group. The maximum number of IP addresses in the whitelist group is 1000.
     */
    @JvmName("pslwocrmpuqgqskj")
    public suspend fun securityIps(values: List<Output<String>>) {
        this.securityIps = Output.all(values)
    }

    /**
     * @param value The number of data shards. This parameter is available only if you create a cluster instance that uses cloud disks. You can use this parameter to specify a custom number of data shards. **NOTE:** From version 1.216.0, `shard_count` can be modified.
     */
    @JvmName("ojdxckbehxxxtdxn")
    public suspend fun shardCount(`value`: Output<Int>) {
        this.shardCount = value
    }

    /**
     * @param value The number of read replicas in the secondary zone. **NOTE:**: When you create a multi-zone read/write splitting instance, you must specify both `secondary_zone_id` and `slave_read_only_count`.
     * > **NOTE:** The sum of `read_only_count` and `slave_read_only_count` cannot be greater than `9`.
     */
    @JvmName("kymoabcaloxvoqgr")
    public suspend fun slaveReadOnlyCount(`value`: Output<Int>) {
        this.slaveReadOnlyCount = value
    }

    /**
     * @param value The ID of the source instance.
     */
    @JvmName("vnqfrrehpbjsltny")
    public suspend fun srcdbInstanceId(`value`: Output<String>) {
        this.srcdbInstanceId = value
    }

    /**
     * @param value Modifies the SSL status. Valid values: `Disable`, `Enable` and `Update`.
     * **NOTE:** This functionality is supported by Cluster mode (Redis 2.8, 4.0, 5.0) and Standard mode( Redis 2.8 only).
     */
    @JvmName("xhgpydtnagjgpkfs")
    public suspend fun sslEnable(`value`: Output<String>) {
        this.sslEnable = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("jvukmitsdguqvwwk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies whether to enable TDE. Valid values: `Enabled`.
     * **NOTE:**: TDE cannot be disabled after it is enabled. Before you enable it, evaluate whether this feature affects.
     * your business. For more information, see [Enable TDE](https://www.alibabacloud.com/help/en/redis/user-guide/enable-tde).
     */
    @JvmName("rpwsyxgdiocckabv")
    public suspend fun tdeStatus(`value`: Output<String>) {
        this.tdeStatus = value
    }

    /**
     * @param value Only meaningful if instance_type is `Redis` and network type is VPC. Valid values: `Close`, `Open`. Default value: `Open`. `Close` means the redis instance can be accessed without authentication. `Open` means authentication is required.
     */
    @JvmName("atuwmgtygknabrfj")
    public suspend fun vpcAuthMode(`value`: Output<String>) {
        this.vpcAuthMode = value
    }

    /**
     * @param value The ID of VSwitch.
     */
    @JvmName("vcxmrnpxrheenguh")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The ID of the zone.
     */
    @JvmName("qgjkyjclpqonmmfy")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value Whether to renewal a KVStore DBInstance automatically or not. It is valid when payment_type is `PrePaid`. Default value: `false`.
     */
    @JvmName("ucfwjasrcudkydja")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value Auto-renewal period of an KVStore DBInstance, in the unit of the month. It is valid when payment_type is `PrePaid`. Valid values: [1~12]. Default value: `1`.
     */
    @JvmName("gmlxhbrjaypkcray")
    public suspend fun autoRenewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenewPeriod = mapped
    }

    /**
     * @param value Specifies whether to use a coupon. Default value: `false`.
     */
    @JvmName("xcjncmrjergpixdg")
    public suspend fun autoUseCoupon(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoUseCoupon = mapped
    }

    /**
     * @param value It has been deprecated from provider version 1.101.0 and `zone_id` instead.
     */
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from version 1.101.0. Use 'zone_id' instead.
  """,
    )
    @JvmName("vswamcdtpflirdna")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value The ID of the backup file of the source instance.
     */
    @JvmName("bxnfddcrotvtrywq")
    public suspend fun backupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupId = mapped
    }

    /**
     * @param value Backup period.
     */
    @JvmName("sedbiooayqowdiel")
    public suspend fun backupPeriods(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupPeriods = mapped
    }

    /**
     * @param values Backup period.
     */
    @JvmName("athxuemububogigw")
    public suspend fun backupPeriods(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupPeriods = mapped
    }

    /**
     * @param value Backup time, the format is HH:mmZ-HH:mmZ (UTC time).
     */
    @JvmName("smjotqfsvumcvboq")
    public suspend fun backupTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupTime = mapped
    }

    /**
     * @param value The ID of the event or the business information.
     */
    @JvmName("gtfwesdvscahfuke")
    public suspend fun businessInfo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.businessInfo = mapped
    }

    /**
     * @param value The storage capacity of the KVStore DBInstance. Unit: MB.
     */
    @JvmName("afkovpuudwkoufdq")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value The configuration of the KVStore DBInstance. Available parameters can refer to the latest docs [Instance configurations table](https://www.alibabacloud.com/help/en/redis/user-guide/supported-parameters).
     */
    @JvmName("gogiofsfaapmwwms")
    public suspend fun config(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.config = mapped
    }

    /**
     * @param values The configuration of the KVStore DBInstance. Available parameters can refer to the latest docs [Instance configurations table](https://www.alibabacloud.com/help/en/redis/user-guide/supported-parameters).
     */
    @JvmName("abgmunkyumdhsvss")
    public fun config(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.config = mapped
    }

    /**
     * @param value It has been deprecated from provider version 1.101.0 and resource `alicloud.kvstore.Connection` instead.
     */
    @Deprecated(
        message = """
  Field 'connection_string_prefix' has been deprecated from version 1.101.0. Please use resource
      'alicloud_kvstore_connection' instead.
  """,
    )
    @JvmName("vaxklvjjrrkvnuig")
    public suspend fun connectionStringPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionStringPrefix = mapped
    }

    /**
     * @param value The coupon code. **NOTE:** The default value `youhuiquan_promotion_option_id_for_blank` removed since v1.216.0, this can cause your status file to change even if it has not been modified, so please review your change plan before apply change plan.
     */
    @JvmName("ctqqjwymtmrvmico")
    public suspend fun couponNo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.couponNo = mapped
    }

    /**
     * @param value The name of KVStore DBInstance. It is a string of 2 to 256 characters.
     */
    @JvmName("agrxnjfffttgxftt")
    public suspend fun dbInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceName = mapped
    }

    /**
     * @param value The ID of the dedicated cluster. This parameter is required when you create an ApsaraDB for Redis instance in a dedicated cluster.
     */
    @JvmName("hfjldryrbljqenqh")
    public suspend fun dedicatedHostGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dedicatedHostGroupId = mapped
    }

    /**
     * @param value Specifies whether to precheck the request. Valid values:
     */
    @JvmName("xoctmldgxqrrthaa")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value The time when the database is switched after the instance is migrated, or when the major version is upgraded, or when the instance class is upgraded. Valid values:
     * - `Immediately` (Default): The configurations are immediately changed.
     * - `MaintainTime`: The configurations are changed within the maintenance window. You can set `maintain_start_time` and `maintain_end_time` to change the maintenance window.
     */
    @JvmName("qohbixftihlschuc")
    public suspend fun effectiveTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effectiveTime = mapped
    }

    /**
     * @param value Turn on or off incremental backup. Valid values: `1`, `0`. Default value: `0`
     */
    @JvmName("cbaanapmyhrpedtc")
    public suspend fun enableBackupLog(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableBackupLog = mapped
    }

    /**
     * @param value It has been deprecated from provider version 1.101.0 and resource `alicloud.kvstore.Connection` instead.
     */
    @Deprecated(
        message = """
  Field 'enable_public' has been deprecated from version 1.101.0. Please use resource
      'alicloud_kvstore_connection' instead.
  """,
    )
    @JvmName("yodyqtvebmpxmhnd")
    public suspend fun enablePublic(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePublic = mapped
    }

    /**
     * @param value The Custom key ID, which you can get by calling DescribeEncryptionKeyList.If this parameter is not passed, the key is automatically generated by the key management service. To create a custom key, you can call the CreateKey interface of the key management service.
     */
    @JvmName("yuysstxdpcoyfqkl")
    public suspend fun encryptionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionKey = mapped
    }

    /**
     * @param value The Encryption algorithm, default AES-CTR-256.Note that this parameter is only available when the TDEStatus parameter is Enabled.
     */
    @JvmName("dfrdenuscbvbytgg")
    public suspend fun encryptionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionName = mapped
    }

    /**
     * @param value The engine version of the KVStore DBInstance. Valid values: ["2&#46;8", "4&#46;0", "5&#46;0", "6&#46;0", "7&#46;0"]. Default value: `5.0`.
     * **NOTE:** When `instance_type = Memcache`, the `engine_version` only supports "4.0".
     */
    @JvmName("fswaxmtfegdnrwui")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineVersion = mapped
    }

    /**
     * @param value Specifies whether to forcibly change the type. Default value: `true`.
     */
    @JvmName("cjbuwetneppgwkww")
    public suspend fun forceUpgrade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceUpgrade = mapped
    }

    /**
     * @param value Whether to create a distributed cache. Default value: `false`.
     */
    @JvmName("eonvopxriktqnjwm")
    public suspend fun globalInstance(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalInstance = mapped
    }

    /**
     * @param value The ID of distributed cache.
     */
    @JvmName("caxudciosvdffaih")
    public suspend fun globalInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalInstanceId = mapped
    }

    /**
     * @param value It has been deprecated from provider version 1.101.0 and `payment_type` instead.
     */
    @Deprecated(
        message = """
  Field 'instance_charge_type' has been deprecated from version 1.101.0. Use 'payment_type' instead.
  """,
    )
    @JvmName("wymoeiqmceeaxvjf")
    public suspend fun instanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceChargeType = mapped
    }

    /**
     * @param value Type of the applied ApsaraDB for Redis instance. It can be retrieved by data source `alicloud.kvstore.getInstanceClasses`
     * or referring to help-docs [Instance type table](https://www.alibabacloud.com/help/doc-detail/26350.htm).
     */
    @JvmName("spuktbjcstdsuqxd")
    public suspend fun instanceClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceClass = mapped
    }

    /**
     * @param value It has been deprecated from provider version 1.101.0 and `db_instance_name` instead.
     */
    @Deprecated(
        message = """
  Field `instance_name` has been deprecated from version 1.101.0. Use `db_instance_name` instead.
  """,
    )
    @JvmName("rpotfsempgijcavu")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value Whether to open the release protection.
     */
    @JvmName("uhjjgvftbkepwafw")
    public suspend fun instanceReleaseProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceReleaseProtection = mapped
    }

    /**
     * @param value The engine type of the KVStore DBInstance. Valid values: `Redis` or `Memcache`. Default value: `Redis`.
     */
    @JvmName("kprmipjchrpcnahn")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Specifies whether to enable automatic minor version update. Valid values:
     */
    @JvmName("wxguwxnlhyktcjeg")
    public suspend fun isAutoUpgradeOpen(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAutoUpgradeOpen = mapped
    }

    /**
     * @param value An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored.
     */
    @JvmName("dcqdwnilgygqlkai")
    public suspend fun kmsEncryptedPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptedPassword = mapped
    }

    /**
     * @param value An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("icwacggmefuxghys")
    public suspend fun kmsEncryptionContext(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptionContext = mapped
    }

    /**
     * @param values An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("jqdktgauobkhkclj")
    public fun kmsEncryptionContext(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kmsEncryptionContext = mapped
    }

    /**
     * @param value The end time of the operation and maintenance time period of the KVStore DBInstance, in the format of HH:mmZ (UTC time).
     */
    @JvmName("vwuosflcnsnjigtb")
    public suspend fun maintainEndTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintainEndTime = mapped
    }

    /**
     * @param value The start time of the operation and maintenance time period of the KVStore DBInstance, in the format of HH:mmZ (UTC time).
     */
    @JvmName("kafkkovrakwrygwy")
    public suspend fun maintainStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintainStartTime = mapped
    }

    /**
     * @param value "Field `node_type` has been deprecated from version 1.120.1". This parameter is determined by the `instance_class`.
     */
    @Deprecated(
        message = """
  Field 'node_type' has been deprecated from version 1.120.1
  """,
    )
    @JvmName("ntbnsvuokullpyvj")
    public suspend fun nodeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeType = mapped
    }

    /**
     * @param value Specifies a change type when you change the configuration of a subscription instance. Valid values: `UPGRADE`, `DOWNGRADE`. Default value: `UPGRADE`. `UPGRADE` means upgrades the configuration of a subscription instance. `DOWNGRADE` means downgrades the configuration of a subscription instance.
     */
    @JvmName("rjybjegnhxeqnsfr")
    public suspend fun orderType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orderType = mapped
    }

    /**
     * @param value It has been deprecated from provider version 1.101.0 and `config` instead. See `parameters` below.
     */
    @Deprecated(
        message = """
  Field 'parameters' has been deprecated from version 1.101.0. Use 'config' instead.
  """,
    )
    @JvmName("ltdxuawagxvhgmgr")
    public suspend fun parameters(`value`: List<InstanceParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument It has been deprecated from provider version 1.101.0 and `config` instead. See `parameters` below.
     */
    @Deprecated(
        message = """
  Field 'parameters' has been deprecated from version 1.101.0. Use 'config' instead.
  """,
    )
    @JvmName("acflwhiesuduodry")
    public suspend fun parameters(argument: List<suspend InstanceParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument It has been deprecated from provider version 1.101.0 and `config` instead. See `parameters` below.
     */
    @Deprecated(
        message = """
  Field 'parameters' has been deprecated from version 1.101.0. Use 'config' instead.
  """,
    )
    @JvmName("ucmidrcobnucmcuv")
    public suspend fun parameters(vararg argument: suspend InstanceParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstanceParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument It has been deprecated from provider version 1.101.0 and `config` instead. See `parameters` below.
     */
    @Deprecated(
        message = """
  Field 'parameters' has been deprecated from version 1.101.0. Use 'config' instead.
  """,
    )
    @JvmName("qycjidyuutvbmqds")
    public suspend fun parameters(argument: suspend InstanceParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InstanceParameterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values It has been deprecated from provider version 1.101.0 and `config` instead. See `parameters` below.
     */
    @Deprecated(
        message = """
  Field 'parameters' has been deprecated from version 1.101.0. Use 'config' instead.
  """,
    )
    @JvmName("eefrjnjcwckolcmq")
    public suspend fun parameters(vararg values: InstanceParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The password of the KVStore DBInstance. The password that is used to connect to the instance. The password must be 8 to 32 characters in length and must contain at least three of the following character types: uppercase letters, lowercase letters, special characters, and digits. Special characters include: `! @ # $ % ^ & * ( ) _ + - =`
     */
    @JvmName("pmffawomvejbihtj")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The billing method of the KVStore DBInstance. Valid values: `PrePaid`, `PostPaid`. Default value: `PostPaid`.
     */
    @JvmName("obcxouoxlxpcbcdi")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The duration that you will buy KVStore DBInstance (in month). It is valid when payment_type is `PrePaid`. Valid values: `[1~9]`, `12`, `24`, `36`.
     */
    @JvmName("qojbvnjmeqawcxbf")
    public suspend fun period(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value It has been deprecated from provider version 1.101.0 and resource `alicloud.kvstore.Connection` instead.
     */
    @JvmName("jppisfhefuepmhbt")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Private network connection port, used to modify the private network connection port.
     */
    @JvmName("rgklsdaxqmegnsya")
    public suspend fun privateConnectionPort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateConnectionPort = mapped
    }

    /**
     * @param value Private network connection prefix, used to modify the private network connection address. Only supports updating private network connections for existing instance.
     */
    @JvmName("wxviseaeyjbrputh")
    public suspend fun privateConnectionPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateConnectionPrefix = mapped
    }

    /**
     * @param value The internal IP address of the instance.
     */
    @JvmName("tntindyjmrvhxray")
    public suspend fun privateIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIp = mapped
    }

    /**
     * @param value The number of read replicas in the primary zone. Valid values: `1` to `9`.
     */
    @JvmName("xipbyppuwxuufwgd")
    public suspend fun readOnlyCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readOnlyCount = mapped
    }

    /**
     * @param value The ID of resource group which the resource belongs.
     */
    @JvmName("mbchyaauckorfnub")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The point in time of a backup file.
     */
    @JvmName("ncixhclhehcegjau")
    public suspend fun restoreTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restoreTime = mapped
    }

    /**
     * @param value The Specify the global resource descriptor ARN (Alibaba Cloud Resource Name) information of the role to be authorized, and use the related key management services after the authorization is completed, in the format: `acs:ram::$accountID:role/$roleName`.
     */
    @JvmName("drfqhyhjelavirhg")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The ID of the secondary zone to which you want to migrate the ApsaraDB for Redis instance.
     * > **NOTE:** If you specify this parameter, the master node and replica node of the instance can be deployed in different zones and disaster recovery is implemented across zones. The instance can withstand failures in data centers.
     */
    @JvmName("ehilpgvqcvlssleb")
    public suspend fun secondaryZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryZoneId = mapped
    }

    /**
     * @param value The ID of security groups. Separate multiple security group IDs with commas (,), such as `sg-***,sg-***,sg-***`.
     */
    @JvmName("qydhsliqjpumwtfd")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value The value of this parameter is empty by default. The attribute of the whitelist group. The console does not display the whitelist group whose value of this parameter is hidden.
     */
    @JvmName("flqiyxqwnjenrqdt")
    public suspend fun securityIpGroupAttribute(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityIpGroupAttribute = mapped
    }

    /**
     * @param value The name of the whitelist group.
     */
    @JvmName("sguedvfgdqidissp")
    public suspend fun securityIpGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityIpGroupName = mapped
    }

    /**
     * @param value The IP addresses in the whitelist group. The maximum number of IP addresses in the whitelist group is 1000.
     */
    @JvmName("qhvnwkpisfbibjul")
    public suspend fun securityIps(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityIps = mapped
    }

    /**
     * @param values The IP addresses in the whitelist group. The maximum number of IP addresses in the whitelist group is 1000.
     */
    @JvmName("fyrhjjsfcpgmfmas")
    public suspend fun securityIps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityIps = mapped
    }

    /**
     * @param value The number of data shards. This parameter is available only if you create a cluster instance that uses cloud disks. You can use this parameter to specify a custom number of data shards. **NOTE:** From version 1.216.0, `shard_count` can be modified.
     */
    @JvmName("ynhccydgomckeqxx")
    public suspend fun shardCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shardCount = mapped
    }

    /**
     * @param value The number of read replicas in the secondary zone. **NOTE:**: When you create a multi-zone read/write splitting instance, you must specify both `secondary_zone_id` and `slave_read_only_count`.
     * > **NOTE:** The sum of `read_only_count` and `slave_read_only_count` cannot be greater than `9`.
     */
    @JvmName("qcqcjfkvltbesamb")
    public suspend fun slaveReadOnlyCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slaveReadOnlyCount = mapped
    }

    /**
     * @param value The ID of the source instance.
     */
    @JvmName("hsxhdohwvaijxdos")
    public suspend fun srcdbInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.srcdbInstanceId = mapped
    }

    /**
     * @param value Modifies the SSL status. Valid values: `Disable`, `Enable` and `Update`.
     * **NOTE:** This functionality is supported by Cluster mode (Redis 2.8, 4.0, 5.0) and Standard mode( Redis 2.8 only).
     */
    @JvmName("qpxdtunvoqlqfpjy")
    public suspend fun sslEnable(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslEnable = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("ndiclvxteetkopmo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("omonvetqekmfejav")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies whether to enable TDE. Valid values: `Enabled`.
     * **NOTE:**: TDE cannot be disabled after it is enabled. Before you enable it, evaluate whether this feature affects.
     * your business. For more information, see [Enable TDE](https://www.alibabacloud.com/help/en/redis/user-guide/enable-tde).
     */
    @JvmName("hnedyfsdlfvtyvgt")
    public suspend fun tdeStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tdeStatus = mapped
    }

    /**
     * @param value Only meaningful if instance_type is `Redis` and network type is VPC. Valid values: `Close`, `Open`. Default value: `Open`. `Close` means the redis instance can be accessed without authentication. `Open` means authentication is required.
     */
    @JvmName("wdxnimvuysrayjnr")
    public suspend fun vpcAuthMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcAuthMode = mapped
    }

    /**
     * @param value The ID of VSwitch.
     */
    @JvmName("gmqqrpyhdroyhoxw")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The ID of the zone.
     */
    @JvmName("tqipavrfxtgexwaa")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        autoRenew = autoRenew,
        autoRenewPeriod = autoRenewPeriod,
        autoUseCoupon = autoUseCoupon,
        availabilityZone = availabilityZone,
        backupId = backupId,
        backupPeriods = backupPeriods,
        backupTime = backupTime,
        businessInfo = businessInfo,
        capacity = capacity,
        config = config,
        connectionStringPrefix = connectionStringPrefix,
        couponNo = couponNo,
        dbInstanceName = dbInstanceName,
        dedicatedHostGroupId = dedicatedHostGroupId,
        dryRun = dryRun,
        effectiveTime = effectiveTime,
        enableBackupLog = enableBackupLog,
        enablePublic = enablePublic,
        encryptionKey = encryptionKey,
        encryptionName = encryptionName,
        engineVersion = engineVersion,
        forceUpgrade = forceUpgrade,
        globalInstance = globalInstance,
        globalInstanceId = globalInstanceId,
        instanceChargeType = instanceChargeType,
        instanceClass = instanceClass,
        instanceName = instanceName,
        instanceReleaseProtection = instanceReleaseProtection,
        instanceType = instanceType,
        isAutoUpgradeOpen = isAutoUpgradeOpen,
        kmsEncryptedPassword = kmsEncryptedPassword,
        kmsEncryptionContext = kmsEncryptionContext,
        maintainEndTime = maintainEndTime,
        maintainStartTime = maintainStartTime,
        nodeType = nodeType,
        orderType = orderType,
        parameters = parameters,
        password = password,
        paymentType = paymentType,
        period = period,
        port = port,
        privateConnectionPort = privateConnectionPort,
        privateConnectionPrefix = privateConnectionPrefix,
        privateIp = privateIp,
        readOnlyCount = readOnlyCount,
        resourceGroupId = resourceGroupId,
        restoreTime = restoreTime,
        roleArn = roleArn,
        secondaryZoneId = secondaryZoneId,
        securityGroupId = securityGroupId,
        securityIpGroupAttribute = securityIpGroupAttribute,
        securityIpGroupName = securityIpGroupName,
        securityIps = securityIps,
        shardCount = shardCount,
        slaveReadOnlyCount = slaveReadOnlyCount,
        srcdbInstanceId = srcdbInstanceId,
        sslEnable = sslEnable,
        tags = tags,
        tdeStatus = tdeStatus,
        vpcAuthMode = vpcAuthMode,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
