@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kvstore.kotlin

import com.pulumi.alicloud.kvstore.KvstoreFunctions.getAccountsPlain
import com.pulumi.alicloud.kvstore.KvstoreFunctions.getConnectionsPlain
import com.pulumi.alicloud.kvstore.KvstoreFunctions.getInstanceClassesPlain
import com.pulumi.alicloud.kvstore.KvstoreFunctions.getInstanceEnginesPlain
import com.pulumi.alicloud.kvstore.KvstoreFunctions.getInstancesPlain
import com.pulumi.alicloud.kvstore.KvstoreFunctions.getPermissionPlain
import com.pulumi.alicloud.kvstore.KvstoreFunctions.getZonesPlain
import com.pulumi.alicloud.kvstore.kotlin.inputs.GetAccountsPlainArgs
import com.pulumi.alicloud.kvstore.kotlin.inputs.GetAccountsPlainArgsBuilder
import com.pulumi.alicloud.kvstore.kotlin.inputs.GetConnectionsPlainArgs
import com.pulumi.alicloud.kvstore.kotlin.inputs.GetConnectionsPlainArgsBuilder
import com.pulumi.alicloud.kvstore.kotlin.inputs.GetInstanceClassesPlainArgs
import com.pulumi.alicloud.kvstore.kotlin.inputs.GetInstanceClassesPlainArgsBuilder
import com.pulumi.alicloud.kvstore.kotlin.inputs.GetInstanceEnginesPlainArgs
import com.pulumi.alicloud.kvstore.kotlin.inputs.GetInstanceEnginesPlainArgsBuilder
import com.pulumi.alicloud.kvstore.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.alicloud.kvstore.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.alicloud.kvstore.kotlin.inputs.GetPermissionPlainArgs
import com.pulumi.alicloud.kvstore.kotlin.inputs.GetPermissionPlainArgsBuilder
import com.pulumi.alicloud.kvstore.kotlin.inputs.GetZonesPlainArgs
import com.pulumi.alicloud.kvstore.kotlin.inputs.GetZonesPlainArgsBuilder
import com.pulumi.alicloud.kvstore.kotlin.outputs.GetAccountsResult
import com.pulumi.alicloud.kvstore.kotlin.outputs.GetConnectionsResult
import com.pulumi.alicloud.kvstore.kotlin.outputs.GetInstanceClassesResult
import com.pulumi.alicloud.kvstore.kotlin.outputs.GetInstanceEnginesResult
import com.pulumi.alicloud.kvstore.kotlin.outputs.GetInstancesResult
import com.pulumi.alicloud.kvstore.kotlin.outputs.GetPermissionResult
import com.pulumi.alicloud.kvstore.kotlin.outputs.GetZonesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.kvstore.kotlin.outputs.GetAccountsResult.Companion.toKotlin as getAccountsResultToKotlin
import com.pulumi.alicloud.kvstore.kotlin.outputs.GetConnectionsResult.Companion.toKotlin as getConnectionsResultToKotlin
import com.pulumi.alicloud.kvstore.kotlin.outputs.GetInstanceClassesResult.Companion.toKotlin as getInstanceClassesResultToKotlin
import com.pulumi.alicloud.kvstore.kotlin.outputs.GetInstanceEnginesResult.Companion.toKotlin as getInstanceEnginesResultToKotlin
import com.pulumi.alicloud.kvstore.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.alicloud.kvstore.kotlin.outputs.GetPermissionResult.Companion.toKotlin as getPermissionResultToKotlin
import com.pulumi.alicloud.kvstore.kotlin.outputs.GetZonesResult.Companion.toKotlin as getZonesResultToKotlin

public object KvstoreFunctions {
    /**
     * This data source provides the KVStore Accounts of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.102.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.kvstore.getAccounts({
     *     instanceId: "example_value",
     * });
     * export const firstKvstoreAccountId = example.then(example => example.accounts?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.kvstore.get_accounts(instance_id="example_value")
     * pulumi.export("firstKvstoreAccountId", example.accounts[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.KVStore.GetAccounts.Invoke(new()
     *     {
     *         InstanceId = "example_value",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstKvstoreAccountId"] = example&#46;Apply(getAccountsResult => getAccountsResult&#46;Accounts[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kvstore"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := kvstore.GetAccounts(ctx, &kvstore.GetAccountsArgs{
     * 			InstanceId: "example_value",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstKvstoreAccountId", example.Accounts[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.kvstore.KvstoreFunctions;
     * import com.pulumi.alicloud.kvstore.inputs.GetAccountsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = KvstoreFunctions.getAccounts(GetAccountsArgs.builder()
     *             .instanceId("example_value")
     *             .build());
     *         ctx.export("firstKvstoreAccountId", example.applyValue(getAccountsResult -> getAccountsResult.accounts()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:kvstore:getAccounts
     *       Arguments:
     *         instanceId: example_value
     * outputs:
     *   firstKvstoreAccountId: ${example.accounts[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAccounts.
     * @return A collection of values returned by getAccounts.
     */
    public suspend fun getAccounts(argument: GetAccountsPlainArgs): GetAccountsResult =
        getAccountsResultToKotlin(getAccountsPlain(argument.toJava()).await())

    /**
     * @see [getAccounts].
     * @param accountName The name of the account.
     * @param instanceId The Id of instance in which account belongs.
     * @param nameRegex
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of KVStore Account. Valid Values: `"Available` `Unavailable`
     * @return A collection of values returned by getAccounts.
     */
    public suspend fun getAccounts(
        accountName: String? = null,
        instanceId: String,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetAccountsResult {
        val argument = GetAccountsPlainArgs(
            accountName = accountName,
            instanceId = instanceId,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getAccountsResultToKotlin(getAccountsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccounts].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;kvstore&#46;kotlin&#46;inputs&#46;GetAccountsPlainArgs].
     * @return A collection of values returned by getAccounts.
     */
    public suspend fun getAccounts(argument: suspend GetAccountsPlainArgsBuilder.() -> Unit): GetAccountsResult {
        val builder = GetAccountsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccountsResultToKotlin(getAccountsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source can query the public IP of the specified KVStore DBInstance.
     * > **NOTE:** Available in v1.101.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const example = alicloud.kvstore.getConnections({
     *     ids: "r-wer123456",
     * });
     * export const connectionString = example.then(example => example.connections?.[0]?.connectionString);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * example = alicloud.kvstore.get_connections(ids="r-wer123456")
     * pulumi.export("connectionString", example.connections[0].connection_string)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var example = AliCloud.KVStore.GetConnections.Invoke(new()
     *     {
     *         Ids = "r-wer123456",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["connectionString"] = example&#46;Apply(getConnectionsResult => getConnectionsResult&#46;Connections[0]?.ConnectionString),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kvstore"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		example, err := kvstore.GetConnections(ctx, &kvstore.GetConnectionsArgs{
     * 			Ids: "r-wer123456",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("connectionString", example.Connections[0].ConnectionString)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.kvstore.KvstoreFunctions;
     * import com.pulumi.alicloud.kvstore.inputs.GetConnectionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var example = KvstoreFunctions.getConnections(GetConnectionsArgs.builder()
     *             .ids("r-wer123456")
     *             .build());
     *         ctx.export("connectionString", example.applyValue(getConnectionsResult -> getConnectionsResult.connections()[0].connectionString()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   example:
     *     fn::invoke:
     *       Function: alicloud:kvstore:getConnections
     *       Arguments:
     *         ids: r-wer123456
     * outputs:
     *   connectionString: ${example.connections[0].connectionString}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getConnections.
     * @return A collection of values returned by getConnections.
     */
    public suspend fun getConnections(argument: GetConnectionsPlainArgs): GetConnectionsResult =
        getConnectionsResultToKotlin(getConnectionsPlain(argument.toJava()).await())

    /**
     * @see [getConnections].
     * @param ids A list of KVStore DBInstance ids, only support one item.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getConnections.
     */
    public suspend fun getConnections(ids: String, outputFile: String? = null): GetConnectionsResult {
        val argument = GetConnectionsPlainArgs(
            ids = ids,
            outputFile = outputFile,
        )
        return getConnectionsResultToKotlin(getConnectionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnections].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;kvstore&#46;kotlin&#46;inputs&#46;GetConnectionsPlainArgs].
     * @return A collection of values returned by getConnections.
     */
    public suspend fun getConnections(argument: suspend GetConnectionsPlainArgsBuilder.() -> Unit): GetConnectionsResult {
        val builder = GetConnectionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectionsResultToKotlin(getConnectionsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the KVStore instance classes resource available info of Alibaba Cloud.
     * > **NOTE:** Available since v1.49.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const resources = alicloud.getZones({
     *     availableResourceCreation: "KVStore",
     * });
     * const resourcesGetInstanceClasses = resources.then(resources => alicloud.kvstore.getInstanceClasses({
     *     zoneId: resources.zones?.[0]?.id,
     *     instanceChargeType: "PrePaid",
     *     engine: "Redis",
     *     engineVersion: "5.0",
     *     outputFile: "./classes.txt",
     * }));
     * export const firstKvstoreInstanceClass = resourcesGetInstanceClasses.then(resourcesGetInstanceClasses => resourcesGetInstanceClasses.instanceClasses);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * resources = alicloud.get_zones(available_resource_creation="KVStore")
     * resources_get_instance_classes = alicloud.kvstore.get_instance_classes(zone_id=resources.zones[0].id,
     *     instance_charge_type="PrePaid",
     *     engine="Redis",
     *     engine_version="5.0",
     *     output_file="./classes.txt")
     * pulumi.export("firstKvstoreInstanceClass", resources_get_instance_classes.instance_classes)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var resources = AliCloud.GetZones.Invoke(new()
     *     {
     *         AvailableResourceCreation = "KVStore",
     *     });
     *     var resourcesGetInstanceClasses = AliCloud.KVStore.GetInstanceClasses.Invoke(new()
     *     {
     *         ZoneId = resources.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
     *         InstanceChargeType = "PrePaid",
     *         Engine = "Redis",
     *         EngineVersion = "5.0",
     *         OutputFile = "./classes.txt",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstKvstoreInstanceClass"] = resourcesGetInstanceClasses.Apply(getInstanceClassesResult => getInstanceClassesResult.InstanceClasses),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kvstore"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		resources, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
     * 			AvailableResourceCreation: pulumi.StringRef("KVStore"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		resourcesGetInstanceClasses, err := kvstore.GetInstanceClasses(ctx, &kvstore.GetInstanceClassesArgs{
     * 			ZoneId:             resources.Zones[0].Id,
     * 			InstanceChargeType: pulumi.StringRef("PrePaid"),
     * 			Engine:             pulumi.StringRef("Redis"),
     * 			EngineVersion:      pulumi.StringRef("5.0"),
     * 			OutputFile:         pulumi.StringRef("./classes.txt"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstKvstoreInstanceClass", resourcesGetInstanceClasses.InstanceClasses)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.AlicloudFunctions;
     * import com.pulumi.alicloud.inputs.GetZonesArgs;
     * import com.pulumi.alicloud.kvstore.KvstoreFunctions;
     * import com.pulumi.alicloud.kvstore.inputs.GetInstanceClassesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var resources = AlicloudFunctions.getZones(GetZonesArgs.builder()
     *             .availableResourceCreation("KVStore")
     *             .build());
     *         final var resourcesGetInstanceClasses = KvstoreFunctions.getInstanceClasses(GetInstanceClassesArgs.builder()
     *             .zoneId(resources.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
     *             .instanceChargeType("PrePaid")
     *             .engine("Redis")
     *             .engineVersion("5.0")
     *             .outputFile("./classes.txt")
     *             .build());
     *         ctx.export("firstKvstoreInstanceClass", resourcesGetInstanceClasses.applyValue(getInstanceClassesResult -> getInstanceClassesResult.instanceClasses()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   resources:
     *     fn::invoke:
     *       Function: alicloud:getZones
     *       Arguments:
     *         availableResourceCreation: KVStore
     *   resourcesGetInstanceClasses:
     *     fn::invoke:
     *       Function: alicloud:kvstore:getInstanceClasses
     *       Arguments:
     *         zoneId: ${resources.zones[0].id}
     *         instanceChargeType: PrePaid
     *         engine: Redis
     *         engineVersion: '5.0'
     *         outputFile: ./classes.txt
     * outputs:
     *   firstKvstoreInstanceClass: ${resourcesGetInstanceClasses.instanceClasses}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstanceClasses.
     * @return A collection of values returned by getInstanceClasses.
     */
    public suspend fun getInstanceClasses(argument: GetInstanceClassesPlainArgs): GetInstanceClassesResult =
        getInstanceClassesResultToKotlin(getInstanceClassesPlain(argument.toJava()).await())

    /**
     * @see [getInstanceClasses].
     * @param architecture The KVStore instance system architecture required by the user. Valid values: `standard`, `cluster` and `rwsplit`.
     * @param editionType The KVStore instance edition type required by the user. Valid values: `Community` and `Enterprise`.
     * @param engine Database type. Options are `Redis`, `Memcache`. Default to `Redis`.
     * @param engineVersion Database version required by the user. Value options of Redis can refer to the latest docs [detail info](https://www.alibabacloud.com/help/doc-detail/60873.htm) `EngineVersion`. Value of Memcache should be empty.
     * @param instanceChargeType Filter the results by charge type. Valid values: `PrePaid` and `PostPaid`. Default to `PrePaid`.
     * @param nodeType The KVStore instance node type required by the user. Valid values: `double`, `single`, `readone`, `readthree` and `readfive`.
     * @param outputFile File name where to save data source results (after running `pulumi up`).
     * @param packageType It has been deprecated from 1.68.0.
     * @param performanceType It has been deprecated from 1.68.0.
     * @param productType
     * @param seriesType The KVStore instance series type required by the user. Valid values: `enhanced_performance_type` and `hybrid_storage`.
     * @param shardNumber The number of shard.Valid values: `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`.
     * * product_type - (Optional, Available since 1.130.0) The type of the service. Valid values:
     * * Local: an ApsaraDB for Redis instance with a local disk.
     * * OnECS: an ApsaraDB for Redis instance with a standard disk. This type is available only on the Alibaba Cloud China site.
     * @param sortedBy
     * @param storageType It has been deprecated from 1.68.0.
     * @param zoneId The Zone to launch the KVStore instance.
     * @return A collection of values returned by getInstanceClasses.
     */
    public suspend fun getInstanceClasses(
        architecture: String? = null,
        editionType: String? = null,
        engine: String? = null,
        engineVersion: String? = null,
        instanceChargeType: String? = null,
        nodeType: String? = null,
        outputFile: String? = null,
        packageType: String? = null,
        performanceType: String? = null,
        productType: String? = null,
        seriesType: String? = null,
        shardNumber: Int? = null,
        sortedBy: String? = null,
        storageType: String? = null,
        zoneId: String,
    ): GetInstanceClassesResult {
        val argument = GetInstanceClassesPlainArgs(
            architecture = architecture,
            editionType = editionType,
            engine = engine,
            engineVersion = engineVersion,
            instanceChargeType = instanceChargeType,
            nodeType = nodeType,
            outputFile = outputFile,
            packageType = packageType,
            performanceType = performanceType,
            productType = productType,
            seriesType = seriesType,
            shardNumber = shardNumber,
            sortedBy = sortedBy,
            storageType = storageType,
            zoneId = zoneId,
        )
        return getInstanceClassesResultToKotlin(getInstanceClassesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceClasses].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;kvstore&#46;kotlin&#46;inputs&#46;GetInstanceClassesPlainArgs].
     * @return A collection of values returned by getInstanceClasses.
     */
    public suspend fun getInstanceClasses(argument: suspend GetInstanceClassesPlainArgsBuilder.() -> Unit): GetInstanceClassesResult {
        val builder = GetInstanceClassesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceClassesResultToKotlin(getInstanceClassesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the KVStore instance engines resource available info of Alibaba Cloud.
     * > **NOTE:** Available since v1.51.0
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const resources = alicloud.getZones({
     *     availableResourceCreation: "KVStore",
     * });
     * const resourcesGetInstanceEngines = resources.then(resources => alicloud.kvstore.getInstanceEngines({
     *     zoneId: resources.zones?.[0]?.id,
     *     instanceChargeType: "PrePaid",
     *     engine: "Redis",
     *     engineVersion: "5.0",
     *     outputFile: "./engines.txt",
     * }));
     * export const firstKvstoreInstanceClass = resourcesGetInstanceEngines.then(resourcesGetInstanceEngines => resourcesGetInstanceEngines.instanceEngines?.[0]?.engine);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * resources = alicloud.get_zones(available_resource_creation="KVStore")
     * resources_get_instance_engines = alicloud.kvstore.get_instance_engines(zone_id=resources.zones[0].id,
     *     instance_charge_type="PrePaid",
     *     engine="Redis",
     *     engine_version="5.0",
     *     output_file="./engines.txt")
     * pulumi.export("firstKvstoreInstanceClass", resources_get_instance_engines.instance_engines[0].engine)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var resources = AliCloud.GetZones.Invoke(new()
     *     {
     *         AvailableResourceCreation = "KVStore",
     *     });
     *     var resourcesGetInstanceEngines = AliCloud.KVStore.GetInstanceEngines.Invoke(new()
     *     {
     *         ZoneId = resources.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
     *         InstanceChargeType = "PrePaid",
     *         Engine = "Redis",
     *         EngineVersion = "5.0",
     *         OutputFile = "./engines.txt",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstKvstoreInstanceClass"] = resourcesGetInstanceEngines&#46;Apply(getInstanceEnginesResult => getInstanceEnginesResult&#46;InstanceEngines[0]?.Engine),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kvstore"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		resources, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
     * 			AvailableResourceCreation: pulumi.StringRef("KVStore"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		resourcesGetInstanceEngines, err := kvstore.GetInstanceEngines(ctx, &kvstore.GetInstanceEnginesArgs{
     * 			ZoneId:             resources.Zones[0].Id,
     * 			InstanceChargeType: pulumi.StringRef("PrePaid"),
     * 			Engine:             pulumi.StringRef("Redis"),
     * 			EngineVersion:      pulumi.StringRef("5.0"),
     * 			OutputFile:         pulumi.StringRef("./engines.txt"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstKvstoreInstanceClass", resourcesGetInstanceEngines.InstanceEngines[0].Engine)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.AlicloudFunctions;
     * import com.pulumi.alicloud.inputs.GetZonesArgs;
     * import com.pulumi.alicloud.kvstore.KvstoreFunctions;
     * import com.pulumi.alicloud.kvstore.inputs.GetInstanceEnginesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var resources = AlicloudFunctions.getZones(GetZonesArgs.builder()
     *             .availableResourceCreation("KVStore")
     *             .build());
     *         final var resourcesGetInstanceEngines = KvstoreFunctions.getInstanceEngines(GetInstanceEnginesArgs.builder()
     *             .zoneId(resources.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
     *             .instanceChargeType("PrePaid")
     *             .engine("Redis")
     *             .engineVersion("5.0")
     *             .outputFile("./engines.txt")
     *             .build());
     *         ctx.export("firstKvstoreInstanceClass", resourcesGetInstanceEngines.applyValue(getInstanceEnginesResult -> getInstanceEnginesResult.instanceEngines()[0].engine()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   resources:
     *     fn::invoke:
     *       Function: alicloud:getZones
     *       Arguments:
     *         availableResourceCreation: KVStore
     *   resourcesGetInstanceEngines:
     *     fn::invoke:
     *       Function: alicloud:kvstore:getInstanceEngines
     *       Arguments:
     *         zoneId: ${resources.zones[0].id}
     *         instanceChargeType: PrePaid
     *         engine: Redis
     *         engineVersion: '5.0'
     *         outputFile: ./engines.txt
     * outputs:
     *   firstKvstoreInstanceClass: ${resourcesGetInstanceEngines.instanceEngines[0].engine}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstanceEngines.
     * @return A collection of values returned by getInstanceEngines.
     */
    public suspend fun getInstanceEngines(argument: GetInstanceEnginesPlainArgs): GetInstanceEnginesResult =
        getInstanceEnginesResultToKotlin(getInstanceEnginesPlain(argument.toJava()).await())

    /**
     * @see [getInstanceEngines].
     * @param engine Database type. Options are `Redis`, `Memcache`. Default to `Redis`.
     * @param engineVersion Database version required by the user. Value options of Redis can refer to the latest docs [detail info](https://www.alibabacloud.com/help/doc-detail/60873.htm) `EngineVersion`. Value of Memcache should be empty.
     * @param instanceChargeType Filter the results by charge type. Valid values: `PrePaid` and `PostPaid`. Default to `PrePaid`.
     * @param outputFile File name where to save data source results (after running `pulumi up`).
     * @param zoneId The Zone to launch the KVStore instance.
     * @return A collection of values returned by getInstanceEngines.
     */
    public suspend fun getInstanceEngines(
        engine: String? = null,
        engineVersion: String? = null,
        instanceChargeType: String? = null,
        outputFile: String? = null,
        zoneId: String,
    ): GetInstanceEnginesResult {
        val argument = GetInstanceEnginesPlainArgs(
            engine = engine,
            engineVersion = engineVersion,
            instanceChargeType = instanceChargeType,
            outputFile = outputFile,
            zoneId = zoneId,
        )
        return getInstanceEnginesResultToKotlin(getInstanceEnginesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceEngines].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;kvstore&#46;kotlin&#46;inputs&#46;GetInstanceEnginesPlainArgs].
     * @return A collection of values returned by getInstanceEngines.
     */
    public suspend fun getInstanceEngines(argument: suspend GetInstanceEnginesPlainArgsBuilder.() -> Unit): GetInstanceEnginesResult {
        val builder = GetInstanceEnginesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceEnginesResultToKotlin(getInstanceEnginesPlain(builtArgument.toJava()).await())
    }

    /**
     * The `alicloud.kvstore.getInstances` data source provides a collection of kvstore instances available in Alicloud account.
     * Filters support regular expression for the instance name, searches by tags, and other filters which are listed below.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.kvstore.getInstances({
     *     nameRegex: "testname",
     * });
     * export const firstInstanceName = _default.then(_default => _default.instances?.[0]?.name);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.kvstore.get_instances(name_regex="testname")
     * pulumi.export("firstInstanceName", default.instances[0].name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.KVStore.GetInstances.Invoke(new()
     *     {
     *         NameRegex = "testname",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstInstanceName"] = @default&#46;Apply(@default => @default&#46;Apply(getInstancesResult => getInstancesResult&#46;Instances[0]?.Name)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kvstore"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := kvstore.GetInstances(ctx, &kvstore.GetInstancesArgs{
     * 			NameRegex: pulumi.StringRef("testname"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstInstanceName", _default.Instances[0].Name)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.kvstore.KvstoreFunctions;
     * import com.pulumi.alicloud.kvstore.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = KvstoreFunctions.getInstances(GetInstancesArgs.builder()
     *             .nameRegex("testname")
     *             .build());
     *         ctx.export("firstInstanceName", default_.instances()[0].name());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:kvstore:getInstances
     *       Arguments:
     *         nameRegex: testname
     * outputs:
     *   firstInstanceName: ${default.instances[0].name}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param architectureType The type of the architecture. Valid values: `cluster`, `standard` and `SplitRW`.
     * @param editionType Used to retrieve instances belong to specified `vswitch` resources.  Valid values: `Enterprise`, `Community`.
     * @param enableDetails Default to `false`. Set it to true can output more details.
     * @param engineVersion The engine version. Valid values: `2.8`, `4.0`, `5.0`, `6.0`, `7.0`.
     * @param expired The expiration status of the instance.
     * @param globalInstance Whether to create a distributed cache.
     * @param ids A list of KVStore DBInstance IDs.
     * @param instanceClass Type of the applied ApsaraDB for Redis instance. For more information, see [Instance type table](https://help.aliyun.com/zh/redis/developer-reference/instance-types).
     * @param instanceType The engine type of the KVStore DBInstance. Options are `Memcache`, and `Redis`. If no value is specified, all types are returned.
     * @param nameRegex A regex string to apply to the instance name.
     * @param networkType The type of the network. Valid values: `CLASSIC`, `VPC`.
     * @param outputFile The name of file that can save the collection of instances after running `pulumi preview`.
     * @param paymentType The payment type. Valid values: `PostPaid`, `PrePaid`.
     * @param resourceGroupId The ID of the resource group.
     * @param searchKey The name of the instance.
     * @param status The status of the KVStore DBInstance. Valid values: `Changing`, `CleaningUpExpiredData`, `Creating`, `Flushing`, `HASwitching`, `Inactive`, `MajorVersionUpgrading`, `Migrating`, `NetworkModifying`, `Normal`, `Rebooting`, `SSLModifying`, `Transforming`, `ZoneMigrating`.
     * @param tags Query the instance bound to the tag. The format of the incoming value is `json` string, including `TagKey` and `TagValue`. `TagKey` cannot be null, and `TagValue` can be empty. Format example `{"key1":"value1"}`.
     * @param vpcId Used to retrieve instances belong to specified VPC.
     * @param vswitchId Used to retrieve instances belong to specified `vswitch` resources.
     * @param zoneId The ID of the zone.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(
        architectureType: String? = null,
        editionType: String? = null,
        enableDetails: Boolean? = null,
        engineVersion: String? = null,
        expired: String? = null,
        globalInstance: Boolean? = null,
        ids: List<String>? = null,
        instanceClass: String? = null,
        instanceType: String? = null,
        nameRegex: String? = null,
        networkType: String? = null,
        outputFile: String? = null,
        paymentType: String? = null,
        resourceGroupId: String? = null,
        searchKey: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
        vswitchId: String? = null,
        zoneId: String? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            architectureType = architectureType,
            editionType = editionType,
            enableDetails = enableDetails,
            engineVersion = engineVersion,
            expired = expired,
            globalInstance = globalInstance,
            ids = ids,
            instanceClass = instanceClass,
            instanceType = instanceType,
            nameRegex = nameRegex,
            networkType = networkType,
            outputFile = outputFile,
            paymentType = paymentType,
            resourceGroupId = resourceGroupId,
            searchKey = searchKey,
            status = status,
            tags = tags,
            vpcId = vpcId,
            vswitchId = vswitchId,
            zoneId = zoneId,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;kvstore&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * Assigns a RAM role to ApsaraDB for Redis.
     * The log management feature of ApsaraDB for Redis requires the resources of [Log Service](https://www.alibabacloud.com/help/doc-detail/48869.htm).
     * To use the log management feature of ApsaraDB for Redis, you can call this operation to associate the RAM role named AliyunServiceRoleForKvstore with the ApsaraDB for Redis instance.
     * For more information, see [Associated RAM roles of ApsaraDB for Redis](https://www.alibabacloud.com/help/doc-detail/184337.htm)
     * > **NOTE:** Available since v1.128.0
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.kvstore.getPermission({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.kvstore.get_permission(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.KVStore.GetPermission.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kvstore"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := kvstore.GetPermission(ctx, &kvstore.GetPermissionArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.kvstore.KvstoreFunctions;
     * import com.pulumi.alicloud.kvstore.inputs.GetPermissionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = KvstoreFunctions.getPermission(GetPermissionArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:kvstore:getPermission
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPermission.
     * @return A collection of values returned by getPermission.
     */
    public suspend fun getPermission(argument: GetPermissionPlainArgs): GetPermissionResult =
        getPermissionResultToKotlin(getPermissionPlain(argument.toJava()).await())

    /**
     * @see [getPermission].
     * @param enable Setting the value to `On` to assigns a RAM role to ApsaraDB for Redis. If has been enabled, return the result. Valid values: "On" or "Off". Default to "Off".
     * @return A collection of values returned by getPermission.
     */
    public suspend fun getPermission(enable: String? = null): GetPermissionResult {
        val argument = GetPermissionPlainArgs(
            enable = enable,
        )
        return getPermissionResultToKotlin(getPermissionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPermission].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;kvstore&#46;kotlin&#46;inputs&#46;GetPermissionPlainArgs].
     * @return A collection of values returned by getPermission.
     */
    public suspend fun getPermission(argument: suspend GetPermissionPlainArgsBuilder.() -> Unit): GetPermissionResult {
        val builder = GetPermissionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPermissionResultToKotlin(getPermissionPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides availability zones for KVStore that can be accessed by an Alibaba Cloud account within the region configured in the provider.
     * > **NOTE:** Available since v1.73.0.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const zonesIds = alicloud.kvstore.getZones({
     *     instanceChargeType: "PostPaid",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * zones_ids = alicloud.kvstore.get_zones(instance_charge_type="PostPaid")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var zonesIds = AliCloud.KVStore.GetZones.Invoke(new()
     *     {
     *         InstanceChargeType = "PostPaid",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kvstore"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		_, err := kvstore.GetZones(ctx, &kvstore.GetZonesArgs{
     * 			InstanceChargeType: pulumi.StringRef("PostPaid"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.kvstore.KvstoreFunctions;
     * import com.pulumi.alicloud.kvstore.inputs.GetZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var zonesIds = KvstoreFunctions.getZones(GetZonesArgs.builder()
     *             .instanceChargeType("PostPaid")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   zonesIds:
     *     fn::invoke:
     *       Function: alicloud:kvstore:getZones
     *       Arguments:
     *         instanceChargeType: PostPaid
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getZones.
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: GetZonesPlainArgs): GetZonesResult =
        getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())

    /**
     * @see [getZones].
     * @param engine Database type. Options are `Redis`, `Memcache`. Default to `Redis`.
     * * product_type - (Optional, Available since v1.130.0+) The type of the service. Valid values: `Local`, `Tair_rdb`, `Tair_scm`, `Tair_essd`, `OnECS`.
     * @param instanceChargeType Filter the results by a specific instance charge type. Valid values: `PrePaid` and `PostPaid`. Default to `PostPaid`.
     * @param multi Indicate whether the zones can be used in a multi AZ configuration. Default to `false`. Multi AZ is usually used to launch KVStore instances.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param productType
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(
        engine: String? = null,
        instanceChargeType: String? = null,
        multi: Boolean? = null,
        outputFile: String? = null,
        productType: String? = null,
    ): GetZonesResult {
        val argument = GetZonesPlainArgs(
            engine = engine,
            instanceChargeType = instanceChargeType,
            multi = multi,
            outputFile = outputFile,
            productType = productType,
        )
        return getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getZones].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;kvstore&#46;kotlin&#46;inputs&#46;GetZonesPlainArgs].
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: suspend GetZonesPlainArgsBuilder.() -> Unit): GetZonesResult {
        val builder = GetZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getZonesResultToKotlin(getZonesPlain(builtArgument.toJava()).await())
    }
}
