@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kvstore.kotlin.inputs

import com.pulumi.alicloud.kvstore.inputs.GetAccountsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAccounts.
 * @property accountName The name of the account.
 * @property instanceId The Id of instance in which account belongs.
 * @property nameRegex
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of KVStore Account. Valid Values: `"Available` `Unavailable`
 */
public data class GetAccountsPlainArgs(
    public val accountName: String? = null,
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.kvstore.inputs.GetAccountsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.kvstore.inputs.GetAccountsPlainArgs =
        com.pulumi.alicloud.kvstore.inputs.GetAccountsPlainArgs.builder()
            .accountName(accountName?.let({ args0 -> args0 }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccountsPlainArgs].
 */
@PulumiTagMarker
public class GetAccountsPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var instanceId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value The name of the account.
     */
    @JvmName("oljvgqrucrcbaaqj")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The Id of instance in which account belongs.
     */
    @JvmName("wdqhbnckkxsgcopp")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value
     */
    @JvmName("ydouuytikehiiejc")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("sqtggnvpsiechgom")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of KVStore Account. Valid Values: `"Available` `Unavailable`
     */
    @JvmName("qbyrifbhhgfofree")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetAccountsPlainArgs = GetAccountsPlainArgs(
        accountName = accountName,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
