@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kvstore.kotlin.inputs

import com.pulumi.alicloud.kvstore.inputs.GetConnectionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getConnections.
 * @property ids A list of KVStore DBInstance ids, only support one item.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetConnectionsPlainArgs(
    public val ids: String,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.kvstore.inputs.GetConnectionsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.kvstore.inputs.GetConnectionsPlainArgs =
        com.pulumi.alicloud.kvstore.inputs.GetConnectionsPlainArgs.builder()
            .ids(ids.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConnectionsPlainArgs].
 */
@PulumiTagMarker
public class GetConnectionsPlainArgsBuilder internal constructor() {
    private var ids: String? = null

    private var outputFile: String? = null

    /**
     * @param value A list of KVStore DBInstance ids, only support one item.
     */
    @JvmName("kqrmgdhhpswbjhrk")
    public suspend fun ids(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("sgjdbgjgloyvwven")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetConnectionsPlainArgs = GetConnectionsPlainArgs(
        ids = ids ?: throw PulumiNullFieldException("ids"),
        outputFile = outputFile,
    )
}
