@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kvstore.kotlin.inputs

import com.pulumi.alicloud.kvstore.inputs.GetInstanceClassesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstanceClasses.
 * @property architecture The KVStore instance system architecture required by the user. Valid values: `standard`, `cluster` and `rwsplit`.
 * @property editionType The KVStore instance edition type required by the user. Valid values: `Community` and `Enterprise`.
 * @property engine Database type. Options are `Redis`, `Memcache`. Default to `Redis`.
 * @property engineVersion Database version required by the user. Value options of Redis can refer to the latest docs [detail info](https://www.alibabacloud.com/help/doc-detail/60873.htm) `EngineVersion`. Value of Memcache should be empty.
 * @property instanceChargeType Filter the results by charge type. Valid values: `PrePaid` and `PostPaid`. Default to `PrePaid`.
 * @property nodeType The KVStore instance node type required by the user. Valid values: `double`, `single`, `readone`, `readthree` and `readfive`.
 * @property outputFile File name where to save data source results (after running `pulumi up`).
 * @property packageType It has been deprecated from 1.68.0.
 * @property performanceType It has been deprecated from 1.68.0.
 * @property productType
 * @property seriesType The KVStore instance series type required by the user. Valid values: `enhanced_performance_type` and `hybrid_storage`.
 * @property shardNumber The number of shard.Valid values: `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`.
 * * product_type - (Optional, Available since 1.130.0) The type of the service. Valid values:
 * * Local: an ApsaraDB for Redis instance with a local disk.
 * * OnECS: an ApsaraDB for Redis instance with a standard disk. This type is available only on the Alibaba Cloud China site.
 * @property sortedBy
 * @property storageType It has been deprecated from 1.68.0.
 * @property zoneId The Zone to launch the KVStore instance.
 */
public data class GetInstanceClassesPlainArgs(
    public val architecture: String? = null,
    public val editionType: String? = null,
    public val engine: String? = null,
    public val engineVersion: String? = null,
    public val instanceChargeType: String? = null,
    public val nodeType: String? = null,
    public val outputFile: String? = null,
    @Deprecated(
        message = """
  The parameter 'package_type' has been deprecated from 1.68.0.
  """,
    )
    public val packageType: String? = null,
    @Deprecated(
        message = """
  The parameter 'performance_type' has been deprecated from 1.68.0.
  """,
    )
    public val performanceType: String? = null,
    public val productType: String? = null,
    public val seriesType: String? = null,
    public val shardNumber: Int? = null,
    public val sortedBy: String? = null,
    @Deprecated(
        message = """
  The parameter 'storage_type' has been deprecated from 1.68.0.
  """,
    )
    public val storageType: String? = null,
    public val zoneId: String,
) : ConvertibleToJava<com.pulumi.alicloud.kvstore.inputs.GetInstanceClassesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.kvstore.inputs.GetInstanceClassesPlainArgs =
        com.pulumi.alicloud.kvstore.inputs.GetInstanceClassesPlainArgs.builder()
            .architecture(architecture?.let({ args0 -> args0 }))
            .editionType(editionType?.let({ args0 -> args0 }))
            .engine(engine?.let({ args0 -> args0 }))
            .engineVersion(engineVersion?.let({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType?.let({ args0 -> args0 }))
            .nodeType(nodeType?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .packageType(packageType?.let({ args0 -> args0 }))
            .performanceType(performanceType?.let({ args0 -> args0 }))
            .productType(productType?.let({ args0 -> args0 }))
            .seriesType(seriesType?.let({ args0 -> args0 }))
            .shardNumber(shardNumber?.let({ args0 -> args0 }))
            .sortedBy(sortedBy?.let({ args0 -> args0 }))
            .storageType(storageType?.let({ args0 -> args0 }))
            .zoneId(zoneId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstanceClassesPlainArgs].
 */
@PulumiTagMarker
public class GetInstanceClassesPlainArgsBuilder internal constructor() {
    private var architecture: String? = null

    private var editionType: String? = null

    private var engine: String? = null

    private var engineVersion: String? = null

    private var instanceChargeType: String? = null

    private var nodeType: String? = null

    private var outputFile: String? = null

    private var packageType: String? = null

    private var performanceType: String? = null

    private var productType: String? = null

    private var seriesType: String? = null

    private var shardNumber: Int? = null

    private var sortedBy: String? = null

    private var storageType: String? = null

    private var zoneId: String? = null

    /**
     * @param value The KVStore instance system architecture required by the user. Valid values: `standard`, `cluster` and `rwsplit`.
     */
    @JvmName("fvcjduhfxrrwmsti")
    public suspend fun architecture(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.architecture = mapped
    }

    /**
     * @param value The KVStore instance edition type required by the user. Valid values: `Community` and `Enterprise`.
     */
    @JvmName("qoynevvghiueulkb")
    public suspend fun editionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.editionType = mapped
    }

    /**
     * @param value Database type. Options are `Redis`, `Memcache`. Default to `Redis`.
     */
    @JvmName("hojhayrkaadosyvs")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.engine = mapped
    }

    /**
     * @param value Database version required by the user. Value options of Redis can refer to the latest docs [detail info](https://www.alibabacloud.com/help/doc-detail/60873.htm) `EngineVersion`. Value of Memcache should be empty.
     */
    @JvmName("rwcwaogwfjckinbg")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.engineVersion = mapped
    }

    /**
     * @param value Filter the results by charge type. Valid values: `PrePaid` and `PostPaid`. Default to `PrePaid`.
     */
    @JvmName("hnwnawkrkutrkjdj")
    public suspend fun instanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceChargeType = mapped
    }

    /**
     * @param value The KVStore instance node type required by the user. Valid values: `double`, `single`, `readone`, `readthree` and `readfive`.
     */
    @JvmName("esdjaediurqshmtj")
    public suspend fun nodeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nodeType = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi up`).
     */
    @JvmName("qjjwmqlnhnsbuumv")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value It has been deprecated from 1.68.0.
     */
    @Deprecated(
        message = """
  The parameter 'package_type' has been deprecated from 1.68.0.
  """,
    )
    @JvmName("sdlmdfqqxbhitxrk")
    public suspend fun packageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.packageType = mapped
    }

    /**
     * @param value It has been deprecated from 1.68.0.
     */
    @Deprecated(
        message = """
  The parameter 'performance_type' has been deprecated from 1.68.0.
  """,
    )
    @JvmName("pjkdyenntbeskfmc")
    public suspend fun performanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.performanceType = mapped
    }

    /**
     * @param value
     */
    @JvmName("nlplvoktdtryukdp")
    public suspend fun productType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.productType = mapped
    }

    /**
     * @param value The KVStore instance series type required by the user. Valid values: `enhanced_performance_type` and `hybrid_storage`.
     */
    @JvmName("wiebvsotokbsiplf")
    public suspend fun seriesType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.seriesType = mapped
    }

    /**
     * @param value The number of shard.Valid values: `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`.
     * * product_type - (Optional, Available since 1.130.0) The type of the service. Valid values:
     * * Local: an ApsaraDB for Redis instance with a local disk.
     * * OnECS: an ApsaraDB for Redis instance with a standard disk. This type is available only on the Alibaba Cloud China site.
     */
    @JvmName("pitxkrofkkdeudpp")
    public suspend fun shardNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.shardNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("adkpdfoaxexdsadm")
    public suspend fun sortedBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sortedBy = mapped
    }

    /**
     * @param value It has been deprecated from 1.68.0.
     */
    @Deprecated(
        message = """
  The parameter 'storage_type' has been deprecated from 1.68.0.
  """,
    )
    @JvmName("vwdvhlsheyktkmrv")
    public suspend fun storageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.storageType = mapped
    }

    /**
     * @param value The Zone to launch the KVStore instance.
     */
    @JvmName("gkmyatnxwbnlknub")
    public suspend fun zoneId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.zoneId = mapped
    }

    internal fun build(): GetInstanceClassesPlainArgs = GetInstanceClassesPlainArgs(
        architecture = architecture,
        editionType = editionType,
        engine = engine,
        engineVersion = engineVersion,
        instanceChargeType = instanceChargeType,
        nodeType = nodeType,
        outputFile = outputFile,
        packageType = packageType,
        performanceType = performanceType,
        productType = productType,
        seriesType = seriesType,
        shardNumber = shardNumber,
        sortedBy = sortedBy,
        storageType = storageType,
        zoneId = zoneId ?: throw PulumiNullFieldException("zoneId"),
    )
}
