@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kvstore.kotlin.inputs

import com.pulumi.alicloud.kvstore.inputs.GetInstanceEnginesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstanceEngines.
 * @property engine Database type. Options are `Redis`, `Memcache`. Default to `Redis`.
 * @property engineVersion Database version required by the user. Value options of Redis can refer to the latest docs [detail info](https://www.alibabacloud.com/help/doc-detail/60873.htm) `EngineVersion`. Value of Memcache should be empty.
 * @property instanceChargeType Filter the results by charge type. Valid values: `PrePaid` and `PostPaid`. Default to `PrePaid`.
 * @property outputFile File name where to save data source results (after running `pulumi up`).
 * @property zoneId The Zone to launch the KVStore instance.
 */
public data class GetInstanceEnginesPlainArgs(
    public val engine: String? = null,
    public val engineVersion: String? = null,
    public val instanceChargeType: String? = null,
    public val outputFile: String? = null,
    public val zoneId: String,
) : ConvertibleToJava<com.pulumi.alicloud.kvstore.inputs.GetInstanceEnginesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.kvstore.inputs.GetInstanceEnginesPlainArgs =
        com.pulumi.alicloud.kvstore.inputs.GetInstanceEnginesPlainArgs.builder()
            .engine(engine?.let({ args0 -> args0 }))
            .engineVersion(engineVersion?.let({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .zoneId(zoneId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstanceEnginesPlainArgs].
 */
@PulumiTagMarker
public class GetInstanceEnginesPlainArgsBuilder internal constructor() {
    private var engine: String? = null

    private var engineVersion: String? = null

    private var instanceChargeType: String? = null

    private var outputFile: String? = null

    private var zoneId: String? = null

    /**
     * @param value Database type. Options are `Redis`, `Memcache`. Default to `Redis`.
     */
    @JvmName("pgjehtbcllbnxrmo")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.engine = mapped
    }

    /**
     * @param value Database version required by the user. Value options of Redis can refer to the latest docs [detail info](https://www.alibabacloud.com/help/doc-detail/60873.htm) `EngineVersion`. Value of Memcache should be empty.
     */
    @JvmName("hmapnwnrvdregnfb")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.engineVersion = mapped
    }

    /**
     * @param value Filter the results by charge type. Valid values: `PrePaid` and `PostPaid`. Default to `PrePaid`.
     */
    @JvmName("qctmxctrfvvsfxgg")
    public suspend fun instanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceChargeType = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi up`).
     */
    @JvmName("drkseedkypgrsnqd")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The Zone to launch the KVStore instance.
     */
    @JvmName("pxsdsvoksbnbwsil")
    public suspend fun zoneId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.zoneId = mapped
    }

    internal fun build(): GetInstanceEnginesPlainArgs = GetInstanceEnginesPlainArgs(
        engine = engine,
        engineVersion = engineVersion,
        instanceChargeType = instanceChargeType,
        outputFile = outputFile,
        zoneId = zoneId ?: throw PulumiNullFieldException("zoneId"),
    )
}
